/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.IHourglassTrigger;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.item.ModItems;

public class TileHourglass
extends TileSimpleInventory
implements ITickable {
    private static final String TAG_TIME = "time";
    private static final String TAG_TIME_FRACTION = "timeFraction";
    private static final String TAG_FLIP = "flip";
    private static final String TAG_FLIP_TICKS = "flipTicks";
    private static final String TAG_LOCK = "lock";
    private static final String TAG_MOVE = "move";
    private int time = 0;
    public float timeFraction = 0.0f;
    public float lastFraction = 0.0f;
    public boolean flip = false;
    public int flipTicks = 0;
    public boolean lock = false;
    public boolean move = true;

    private boolean isDust() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        return !stack.func_190926_b() && stack.func_77973_b() == ModItems.manaResource && stack.func_77960_j() == 23;
    }

    public void func_73660_a() {
        int totalTime = this.getTotalTime();
        boolean dust = this.isDust();
        if (totalTime > 0 || dust) {
            if (this.move && !dust) {
                ++this.time;
            }
            if (this.time >= totalTime) {
                this.time = 0;
                this.flip = !this.flip;
                this.flipTicks = 4;
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_180501_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(true)), 1);
                    this.field_145850_b.func_175684_a(this.field_174879_c, this.func_145838_q(), this.func_145838_q().func_149738_a(this.field_145850_b));
                }
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    BlockPos pos = this.func_174877_v().func_177972_a(facing);
                    IBlockState state = this.field_145850_b.func_180495_p(pos);
                    if (!(state.func_177230_c() instanceof IHourglassTrigger)) continue;
                    ((IHourglassTrigger)state.func_177230_c()).onTriggeredByHourglass(this.field_145850_b, pos, this);
                }
            }
            this.lastFraction = this.timeFraction;
            this.timeFraction = (float)this.time / (float)totalTime;
        } else {
            this.time = 0;
            this.lastFraction = 0.0f;
            this.timeFraction = 0.0f;
        }
        if (this.flipTicks > 0) {
            --this.flipTicks;
        }
    }

    public void onManaCollide() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isDust()) {
                ++this.time;
            } else {
                this.move = !this.move;
            }
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    public int getTotalTime() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.func_190926_b()) {
            return 0;
        }
        return TileHourglass.getStackItemTime(stack) * stack.func_190916_E();
    }

    public static int getStackItemTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150354_m)) {
            return stack.func_77952_i() == 1 ? 200 : 20;
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150425_aM)) {
            return 1200;
        }
        if (stack.func_77973_b() == ModItems.manaResource) {
            return 1;
        }
        return 0;
    }

    public int getColor() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.func_190926_b()) {
            return 0;
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150354_m)) {
            return stack.func_77952_i() == 1 ? 15292416 : 16772169;
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150425_aM)) {
            return 5914927;
        }
        if (stack.func_77973_b() == ModItems.manaResource) {
            return 240639;
        }
        return 0;
    }

    @Override
    protected TileSimpleInventory.SimpleItemStackHandler createItemHandler() {
        return new TileSimpleInventory.SimpleItemStackHandler(this, true){

            @Override
            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!stack.func_190926_b() && (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150354_m) || stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150425_aM)) || stack.func_77973_b() == ModItems.manaResource && stack.func_77952_i() == 23) {
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }

            @Override
            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                if (!((TileHourglass)TileHourglass.this).field_145850_b.field_72995_K) {
                    TileHourglass.this.time = 0;
                    TileHourglass.this.timeFraction = 0.0f;
                    VanillaPacketDispatcher.dispatchTEToNearbyPlayers(TileHourglass.this);
                }
            }
        };
    }

    @Override
    public void writePacketNBT(NBTTagCompound par1nbtTagCompound) {
        super.writePacketNBT(par1nbtTagCompound);
        par1nbtTagCompound.func_74768_a(TAG_TIME, this.time);
        par1nbtTagCompound.func_74776_a(TAG_TIME_FRACTION, this.timeFraction);
        par1nbtTagCompound.func_74757_a(TAG_FLIP, this.flip);
        par1nbtTagCompound.func_74768_a(TAG_FLIP_TICKS, this.flipTicks);
        par1nbtTagCompound.func_74757_a(TAG_MOVE, this.move);
        par1nbtTagCompound.func_74757_a(TAG_LOCK, this.lock);
    }

    @Override
    public void readPacketNBT(NBTTagCompound par1nbtTagCompound) {
        super.readPacketNBT(par1nbtTagCompound);
        this.time = par1nbtTagCompound.func_74762_e(TAG_TIME);
        this.timeFraction = par1nbtTagCompound.func_74760_g(TAG_TIME_FRACTION);
        this.flip = par1nbtTagCompound.func_74767_n(TAG_FLIP);
        this.flipTicks = par1nbtTagCompound.func_74762_e(TAG_FLIP_TICKS);
        this.move = par1nbtTagCompound.func_74767_n(TAG_MOVE);
        this.lock = par1nbtTagCompound.func_74767_n(TAG_LOCK);
    }

    @Override
    public int getSizeInventory() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUD(ScaledResolution res) {
        Minecraft mc = Minecraft.func_71410_x();
        int x = res.func_78326_a() / 2 + 10;
        int y = res.func_78328_b() / 2 - 10;
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (!stack.func_190926_b()) {
            RenderHelper.func_74520_c();
            GlStateManager.func_179091_B();
            mc.func_175599_af().func_175042_a(stack, x, y);
            mc.func_175599_af().func_175030_a(mc.field_71466_p, stack, x, y);
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            int time = this.getTotalTime();
            String timeStr = StringUtils.func_76337_a((int)time);
            mc.field_71466_p.func_175063_a(timeStr, (float)(x + 20), (float)y, this.getColor());
            String status = "";
            if (this.lock) {
                status = "locked";
            }
            if (!this.move) {
                String string = status = status.isEmpty() ? "stopped" : "lockedStopped";
            }
            if (!status.isEmpty()) {
                mc.field_71466_p.func_175063_a(I18n.func_135052_a((String)("botaniamisc." + status), (Object[])new Object[0]), (float)(x + 20), (float)(y + 12), this.getColor());
            }
        }
    }
}

