/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock;

import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.common.BeefCoreLog;
import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.common.CoordTriplet;
import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.IMultiblockPart;
import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.MultiblockControllerBase;
import com.bymarcin.zettaindustries.mods.battery.erogenousbeef.core.multiblock.MultiblockRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;

public abstract class MultiblockTileEntityBase
extends IMultiblockPart {
    private MultiblockControllerBase controller = null;
    private boolean visited = false;
    private boolean saveMultiblockData = false;
    private NBTTagCompound cachedMultiblockData = null;
    private boolean paused = false;

    @Override
    public Set<MultiblockControllerBase> attachToNeighbors() {
        IMultiblockPart[] partsToCheck;
        HashSet<MultiblockControllerBase> controllers = null;
        MultiblockControllerBase bestController = null;
        for (IMultiblockPart neighborPart : partsToCheck = this.getNeighboringParts()) {
            MultiblockControllerBase candidate;
            if (!neighborPart.isConnected() || !(candidate = neighborPart.getMultiblockController()).getClass().equals(this.getMultiblockControllerType())) continue;
            if (controllers == null) {
                controllers = new HashSet<MultiblockControllerBase>();
                bestController = candidate;
            } else if (!controllers.contains(candidate) && candidate.shouldConsume(bestController)) {
                bestController = candidate;
            }
            controllers.add(candidate);
        }
        if (bestController != null) {
            this.controller = bestController;
            bestController.attachBlock(this);
        }
        return controllers;
    }

    @Override
    public void assertDetached() {
        if (this.controller != null) {
            BeefCoreLog.info("[assert] Part @ (%d, %d, %d) should be detached already, but detected that it was not. This is not a fatal error, and will be repaired, but is unusual.", this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
            this.controller = null;
        }
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (data.func_74764_b("multiblockData")) {
            this.cachedMultiblockData = data.func_74775_l("multiblockData");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        if (this.isMultiblockSaveDelegate() && this.isConnected()) {
            NBTTagCompound multiblockData = new NBTTagCompound();
            this.controller.writeToNBT(multiblockData);
            data.func_74782_a("multiblockData", (NBTBase)multiblockData);
        }
        return data;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.detachSelf(false);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.detachSelf(true);
    }

    public void func_145829_t() {
        super.func_145829_t();
        MultiblockRegistry.onPartAdded(this.func_145831_w(), this);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound packetData = new NBTTagCompound();
        this.encodeDescriptionPacket(packetData);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, packetData);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.decodeDescriptionPacket(pkt.func_148857_g());
    }

    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
        if (this.isMultiblockSaveDelegate() && this.isConnected()) {
            NBTTagCompound tag = new NBTTagCompound();
            this.getMultiblockController().formatDescriptionPacket(tag);
            packetData.func_74782_a("multiblockData", (NBTBase)tag);
        }
    }

    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        if (packetData.func_74764_b("multiblockData")) {
            NBTTagCompound tag = packetData.func_74775_l("multiblockData");
            if (this.isConnected()) {
                this.getMultiblockController().decodeDescriptionPacket(tag);
            } else {
                this.cachedMultiblockData = tag;
            }
        }
    }

    @Override
    public boolean hasMultiblockSaveData() {
        return this.cachedMultiblockData != null;
    }

    @Override
    public NBTTagCompound getMultiblockSaveData() {
        return this.cachedMultiblockData;
    }

    @Override
    public void onMultiblockDataAssimilated() {
        this.cachedMultiblockData = null;
    }

    @Override
    public abstract void onMachineAssembled(MultiblockControllerBase var1);

    @Override
    public abstract void onMachineBroken();

    @Override
    public abstract void onMachineActivated();

    @Override
    public abstract void onMachineDeactivated();

    @Override
    public boolean isConnected() {
        return this.controller != null;
    }

    @Override
    public MultiblockControllerBase getMultiblockController() {
        return this.controller;
    }

    @Override
    public CoordTriplet getWorldLocation() {
        return new CoordTriplet(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
    }

    @Override
    public void becomeMultiblockSaveDelegate() {
        this.saveMultiblockData = true;
    }

    @Override
    public void forfeitMultiblockSaveDelegate() {
        this.saveMultiblockData = false;
    }

    @Override
    public boolean isMultiblockSaveDelegate() {
        return this.saveMultiblockData;
    }

    @Override
    public void setUnvisited() {
        this.visited = false;
    }

    @Override
    public void setVisited() {
        this.visited = true;
    }

    @Override
    public boolean isVisited() {
        return this.visited;
    }

    @Override
    public void onAssimilated(MultiblockControllerBase newController) {
        assert (this.controller != newController);
        this.controller = newController;
    }

    @Override
    public void onAttached(MultiblockControllerBase newController) {
        this.controller = newController;
    }

    @Override
    public void onDetached(MultiblockControllerBase oldController) {
        this.controller = null;
    }

    @Override
    public abstract MultiblockControllerBase createNewMultiblock();

    @Override
    public IMultiblockPart[] getNeighboringParts() {
        CoordTriplet[] neighbors = new CoordTriplet[]{new CoordTriplet(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()), new CoordTriplet(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p()), new CoordTriplet(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 1), new CoordTriplet(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 1), new CoordTriplet(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p()), new CoordTriplet(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p())};
        ArrayList<IMultiblockPart> neighborParts = new ArrayList<IMultiblockPart>();
        IChunkProvider chunkProvider = this.func_145831_w().func_72863_F();
        for (CoordTriplet neighbor : neighbors) {
            TileEntity te;
            Chunk chunk = chunkProvider.func_186026_b(neighbor.getChunkX(), neighbor.getChunkZ());
            if (chunk == null || !chunk.func_177410_o() || !((te = this.func_145831_w().func_175625_s(new BlockPos(neighbor.x, neighbor.y, neighbor.z))) instanceof IMultiblockPart)) continue;
            neighborParts.add((IMultiblockPart)te);
        }
        IMultiblockPart[] tmp = new IMultiblockPart[neighborParts.size()];
        return neighborParts.toArray(tmp);
    }

    @Override
    public void onOrphaned(MultiblockControllerBase controller, int oldSize, int newSize) {
        this.func_70296_d();
        this.func_145831_w().func_175646_b(this.field_174879_c, (TileEntity)this);
    }

    protected void notifyNeighborsOfBlockChange() {
        this.func_145831_w().func_175685_c(this.field_174879_c, this.func_145838_q(), false);
    }

    protected void notifyNeighborsOfTileChange() {
        this.func_145831_w().func_175685_c(this.field_174879_c, this.func_145838_q(), false);
    }

    protected void detachSelf(boolean chunkUnloading) {
        if (this.controller != null) {
            this.controller.detachBlock(this, chunkUnloading);
            this.controller = null;
        }
        MultiblockRegistry.onPartRemovedFromWorld(this.func_145831_w(), this);
    }
}

