/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.nfc;

import com.bymarcin.zettaindustries.ZettaIndustries;
import com.bymarcin.zettaindustries.modmanager.IMod;
import com.bymarcin.zettaindustries.mods.nfc.block.BlockNFCProgrammer;
import com.bymarcin.zettaindustries.mods.nfc.block.BlockNFCReader;
import com.bymarcin.zettaindustries.mods.nfc.item.ItemCardNFC;
import com.bymarcin.zettaindustries.mods.nfc.item.ItemPrivateCardNFC;
import com.bymarcin.zettaindustries.mods.nfc.smartcard.DyeableItemWashHandler;
import com.bymarcin.zettaindustries.mods.nfc.smartcard.SmartCardBlockTerminalRenderer;
import com.bymarcin.zettaindustries.mods.nfc.smartcard.SmartCardDyeRecipe;
import com.bymarcin.zettaindustries.mods.nfc.smartcard.SmartCardItem;
import com.bymarcin.zettaindustries.mods.nfc.smartcard.SmartCardItemColor;
import com.bymarcin.zettaindustries.mods.nfc.smartcard.SmartCardRackRenderer;
import com.bymarcin.zettaindustries.mods.nfc.smartcard.SmartCardTerminalBlock;
import com.bymarcin.zettaindustries.mods.nfc.smartcard.SmartCardTerminalItem;
import com.bymarcin.zettaindustries.mods.nfc.smartcard.SmartCardTerminalTileEntity;
import com.bymarcin.zettaindustries.mods.nfc.tileentity.TileEntityNFCProgrammer;
import com.bymarcin.zettaindustries.mods.nfc.tileentity.TileEntityNFCReader;
import com.bymarcin.zettaindustries.registry.ZIRegistry;
import com.bymarcin.zettaindustries.registry.proxy.IProxy;
import com.bymarcin.zettaindustries.utils.RecipeUtils;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import li.cil.oc.api.Driver;
import li.cil.oc.api.driver.DriverItem;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class NFC
implements IMod,
IProxy {
    public static BlockNFCProgrammer blockNFCProgrammer;
    public static BlockNFCReader blockNFCReader;
    public static ItemCardNFC itemCardNFC;
    public static ItemPrivateCardNFC itemPrivateCardNFC;
    public static Item itemBlockNFCProgrammer;
    public static Item itemBlockNFCReader;
    public static Item smartCardTerminalItemBlock;
    public static int dataCardHardLimit;
    public static int dataCardSoftLimit;
    public static int dataCardTimeout;
    public static double dataCardAsymmetric;
    public static double dataCardComplexByte;
    public static SmartCardItem smartCardItem;
    public static SmartCardTerminalItem smartCardTerminalItem;
    public static SmartCardTerminalBlock smartCardTerminalBlock;
    public static File saveDirParent;

    @Override
    public void preInit() {
        blockNFCProgrammer = new BlockNFCProgrammer();
        blockNFCReader = new BlockNFCReader();
        itemCardNFC = new ItemCardNFC();
        itemPrivateCardNFC = new ItemPrivateCardNFC();
        itemBlockNFCReader = (Item)new ItemBlock((Block)blockNFCReader).setRegistryName(blockNFCReader.getRegistryName());
        itemBlockNFCProgrammer = (Item)new ItemBlock((Block)blockNFCProgrammer).setRegistryName(blockNFCProgrammer.getRegistryName());
        GameRegistry.registerTileEntity(TileEntityNFCReader.class, (String)"nfcReader");
        GameRegistry.registerTileEntity(TileEntityNFCProgrammer.class, (String)"nfcprogrammer");
        smartCardItem = new SmartCardItem();
        smartCardTerminalItem = new SmartCardTerminalItem();
        smartCardTerminalBlock = new SmartCardTerminalBlock();
        smartCardTerminalItemBlock = (Item)new ItemBlock((Block)smartCardTerminalBlock).setRegistryName(smartCardTerminalBlock.getRegistryName());
        GameRegistry.registerTileEntity(SmartCardTerminalTileEntity.class, (String)"SmartCardTerminalTileEntity");
        ZIRegistry.registerProxy(this);
        MinecraftForge.EVENT_BUS.register((Object)new DyeableItemWashHandler());
    }

    @SubscribeEvent
    public void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{blockNFCProgrammer, blockNFCReader, smartCardTerminalBlock});
    }

    @SubscribeEvent
    public void onRegisterItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{itemBlockNFCProgrammer, itemBlockNFCReader, itemCardNFC, itemPrivateCardNFC, smartCardItem, smartCardTerminalItem, smartCardTerminalItemBlock});
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRegisterBlockColor(ColorHandlerEvent.Item event) {
        event.getItemColors().func_186730_a((IItemColor)new SmartCardItemColor(), new Item[]{smartCardItem});
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRegisterModels(ModelRegistryEvent event) {
        ZettaIndustries.proxy.registermodel(itemBlockNFCProgrammer, 0);
        ZettaIndustries.proxy.registermodel(itemBlockNFCReader, 0);
        ZettaIndustries.proxy.registermodel(itemCardNFC, 0);
        ZettaIndustries.proxy.registermodel(smartCardItem, 0);
        ZettaIndustries.proxy.registermodel(smartCardTerminalItem, 0);
        ZettaIndustries.proxy.registermodel(smartCardTerminalItemBlock, 0);
        ZettaIndustries.proxy.registermodel(itemPrivateCardNFC, 0);
        ZettaIndustries.proxy.registermodel(itemPrivateCardNFC, 1, new ModelResourceLocation("zettaindustries:itemprivatecardnfc_owner", "inventory"));
    }

    @SubscribeEvent
    public void onRegisterRecipes(RegistryEvent.Register<IRecipe> event) {
        ItemStack microChip1 = li.cil.oc.api.Items.get((String)"chip1").createItemStack(1);
        ItemStack microChip2 = li.cil.oc.api.Items.get((String)"chip2").createItemStack(1);
        ItemStack microChip3 = li.cil.oc.api.Items.get((String)"chip3").createItemStack(1);
        ItemStack cpu1 = li.cil.oc.api.Items.get((String)"cpu1").createItemStack(1);
        ItemStack interweb = li.cil.oc.api.Items.get((String)"interweb").createItemStack(1);
        ItemStack wifi = li.cil.oc.api.Items.get((String)"wlancard").createItemStack(1);
        ItemStack circuitBoard = li.cil.oc.api.Items.get((String)"printedcircuitboard").createItemStack(1);
        ItemStack paper = new ItemStack(Items.field_151121_aF, 1);
        ItemStack obsidian = new ItemStack(Blocks.field_150343_Z, 1);
        ItemStack pressurePlate = new ItemStack(Blocks.field_150456_au);
        ItemStack dataCard2 = li.cil.oc.api.Items.get((String)"datacard2").createItemStack(1);
        event.getRegistry().register((IForgeRegistryEntry)RecipeUtils.createShapedRecipe(new ItemStack((Block)blockNFCReader, 1), "i i", "cnw", "ibi", Character.valueOf('i'), "ingotIron", Character.valueOf('c'), microChip2, Character.valueOf('n'), interweb, Character.valueOf('w'), wifi, Character.valueOf('b'), circuitBoard).setRegistryName(blockNFCReader.getRegistryName()));
        event.getRegistry().register((IForgeRegistryEntry)RecipeUtils.createShapedRecipe(new ItemStack((Block)blockNFCProgrammer, 1), "i i", "cnw", "ibi", Character.valueOf('i'), "ingotIron", Character.valueOf('c'), cpu1, Character.valueOf('n'), interweb, Character.valueOf('w'), wifi, Character.valueOf('b'), circuitBoard).setRegistryName(blockNFCProgrammer.getRegistryName()));
        event.getRegistry().register((IForgeRegistryEntry)RecipeUtils.createShapedRecipe(new ItemStack((Item)itemCardNFC, 1), "ppp", "pcp", "ppp", Character.valueOf('p'), paper, Character.valueOf('c'), microChip1).setRegistryName(itemCardNFC.getRegistryName()));
        event.getRegistry().register((IForgeRegistryEntry)RecipeUtils.createShapedRecipe(new ItemStack((Item)itemPrivateCardNFC, 1), "ppp", "pcp", "ppp", Character.valueOf('p'), paper, Character.valueOf('c'), microChip2).setRegistryName(itemPrivateCardNFC.getRegistryName()));
        event.getRegistry().register((IForgeRegistryEntry)RecipeUtils.createShapedRecipe(new ItemStack((Item)smartCardItem, 1), "ppp", "pcp", "ppp", Character.valueOf('p'), paper, Character.valueOf('c'), microChip3).setRegistryName(new ResourceLocation("zettaindustries:smartcard_microchip")));
        event.getRegistry().register((IForgeRegistryEntry)RecipeUtils.createShapedRecipe(new ItemStack((Item)smartCardItem, 1), "ppp", "pcp", "ppp", Character.valueOf('p'), paper, Character.valueOf('c'), smartCardItem).setRegistryName(new ResourceLocation("zettaindustries:smartcard_smartcard")));
        event.getRegistry().register((IForgeRegistryEntry)RecipeUtils.createShapedRecipe(new ItemStack((Block)smartCardTerminalBlock, 1), "ici", "dp ", "ibi", Character.valueOf('p'), pressurePlate, Character.valueOf('c'), microChip2, Character.valueOf('i'), "ingotIron", Character.valueOf('d'), dataCard2, Character.valueOf('b'), circuitBoard).setRegistryName(smartCardTerminalBlock.getRegistryName()));
        event.getRegistry().register((IForgeRegistryEntry)RecipeUtils.createShapedRecipe(new ItemStack((Item)smartCardTerminalItem, 1), "ici", "dp ", "ibi", Character.valueOf('p'), pressurePlate, Character.valueOf('c'), microChip2, Character.valueOf('i'), obsidian, Character.valueOf('d'), dataCard2, Character.valueOf('b'), circuitBoard).setRegistryName(smartCardTerminalItem.getRegistryName()));
        event.getRegistry().register(new SmartCardDyeRecipe(Ingredient.func_193367_a((Item)smartCardItem)).setRegistryName("zettaindustries:smartcard_dye"));
    }

    public static UUID getUUIDForPlayer(String name) {
        GameProfile profile;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && (profile = server.func_152358_ax().func_152655_a(name)) != null) {
            return profile.getId();
        }
        return null;
    }

    @Override
    public void init() {
        Driver.add((DriverItem)smartCardItem);
        Driver.add((DriverItem)smartCardTerminalItem);
    }

    @Override
    public void postInit() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientSide() {
        ClientRegistry.bindTileEntitySpecialRenderer(SmartCardTerminalTileEntity.class, (TileEntitySpecialRenderer)new SmartCardBlockTerminalRenderer());
        MinecraftForge.EVENT_BUS.register((Object)new SmartCardRackRenderer());
    }

    @Override
    public void serverSide() {
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        saveDirParent = new File(new File(DimensionManager.getCurrentSaveRootDirectory(), "zettaindustries"), "smartnfc");
        if (!saveDirParent.exists()) {
            try {
                Files.createDirectories(saveDirParent.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        dataCardHardLimit = 0x100000;
        dataCardSoftLimit = 8192;
        dataCardTimeout = 1;
        dataCardAsymmetric = 10.0;
        dataCardComplexByte = 0.1;
        saveDirParent = null;
    }
}

