/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.nfc.smartcard;

import com.bymarcin.zettaindustries.ZettaIndustries;
import com.bymarcin.zettaindustries.mods.nfc.NFC;
import com.bymarcin.zettaindustries.mods.nfc.smartcard.IDyeableItem;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import li.cil.oc.api.driver.DriverItem;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.ManagedEnvironment;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SmartCardItem
extends Item
implements DriverItem,
IDyeableItem {
    public static final String PRIVATE_KEY = "sc:private_key";
    public static final String PUBLIC_KEY = "sc:public_key";
    public static final String UUID_KEY = "sc:uuid_key";
    public static final String OWNER_UUID = "sc:owner_uuid";
    public static final String OWNER_UUID_LEAST = "sc:owner_uuidLeast";
    public static SecureRandom srand;

    public SmartCardItem() {
        try {
            srand = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        this.func_77637_a(ZettaIndustries.tabZettaIndustries);
        this.func_77655_b("smartcard");
        this.setRegistryName("smartcard");
        this.func_77625_d(1);
        this.setNoRepair();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World p, List list, ITooltipFlag q) {
        super.func_77624_a(stack, p, list, q);
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            if (tag.func_74764_b(OWNER_UUID_LEAST)) {
                list.add("Protected");
            }
            if (tag.func_74764_b(UUID_KEY)) {
                list.add(tag.func_74779_i(UUID_KEY));
            }
        }
    }

    public static NBTTagCompound generateKeyPair() {
        NBTTagCompound tag = new NBTTagCompound();
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC");
            kpg.initialize(384, srand);
            KeyPair kp = kpg.generateKeyPair();
            tag.func_74773_a(PRIVATE_KEY, kp.getPrivate().getEncoded());
            tag.func_74773_a(PUBLIC_KEY, kp.getPublic().getEncoded());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return tag;
    }

    private static void saveNewUUID(NBTTagCompound tag) {
        String uuid = UUID.randomUUID().toString();
        NBTTagCompound keys = SmartCardItem.generateKeyPair();
        Path filePub = NFC.saveDirParent.toPath().resolve(uuid + ".pub");
        Path filePriv = NFC.saveDirParent.toPath().resolve(uuid + ".prv");
        try {
            Files.write(filePub, keys.func_74770_j(PUBLIC_KEY), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            Files.write(filePriv, keys.func_74770_j(PRIVATE_KEY), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            tag.func_74778_a(UUID_KEY, uuid);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static NBTTagCompound getNBT(ItemStack stack) {
        if (stack.func_77942_o()) {
            if (!stack.func_77978_p().func_74764_b(UUID_KEY)) {
                SmartCardItem.saveNewUUID(stack.func_77978_p());
            }
            return stack.func_77978_p();
        }
        NBTTagCompound tag = new NBTTagCompound();
        SmartCardItem.saveNewUUID(tag);
        stack.func_77982_d(tag);
        return tag;
    }

    public static byte[] getPrivateKey(ItemStack stack) {
        String uuid = SmartCardItem.getNBT(stack).func_74779_i(UUID_KEY);
        try {
            return Files.readAllBytes(NFC.saveDirParent.toPath().resolve(uuid + ".prv"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public static byte[] getPublicKey(ItemStack stack) {
        String uuid = SmartCardItem.getNBT(stack).func_74779_i(UUID_KEY);
        try {
            return Files.readAllBytes(NFC.saveDirParent.toPath().resolve(uuid + ".pub"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    @Nullable
    public static UUID getOwner(ItemStack stack) {
        UUID uuid;
        if (SmartCardItem.getNBT(stack).func_74764_b("sc:owner") && (uuid = NFC.getUUIDForPlayer(SmartCardItem.getNBT(stack).func_74779_i("sc:owner"))) != null) {
            SmartCardItem.getNBT(stack).func_82580_o("sc:owner");
            SmartCardItem.getNBT(stack).func_186854_a(OWNER_UUID, uuid);
        }
        if (!SmartCardItem.getNBT(stack).func_74764_b(OWNER_UUID_LEAST)) {
            return null;
        }
        return SmartCardItem.getNBT(stack).func_186857_a(OWNER_UUID);
    }

    public boolean worksWith(ItemStack stack) {
        return stack.func_77973_b().equals(this);
    }

    public ManagedEnvironment createEnvironment(ItemStack stack, EnvironmentHost host) {
        return null;
    }

    public String slot(ItemStack stack) {
        return "any";
    }

    public int tier(ItemStack stack) {
        return 0;
    }

    public NBTTagCompound dataTag(ItemStack stack) {
        return new NBTTagCompound();
    }

    @Override
    public boolean hasColor(ItemStack stack) {
        return SmartCardItem.getNBT(stack).func_74764_b("color");
    }

    @Override
    public int getColor(ItemStack stack) {
        return this.hasColor(stack) ? SmartCardItem.getNBT(stack).func_74762_e("color") : -1;
    }

    @Override
    public void setColor(ItemStack stack, int color) {
        SmartCardItem.getNBT(stack).func_74768_a("color", color & 0xFFFFFF);
    }

    @Override
    public boolean removeColor(ItemStack stack) {
        if (this.hasColor(stack)) {
            SmartCardItem.getNBT(stack).func_82580_o("color");
            return true;
        }
        return false;
    }
}

