/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.block.charge;

import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.block.charge.BlockConfusionCharge;
import crazypants.enderio.base.block.charge.EntityPrimedCharge;
import crazypants.enderio.base.block.charge.PacketExplodeEffect;
import crazypants.enderio.base.config.config.ZooConfig;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.base.teleport.RandomTeleportUtil;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticlePortal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEnderCharge
extends BlockConfusionCharge {
    public static BlockEnderCharge create(@Nonnull IModObject modObject) {
        return new BlockEnderCharge(modObject);
    }

    public BlockEnderCharge(@Nonnull IModObject modObject) {
        super(modObject);
    }

    @Override
    public void explode(@Nonnull EntityPrimedCharge entity) {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketExplodeEffect((Entity)entity, this), new BlockPos((Entity)entity), entity.field_70170_p);
        BlockEnderCharge.doEntityTeleport(entity);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void explodeEffect(@Nonnull World world, double x, double y, double z) {
        world.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, x, y, z, 1.0, 0.0, 0.0, new int[0]);
        BlockEnderCharge.doTeleportEffect(world, x, y, z);
    }

    @Nonnull
    protected static AxisAlignedBB getBoundsAround(Entity entity, double range) {
        return BlockEnderCharge.getBoundsAround(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, range);
    }

    public static void doEntityTeleport(EntityPrimedCharge entity) {
        World world = entity.func_130014_f_();
        world.func_184148_a((EntityPlayer)null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 1.0f, 1.4f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f);
        world.func_184148_a((EntityPlayer)null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 2.0f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f);
        AxisAlignedBB bb = BlockEnderCharge.getBoundsAround((Entity)entity, ZooConfig.enderChargeRange.get().floatValue());
        List ents = world.func_72872_a(EntityLivingBase.class, bb);
        for (EntityLivingBase ent : ents) {
            if (ent == null) continue;
            RandomTeleportUtil.teleportEntity(world, (Entity)ent, false, true, 64.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void doTeleportEffect(World world, double x, double y, double z) {
        Random random = world.field_73012_v;
        for (int i = 0; i < 100; ++i) {
            double d = random.nextDouble() * 2.0;
            double mag = 2.0;
            double motionX = (0.5 - random.nextDouble()) * mag * d;
            double motionY = (0.5 - random.nextDouble()) * mag;
            double motionZ = (0.5 - random.nextDouble()) * mag * d;
            Particle entityfx = new ParticlePortal.Factory().func_178902_a(i, world, x + motionX * 0.1, y + motionY * 0.1, z + motionZ * 0.1, motionX, motionY, motionZ, new int[0]);
            Minecraft.func_71410_x().field_71452_i.func_78873_a(entityfx);
        }
    }
}

