/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.capacitor;

import crazypants.enderio.api.capacitor.Scaler;
import javax.annotation.Nonnull;

public class IndexedScaler
implements Scaler {
    private final float scale;
    private final float[] keyValues;

    public IndexedScaler(float scale, float ... keyValues) {
        this.scale = scale;
        this.keyValues = keyValues;
    }

    @Nonnull
    public String store() {
        StringBuffer sb = new StringBuffer();
        sb.append("idx(");
        sb.append(this.scale);
        sb.append(")");
        for (float f : this.keyValues) {
            sb.append(":");
            sb.append(f);
        }
        return sb.toString();
    }

    @Override
    public float scaleValue(float idx) {
        float idx_scaled = idx / this.scale;
        int idxi = (int)idx_scaled;
        float idxf = idx_scaled - (float)idxi;
        if (idxi < 0) {
            return this.keyValues[0];
        }
        if (idxi >= this.keyValues.length - 1) {
            return this.keyValues[this.keyValues.length - 1];
        }
        return (1.0f - idxf) * this.keyValues[idxi] + idxf * this.keyValues[idxi + 1];
    }
}

