/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.factory;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.stackable.Things;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;

enum ByteBufHelper {
    INTEGER{

        @Override
        protected void saveValue(ByteBuf buf, @Nonnull Object value) {
            buf.writeInt(((Integer)value).intValue());
        }

        @Override
        protected Object readValue(ByteBuf buf) {
            return buf.readInt();
        }
    }
    ,
    DOUBLE{

        @Override
        protected void saveValue(ByteBuf buf, @Nonnull Object value) {
            buf.writeDouble(((Double)value).doubleValue());
        }

        @Override
        protected Object readValue(ByteBuf buf) {
            return buf.readDouble();
        }
    }
    ,
    FLOAT{

        @Override
        protected void saveValue(ByteBuf buf, @Nonnull Object value) {
            buf.writeFloat(((Float)value).floatValue());
        }

        @Override
        protected Object readValue(ByteBuf buf) {
            return Float.valueOf(buf.readFloat());
        }
    }
    ,
    STRING{

        @Override
        protected void saveValue(ByteBuf buf, @Nonnull Object value) {
            byte[] vbytes = ((String)value).getBytes(Charset.forName("UTF-8"));
            if (vbytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("String too long");
            }
            buf.writeShort(vbytes.length);
            buf.writeBytes(vbytes);
        }

        @Override
        protected Object readValue(ByteBuf buf) {
            short len = buf.readShort();
            byte[] bytes = new byte[len];
            buf.readBytes(bytes, 0, (int)len);
            return new String(bytes, Charset.forName("UTF-8"));
        }
    }
    ,
    STRING127{

        @Override
        protected void saveValue(ByteBuf buf, @Nonnull Object value) {
            byte[] vbytes = ((String)value).getBytes(Charset.forName("UTF-8"));
            if (vbytes.length > 127) {
                throw new RuntimeException("String too long");
            }
            buf.writeByte(vbytes.length);
            buf.writeBytes(vbytes);
        }

        @Override
        protected Object readValue(ByteBuf buf) {
            byte len = buf.readByte();
            byte[] bytes = new byte[len];
            buf.readBytes(bytes, 0, (int)len);
            return new String(bytes, Charset.forName("UTF-8"));
        }
    }
    ,
    BOOLEAN{

        @Override
        protected void saveValue(ByteBuf buf, @Nonnull Object value) {
            buf.writeBoolean(((Boolean)value).booleanValue());
        }

        @Override
        protected Object readValue(ByteBuf buf) {
            return buf.readBoolean();
        }
    }
    ,
    ENDMARKER{

        @Override
        protected void saveValue(ByteBuf buf, @Nonnull Object value) {
            buf.writeByte(0);
        }

        @Override
        protected Object readValue(ByteBuf buf) {
            buf.markReaderIndex();
            byte val = buf.readByte();
            if (val == 0) {
                return Boolean.TRUE;
            }
            buf.resetReaderIndex();
            return null;
        }
    }
    ,
    NONE{

        @Override
        protected void saveValue(ByteBuf buf, @Nonnull Object value) {
        }

        @Override
        protected Object readValue(ByteBuf buf) {
            return null;
        }
    }
    ,
    THINGS{

        @Override
        protected void saveValue(ByteBuf buf, @Nonnull Object value) {
            NNList nameList = ((Things)value).getNameList();
            if (nameList.size() > 127) {
                throw new RuntimeException("Thing too big");
            }
            buf.writeByte(nameList.size());
            for (String string : nameList) {
                STRING127.saveValue(buf, NullHelper.first((Object[])new String[]{string, ""}));
            }
        }

        @Override
        protected Object readValue(ByteBuf buf) {
            Things result = new Things();
            int len = buf.readByte();
            for (int i = 0; i < len; ++i) {
                result.add((String)STRING127.readValue(buf));
            }
            return result;
        }
    };


    protected abstract void saveValue(ByteBuf var1, @Nonnull Object var2);

    protected abstract Object readValue(ByteBuf var1);
}

