/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.factory;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.config.factory.IValue;
import crazypants.enderio.base.config.factory.IValueFactory;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class EnumValue<E extends Enum<E>>
implements IValue<E> {
    @Nonnull
    private final Class<E> enumClazz;
    @Nonnull
    private final E defaultEnumValue;
    @Nonnull
    private final IValue<String> storage;

    protected EnumValue(@Nonnull IValueFactory owner, @Nonnull String section, @Nonnull String keyname, @Nonnull E defaultValue, @Nonnull String text) {
        this.defaultEnumValue = defaultValue;
        this.enumClazz = (Class)NullHelper.notnull(((Enum)defaultValue).getDeclaringClass(), (String)"enum without a class");
        this.storage = owner.make(keyname, ((Enum)defaultValue).name(), (String[])NullHelper.notnullJ(Arrays.stream(this.enumClazz.getEnumConstants()).map(Enum::name).toArray(String[]::new), (String)"Stream.toArray"), text);
    }

    @Override
    @Nonnull
    public E get() {
        try {
            return Enum.valueOf(this.enumClazz, this.storage.get());
        }
        catch (IllegalArgumentException e) {
            return this.defaultEnumValue;
        }
    }

    @Override
    @Nonnull
    public IValue<E> sync() {
        this.storage.sync();
        return this;
    }
}

