/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.addon.IEnderIOAddon;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.Config;
import crazypants.enderio.base.config.config.RecipeConfig;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.RecipeFactory;
import crazypants.enderio.base.config.recipes.RecipeRoot;
import crazypants.enderio.base.config.recipes.xml.Aliases;
import crazypants.enderio.base.config.recipes.xml.Recipes;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Triple;

public class RecipeLoader {
    private static Map<String, String> imcRecipes = new HashMap<String, String>();

    private RecipeLoader() {
    }

    public static void addRecipes() {
        RecipeFactory recipeFactory = new RecipeFactory(Config.getConfigDirectory(), "enderio");
        recipeFactory.createFolder("recipes");
        recipeFactory.createFolder("recipes/user");
        recipeFactory.createFolder("recipes/examples");
        recipeFactory.placeXSD("recipes");
        recipeFactory.placeXSD("recipes/user");
        recipeFactory.placeXSD("recipes/examples");
        recipeFactory.createFileUser("recipes/user/user_recipes.xml");
        NNList coreFiles = new NNList();
        for (Object modContainer : Loader.instance().getModList()) {
            Object mod = modContainer.getMod();
            if (!(mod instanceof IEnderIOAddon)) continue;
            coreFiles.addAll(((IEnderIOAddon)mod).getRecipeFiles());
            for (String filename : ((IEnderIOAddon)mod).getExampleFiles()) {
                recipeFactory.copyCore("recipes/examples/" + filename + ".xml");
            }
        }
        Collections.sort(coreFiles, new Comparator<Triple<Integer, RecipeFactory, String>>(){

            @Override
            public int compare(Triple<Integer, RecipeFactory, String> o1, Triple<Integer, RecipeFactory, String> o2) {
                return ((Integer)o1.getLeft()).compareTo((Integer)o2.getLeft());
            }
        });
        HashSet<File> userfiles = new HashSet<File>((Collection<File>)recipeFactory.listXMLFiles("recipes/user"));
        for (Triple triple : coreFiles) {
            RecipeFactory factory = (RecipeFactory)triple.getMiddle();
            if (factory == null) continue;
            userfiles.addAll((Collection<File>)factory.listXMLFiles("recipes/user"));
        }
        for (Triple triple : coreFiles) {
            RecipeLoader.readCoreFile(new Aliases(), (RecipeFactory)NullHelper.first((Object[])new RecipeFactory[]{(RecipeFactory)triple.getMiddle(), recipeFactory}), "recipes/" + (String)triple.getRight());
        }
        if (imcRecipes != null) {
            RecipeLoader.handleIMCRecipes(new Aliases(), new Aliases());
        }
        for (File file : userfiles) {
            RecipeLoader.readUserFile(new Aliases(), recipeFactory, file.getName(), file);
        }
        Recipes config = new Recipes();
        if (RecipeConfig.loadCoreRecipes.get().booleanValue()) {
            try {
                for (Triple triple : coreFiles) {
                    config = (Recipes)RecipeLoader.readCoreFile(new Recipes(), (RecipeFactory)NullHelper.first((Object[])new RecipeFactory[]{(RecipeFactory)triple.getMiddle(), recipeFactory}), "recipes/" + (String)triple.getRight()).addRecipes(config, false);
                }
            }
            catch (InvalidRecipeConfigException e) {
                RecipeLoader.recipeError((String)NullHelper.first((Object[])new String[]{e.getFilename(), "Core Recipes"}), e.getMessage());
            }
        } else {
            Log.warn("Ender IO core recipe loading has been disabled in the configuration.");
            Log.warn("This is valid, but do NOT report recipe errors to the Ender IO team!");
        }
        if (imcRecipes != null) {
            config = RecipeLoader.handleIMCRecipes(new Recipes(), config);
            imcRecipes = null;
        }
        for (File file : userfiles) {
            Recipes userFile = RecipeLoader.readUserFile(new Recipes(), recipeFactory, file.getName(), file);
            if (userFile == null) continue;
            try {
                config = (Recipes)userFile.addRecipes(config, true);
            }
            catch (InvalidRecipeConfigException e) {
                RecipeLoader.recipeError((String)NullHelper.first((Object[])new String[]{e.getFilename(), file.getName()}), e.getMessage());
            }
        }
        config.register("");
        for (ModContainer modContainer : Loader.instance().getModList()) {
            Object mod = modContainer.getMod();
            if (!(mod instanceof IEnderIOAddon)) continue;
            ((IEnderIOAddon)mod).postRecipeRegistration();
        }
    }

    private static <T extends RecipeRoot> T handleIMCRecipes(T target, T config) {
        for (Map.Entry<String, String> recipe : imcRecipes.entrySet()) {
            try {
                InputStream is = IOUtils.toInputStream((String)recipe.getValue(), (Charset)Charset.forName("UTF-8"));
                Throwable throwable = null;
                try {
                    T recipes = RecipeFactory.readStax(target, "recipes", is);
                    recipes.enforceValidity();
                    config = recipes.addRecipes(config, true);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (InvalidRecipeConfigException e) {
                Log.error("Invalied recipe while parsing IMC:");
                e.printStackTrace();
                Log.error("IMC message:\n" + recipe.getValue());
                RecipeLoader.recipeError((String)NullHelper.first((Object[])new String[]{e.getFilename(), "IMC from the mod '" + recipe.getKey() + "'"}), e.getMessage());
            }
            catch (IOException e) {
                Log.error("IO error while parsing IMC:");
                e.printStackTrace();
                Log.error("IMC message:\n" + recipe.getValue());
                RecipeLoader.recipeError("IMC from the mod '" + recipe.getKey() + "'", "IO error while parsing string:" + e.getMessage());
            }
            catch (XMLStreamException e) {
                Log.error("IMC has malformed XML:");
                e.printStackTrace();
                Log.error("IMC message:\n" + recipe.getValue());
                RecipeLoader.recipeError("IMC from the mod '" + recipe.getKey() + "'", "IMC has malformed XML:" + e.getMessage());
            }
        }
        return config;
    }

    private static <T extends RecipeRoot> T readUserFile(T target, RecipeFactory recipeFactory, String filename, File file) {
        try {
            T recipes = RecipeFactory.readFileUser(target, "recipes", filename, file);
            if (recipes.isValid()) {
                recipes.enforceValidity();
                return recipes;
            }
        }
        catch (InvalidRecipeConfigException e) {
            RecipeLoader.recipeError((String)NullHelper.first((Object[])new String[]{e.getFilename(), filename}), e.getMessage());
        }
        catch (IOException e) {
            Log.error("IO error while reading file:");
            e.printStackTrace();
            RecipeLoader.recipeError(filename, "IO error while reading file:" + e.getMessage());
        }
        catch (XMLStreamException e) {
            Log.error("File has malformed XML:");
            e.printStackTrace();
            RecipeLoader.recipeError(filename, "File has malformed XML:" + e.getMessage());
        }
        return null;
    }

    private static <T extends RecipeRoot> T readCoreFile(T target, RecipeFactory recipeFactory, String filename) {
        try {
            T recipes = recipeFactory.readCoreFile(target, "recipes", filename + ".xml");
            if (recipes.isValid()) {
                recipes.enforceValidity();
                return recipes;
            }
            RecipeLoader.recipeError(filename, "File is empty or invalid");
        }
        catch (InvalidRecipeConfigException e) {
            RecipeLoader.recipeError((String)NullHelper.first((Object[])new String[]{e.getFilename(), filename + ".xml"}), e.getMessage());
        }
        catch (IOException e) {
            Log.error("IO error while reading file:");
            e.printStackTrace();
            RecipeLoader.recipeError(filename + ".xml", "IO error while reading file:" + e.getMessage());
        }
        catch (XMLStreamException e) {
            Log.error("File has malformed XML:");
            e.printStackTrace();
            RecipeLoader.recipeError(filename + ".xml", "File has malformed XML:" + e.getMessage());
        }
        return target;
    }

    public static void addIMCRecipe(String sender, String recipe) throws XMLStreamException, IOException {
        if (imcRecipes != null) {
            imcRecipes.put(sender, recipe);
        } else {
            try (InputStream is = IOUtils.toInputStream((String)recipe, (Charset)Charset.forName("UTF-8"));){
                Recipes recipes = RecipeFactory.readStax(new Recipes(), "recipes", is);
                recipes.enforceValidity();
                recipes.register("IMC recipes");
                return;
            }
            catch (InvalidRecipeConfigException e) {
                RecipeLoader.recipeError(recipe + " (IMC from other mod)", e.getMessage());
            }
            catch (IOException e) {
                Log.error("IO error while parsing string:");
                e.printStackTrace();
                RecipeLoader.recipeError("IMC from other mod", "IO error while parsing string:" + e.getMessage());
            }
            catch (XMLStreamException e) {
                Log.error("IMC has malformed XML:");
                e.printStackTrace();
                RecipeLoader.recipeError("IMC from other mod", "IMC has malformed XML:" + e.getMessage());
            }
        }
    }

    private static void recipeError(String filename, String message) {
        if (RecipeConfig.loadCoreRecipes.get().booleanValue()) {
            EnderIO.proxy.stopWithErrorScreen("=======================================================================", "== ENDER IO FATAL RECIPE ERROR ==", "=======================================================================", "Cannot register recipes as configured. This means that either", "your custom recipe files have an error or another mod does bad", "things to vanilla items or the Ore Dictionary.", "=======================================================================", "== Bad file ==", filename, "=======================================================================", "== Error Message ==", message, "=======================================================================", "", "=======================================================================", "Note: If this is a modpack, report to the modpack author, not to", "the Ender IO team.", "=======================================================================");
        } else {
            EnderIO.proxy.stopWithErrorScreen("=======================================================================", "== ENDER IO FATAL RECIPE ERROR ==", "=======================================================================", "Cannot register recipes as configured. This means that your custom ", "recipe files have an error.", "=======================================================================", "== Bad file ==", filename, "=======================================================================", "== Error Message ==", message, "=======================================================================", "", "=======================================================================", "Do NOT report this to the Ender IO team. If this is a modpack, report", "to the modpack author. If not, YOU made a mistake.", "=======================================================================");
        }
    }
}

