/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractConditional;
import crazypants.enderio.base.config.recipes.xml.Output;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public abstract class AbstractCrafting
extends AbstractConditional {
    protected List<Output> outputs;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        super.readResolve();
        if (this.outputs == null || this.outputs.isEmpty()) {
            throw new InvalidRecipeConfigException("Missing <output>");
        }
        this.valid = this.checkOutputCount(this.getOutputs().size());
        return this;
    }

    protected boolean checkOutputCount(int count) {
        return count == 1;
    }

    public Output getOutput() {
        for (Output output : this.outputs) {
            if (!output.isValid() || !output.isActive()) continue;
            return output;
        }
        return null;
    }

    public List<Output> getOutputs() {
        ArrayList<Output> result = new ArrayList<Output>();
        for (Output output : this.outputs) {
            if (!output.isValid() || !output.isActive()) continue;
            result.add(output);
        }
        return result;
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        return super.setAttribute(factory, name, value);
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("output".equals(name)) {
            if (this.outputs == null) {
                this.outputs = new ArrayList<Output>();
            }
            this.outputs.add(factory.read(new Output(), startElement));
            return true;
        }
        return super.setElement(factory, name, startElement);
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        for (Output output : this.outputs) {
            if (!output.isActive()) continue;
            output.enforceValidity();
        }
    }
}

