/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.RecipeConfigElement;
import crazypants.enderio.base.config.recipes.StaxFactory;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class Fluid
implements RecipeConfigElement {
    protected String name;
    protected String nbt;
    protected transient net.minecraftforge.fluids.Fluid fluid;
    private transient NBTTagCompound tag;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new InvalidRecipeConfigException("Missing fluid name");
        }
        this.fluid = FluidRegistry.getFluid((String)this.name);
        String nbt_nullchecked = this.nbt;
        if (nbt_nullchecked != null && !nbt_nullchecked.trim().isEmpty()) {
            try {
                this.tag = JsonToNBT.func_180713_a((String)nbt_nullchecked);
            }
            catch (NBTException e) {
                throw new InvalidRecipeConfigException(nbt_nullchecked + " is not valid NBT json.");
            }
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        if (!this.isValid()) {
            throw new InvalidRecipeConfigException("Could not find a fluid for '" + this.name);
        }
    }

    @Override
    public boolean isValid() {
        return this.fluid != null;
    }

    public net.minecraftforge.fluids.Fluid getFluid() {
        return this.fluid;
    }

    @Nonnull
    public FluidStack getFluidStack() {
        return new FluidStack(this.fluid, 1000, this.tag);
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("name".equals(name)) {
            this.name = value;
            return true;
        }
        if ("nbt".equals(name)) {
            this.nbt = value;
            return true;
        }
        return false;
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        return false;
    }
}

