/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractConditional;
import crazypants.enderio.base.config.recipes.xml.Item;
import crazypants.enderio.base.recipe.ThingsRecipeInput;
import crazypants.enderio.base.recipe.sagmill.GrindingBall;
import crazypants.enderio.base.recipe.sagmill.SagMillRecipeManager;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class Grindingball
extends AbstractConditional {
    private String name;
    private boolean required;
    private boolean disabled;
    private Item item;
    private float grinding = 1.0f;
    private float chance = 1.0f;
    private float power = 1.0f;
    private int durability = 0;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        if (this.disabled) {
            return this;
        }
        try {
            super.readResolve();
            if (this.item == null) {
                throw new InvalidRecipeConfigException("Missing <item>");
            }
            if (this.durability <= 0) {
                throw new InvalidRecipeConfigException("'durability' is invalid'");
            }
            if (this.grinding <= 0.0f || this.grinding > 5.0f) {
                throw new InvalidRecipeConfigException("'grinding' is invalid'");
            }
            if (this.chance <= 0.0f || this.chance > 5.0f) {
                throw new InvalidRecipeConfigException("'chance' is invalid'");
            }
            if (this.power <= 0.0f || this.power > 5.0f) {
                throw new InvalidRecipeConfigException("'power' is invalid'");
            }
            this.valid = this.item.isValid();
            if (this.required && !this.valid && this.active) {
                throw new InvalidRecipeConfigException("No valid <item>");
            }
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <grindingball>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        if (this.disabled || !this.active) {
            return;
        }
        this.item.enforceValidity();
    }

    @Override
    public void register(@Nonnull String recipeName) {
        if (!this.disabled && this.valid && this.active) {
            Log.debug("Registering XML recipe '" + this.getName() + "'");
            SagMillRecipeManager.getInstance().addBall(new GrindingBall(new ThingsRecipeInput(this.item.getThing()), this.grinding, this.chance, this.power, this.durability));
        } else {
            Log.debug("Skipping XML recipe '" + this.getName() + "' (valid=" + this.valid + ", active=" + this.active + ", required=" + this.required + ", disabled=" + this.disabled + ")");
        }
    }

    @Override
    @Nonnull
    public String getName() {
        if (this.name != null && !this.name.trim().isEmpty()) {
            return this.name.trim();
        }
        return "unnamed recipe";
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("name".equals(name)) {
            this.name = value;
            return true;
        }
        if ("required".equals(name)) {
            this.required = Boolean.parseBoolean(value);
            return true;
        }
        if ("disabled".equals(name)) {
            this.disabled = Boolean.parseBoolean(value);
            return true;
        }
        if ("grinding".equals(name)) {
            this.grinding = Float.parseFloat(value);
            return true;
        }
        if ("chance".equals(name)) {
            this.chance = Float.parseFloat(value);
            return true;
        }
        if ("power".equals(name)) {
            this.power = Float.parseFloat(value);
            return true;
        }
        if ("durability".equals(name)) {
            this.durability = Integer.parseInt(value);
            return true;
        }
        return super.setAttribute(factory, name, value);
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("item".equals(name) && this.item == null) {
            this.item = (Item)factory.read(new Item().setAllowDelaying(false), startElement);
            return true;
        }
        return super.setElement(factory, name, startElement);
    }

    @Override
    public boolean isValid() {
        return this.disabled || super.isValid();
    }

    @Override
    public boolean isActive() {
        return !this.disabled && super.isActive();
    }
}

