/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.gui;

import com.enderio.core.api.client.gui.IGuiOverlay;
import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.gui.button.TooltipButton;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.filter.gui.AbstractFilterGui;
import crazypants.enderio.base.filter.gui.ContainerFilter;
import crazypants.enderio.base.filter.gui.FilterGuiUtil;
import crazypants.enderio.base.filter.item.ExistingItemFilter;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.base.filter.network.PacketExistingItemFilterSnapshot;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.network.PacketHandler;
import java.awt.Rectangle;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ExistingItemFilterGui
extends AbstractFilterGui {
    private static final int ID_NBT = FilterGuiUtil.nextButtonId();
    private static final int ID_META = FilterGuiUtil.nextButtonId();
    private static final int ID_ORE_DICT = FilterGuiUtil.nextButtonId();
    private static final int ID_STICKY = FilterGuiUtil.nextButtonId();
    private static final int ID_SNAPSHOT = FilterGuiUtil.nextButtonId();
    private static final int ID_CLEAR = FilterGuiUtil.nextButtonId();
    private static final int ID_SHOW = FilterGuiUtil.nextButtonId();
    private static final int ID_MERGE = FilterGuiUtil.nextButtonId();
    private static final int ID_WHITELIST = FilterGuiUtil.nextButtonId();
    @Nonnull
    private ToggleButton useMetaB;
    @Nonnull
    private ToggleButton useNbtB;
    @Nonnull
    private ToggleButton useOreDictB;
    @Nonnull
    private ToggleButton stickyB;
    @Nonnull
    private final IconButton whiteListB;
    @Nonnull
    private TooltipButton snapshotB;
    @Nonnull
    private TooltipButton clearB;
    @Nonnull
    private TooltipButton showB;
    @Nonnull
    private TooltipButton mergeB;
    @Nonnull
    private SnapshotOverlay snapshotOverlay;
    @Nonnull
    private ExistingItemFilter filter;

    public ExistingItemFilterGui(@Nonnull InventoryPlayer playerInv, @Nonnull ContainerFilter filterContainer, TileEntity te, @Nonnull IItemFilter filterIn) {
        super(playerInv, filterContainer, te, filterIn);
        this.filter = (ExistingItemFilter)filterIn;
        int butLeft = 20;
        int x = this.getGuiLeft() + butLeft;
        int y = this.getGuiTop() + 36;
        this.useMetaB = new ToggleButton((IGuiScreen)this, ID_META, x, y, (IWidgetIcon)IconEIO.FILTER_META_OFF, (IWidgetIcon)IconEIO.FILTER_META);
        this.useMetaB.setSelectedToolTip(new String[]{Lang.GUI_ITEM_FILTER_MATCH_META.get()});
        this.useMetaB.setUnselectedToolTip(new String[]{Lang.GUI_ITEM_FILTER_IGNORE_META.get()});
        this.useMetaB.setPaintSelectedBorder(false);
        this.whiteListB = new IconButton((IGuiScreen)this, ID_WHITELIST, x += 20, y, (IWidgetIcon)IconEIO.FILTER_WHITELIST);
        this.whiteListB.setToolTip(new String[]{Lang.GUI_ITEM_FILTER_WHITELIST.get()});
        this.useNbtB = new ToggleButton((IGuiScreen)this, ID_NBT, x += 20, y, (IWidgetIcon)IconEIO.FILTER_NBT_OFF, (IWidgetIcon)IconEIO.FILTER_NBT);
        this.useNbtB.setSelectedToolTip(new String[]{Lang.GUI_ITEM_FILTER_MATCH_NBT.get()});
        this.useNbtB.setUnselectedToolTip(new String[]{Lang.GUI_ITEM_FILTER_IGNORE_NBT.get()});
        this.useNbtB.setPaintSelectedBorder(false);
        this.useOreDictB = new ToggleButton((IGuiScreen)this, ID_ORE_DICT, x += 20, y, (IWidgetIcon)IconEIO.FILTER_ORE_DICT_OFF, (IWidgetIcon)IconEIO.FILTER_ORE_DICT);
        this.useOreDictB.setSelectedToolTip(new String[]{Lang.GUI_ITEM_FILTER_ORE_DIC_ENABLED.get()});
        this.useOreDictB.setUnselectedToolTip(new String[]{Lang.GUI_ITEM_FILTER_ORE_DIC_DISABLED.get()});
        this.useOreDictB.setPaintSelectedBorder(false);
        this.stickyB = new ToggleButton((IGuiScreen)this, ID_STICKY, x += 20, y, (IWidgetIcon)IconEIO.FILTER_STICKY_OFF, (IWidgetIcon)IconEIO.FILTER_STICKY);
        this.stickyB.setSelectedToolTip(new String[]{Lang.GUI_ITEM_FILTER_STICKY_ENABLED.get(), Lang.GUI_ITEM_FILTER_STICKY_ENABLED_2.get()});
        this.stickyB.setUnselectedToolTip(new String[]{Lang.GUI_ITEM_FILTER_STICKY_DISABLED.get()});
        this.stickyB.setPaintSelectedBorder(false);
        x = butLeft;
        this.snapshotB = new TooltipButton((IGuiScreen)this, ID_SNAPSHOT, x, y += 24, 60, 20, Lang.GUI_EXISTING_ITEM_FILTER_SNAPSHOT.get());
        this.mergeB = new TooltipButton((IGuiScreen)this, ID_MERGE, x += 64, y, 40, 20, Lang.GUI_EXISTING_ITEM_FILTER_MERGE.get());
        this.clearB = new TooltipButton((IGuiScreen)this, ID_CLEAR, x -= 64, y += 24, 60, 20, Lang.GUI_EXISTING_ITEM_FILTER_CLEAR.get());
        this.showB = new TooltipButton((IGuiScreen)this, ID_SHOW, x += 64, y, 40, 20, Lang.GUI_EXISTING_ITEM_FILTER_SHOW.get());
        this.snapshotB.setToolTip(new String[]{Lang.GUI_EXISTING_ITEM_FILTER_SNAPSHOT_2.get()});
        this.mergeB.setToolTip(new String[]{Lang.GUI_EXISTING_ITEM_FILTER_MERGE_2.get()});
        this.clearB.setToolTip(new String[]{Lang.GUI_EXISTING_ITEM_FILTER_CLEAR_2.get()});
        this.showB.setToolTip(new String[]{Lang.GUI_EXISTING_ITEM_FILTER_SHOW_2.get()});
        this.snapshotOverlay = new SnapshotOverlay();
        this.addOverlay(this.snapshotOverlay);
    }

    @Override
    public void updateButtons() {
        super.updateButtons();
        this.useNbtB.onGuiInit();
        this.useNbtB.setSelected(this.filter.isMatchNBT());
        this.useOreDictB.onGuiInit();
        this.useOreDictB.setSelected(this.filter.isUseOreDict());
        if (this.isStickyModeAvailable) {
            this.stickyB.onGuiInit();
            this.stickyB.setSelected(this.filter.isSticky());
        }
        this.useMetaB.onGuiInit();
        this.useMetaB.setSelected(this.filter.isMatchMeta());
        this.whiteListB.onGuiInit();
        if (this.filter.isBlacklist()) {
            this.whiteListB.setIcon((IWidgetIcon)IconEIO.FILTER_BLACKLIST);
            this.whiteListB.setToolTip(new String[]{Lang.GUI_ITEM_FILTER_BLACKLIST.get()});
        } else {
            this.whiteListB.setIcon((IWidgetIcon)IconEIO.FILTER_WHITELIST);
            this.whiteListB.setToolTip(new String[]{Lang.GUI_ITEM_FILTER_WHITELIST.get()});
        }
        this.snapshotB.onGuiInit();
        this.clearB.onGuiInit();
        this.mergeB.onGuiInit();
        this.showB.onGuiInit();
        this.clearB.setEnabled(this.filter.getSnapshot() != null);
        this.mergeB.setEnabled(this.clearB.isEnabled());
        this.showB.setEnabled(this.clearB.isEnabled());
    }

    @Override
    public void func_146284_a(@Nonnull GuiButton guiButton) throws IOException {
        super.func_146284_a(guiButton);
        if (guiButton.field_146127_k == ID_META) {
            this.filter.setMatchMeta(this.useMetaB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_NBT) {
            this.filter.setMatchNBT(this.useNbtB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_STICKY) {
            this.filter.setSticky(this.stickyB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_ORE_DICT) {
            this.filter.setUseOreDict(this.useOreDictB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_SNAPSHOT) {
            this.sendSnapshotPacket(PacketExistingItemFilterSnapshot.Opcode.SET);
        } else if (guiButton.field_146127_k == ID_CLEAR) {
            this.sendSnapshotPacket(PacketExistingItemFilterSnapshot.Opcode.CLEAR);
        } else if (guiButton.field_146127_k == ID_MERGE) {
            this.sendSnapshotPacket(PacketExistingItemFilterSnapshot.Opcode.MERGE);
        } else if (guiButton.field_146127_k == ID_SHOW) {
            this.showSnapshotOverlay();
        } else if (guiButton.field_146127_k == ID_WHITELIST) {
            this.filter.setBlacklist(!this.filter.isBlacklist());
            this.sendFilterChange();
        }
    }

    public void func_73876_c() {
        this.updateSnapshotButtons();
        super.func_73876_c();
    }

    private void updateSnapshotButtons() {
        this.clearB.setEnabled(this.filter.getSnapshot() != null);
        this.mergeB.setEnabled(this.clearB.isEnabled());
        this.showB.setEnabled(this.clearB.isEnabled());
    }

    private void showSnapshotOverlay() {
        this.snapshotOverlay.setIsVisible(true);
    }

    private void sendSnapshotPacket(PacketExistingItemFilterSnapshot.Opcode opcode) {
        TileEntity te = this.filterContainer.getTileEntity();
        if (te != null) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketExistingItemFilterSnapshot(te, this.filter, this.filterContainer.getFilterIndex(), this.filterContainer.getParam1(), opcode));
        }
    }

    @Override
    @Nonnull
    protected String getUnlocalisedNameForHeading() {
        return Lang.GUI_EXISTING_ITEM_FILTER.get();
    }

    class SnapshotOverlay
    implements IGuiOverlay {
        boolean visible;

        SnapshotOverlay() {
        }

        public void init(@Nonnull IGuiScreen screen) {
        }

        @Nonnull
        public Rectangle getBounds() {
            return new Rectangle(0, 0, ExistingItemFilterGui.this.field_146999_f, ExistingItemFilterGui.this.field_147000_g);
        }

        public void draw(int mouseX, int mouseY, float partialTick) {
            RenderHelper.func_74520_c();
            GlStateManager.func_179147_l();
            RenderUtil.renderQuad2D((double)8.0, (double)8.0, (double)0.0, (double)(ExistingItemFilterGui.this.getXSize() - 11), (double)(ExistingItemFilterGui.this.getYSize() - 11), (Vector4f)new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
            RenderUtil.renderQuad2D((double)10.0, (double)10.0, (double)0.0, (double)(ExistingItemFilterGui.this.getXSize() - 15), (double)(ExistingItemFilterGui.this.getYSize() - 15), (Vector4f)new Vector4f(0.6, 0.6, 0.6, 1.0));
            RenderItem itemRenderer = ExistingItemFilterGui.this.field_146297_k.func_175599_af();
            GlStateManager.func_179126_j();
            NNList<ItemStack> snapshot = ExistingItemFilterGui.this.filter.getSnapshot();
            int x = 15;
            int y = 10;
            int count = 0;
            for (ItemStack st : snapshot) {
                if (!st.func_190926_b()) {
                    itemRenderer.func_180450_b(st, x, y);
                }
                x += 20;
                if (++count % 9 != 0) continue;
                x = 15;
                y += 20;
            }
        }

        public void setIsVisible(boolean visible) {
            this.visible = visible;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public boolean handleMouseInput(int x, int y, int b) {
            return true;
        }

        public boolean isMouseInBounds(int mouseX, int mouseY) {
            return this.getBounds().contains(mouseX, mouseY);
        }

        public void guiClosed() {
        }
    }
}

