/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.item;

import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.network.NetworkUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.filter.gui.DamageMode;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.base.filter.item.ILimitedItemFilter;
import crazypants.enderio.base.filter.item.items.BasicFilterTypes;
import crazypants.enderio.util.NbtValue;
import crazypants.enderio.util.Prep;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class ItemFilter
implements IInventory,
IItemFilter.WithGhostSlots,
ILimitedItemFilter {
    private static final boolean DEFAULT_BLACKLIST = false;
    private static final boolean DEFAULT_META = true;
    private static final boolean DEFAULT_NBT = true;
    private static final boolean DEFAULT_ORE_DICT = false;
    private static final boolean DEFAULT_STICKY = false;
    private boolean isBlacklist = false;
    private boolean matchMeta = true;
    private boolean matchNBT;
    private boolean useOreDict;
    private boolean sticky;
    @Nonnull
    private DamageMode damageMode = DamageMode.DISABLED;
    @Nonnull
    private NNList<ItemStack> items;
    @Nonnull
    private final List<int[]> oreIds;
    private boolean isAdvanced;
    private boolean isLimited;
    private boolean isBig;
    @Nonnull
    private static final NBTTagCompound EMPTY_NBT = new NBTTagCompound();

    public void copyFrom(@Nonnull ItemFilter o) {
        this.isBlacklist = o.isBlacklist;
        this.matchMeta = o.matchMeta;
        this.matchNBT = o.matchNBT;
        this.useOreDict = o.useOreDict;
        this.sticky = o.sticky;
        this.damageMode = o.damageMode;
        this.items = o.items.copy();
        this.oreIds.clear();
        this.oreIds.addAll(o.oreIds);
        this.isAdvanced = o.isAdvanced;
        this.isLimited = o.isLimited;
        this.isBig = o.isBig;
    }

    public ItemFilter() {
        this(BasicFilterTypes.filterUpgradeBasic);
    }

    public ItemFilter(BasicFilterTypes type) {
        this.isAdvanced = type.isAdvanced();
        this.isLimited = type.isLimited();
        this.isBig = type.isBig();
        int numItems = type.getSlots();
        this.items = new NNList(numItems, (Object)Prep.getEmpty());
        this.oreIds = new ArrayList<int[]>(numItems);
        for (int i = 0; i < numItems; ++i) {
            this.oreIds.add(null);
        }
        boolean bl = this.matchNBT = this.isAdvanced;
        if (this.isAdvanced) {
            // empty if block
        }
        this.useOreDict = false;
        if (this.isAdvanced) {
            // empty if block
        }
        this.sticky = false;
    }

    @Override
    public boolean doesItemPassFilter(@Nullable IItemHandler inventory, @Nonnull ItemStack item) {
        return !this.isValid() || this.itemMatched(item).isPass(this.isBlacklist);
    }

    @Override
    public int getMaxCountThatPassesFilter(@Nullable IItemHandler inventory, @Nonnull ItemStack item) {
        if (this.isValid()) {
            FilterResult value = this.itemMatched(item);
            if (this.isLimited && value.hasLimit()) {
                return value.getLimit();
            }
            if (!this.isLimited && this.itemMatched(item).isPass(this.isBlacklist)) {
                return Integer.MAX_VALUE;
            }
        }
        return 0;
    }

    private FilterResult itemMatched(@Nonnull ItemStack item) {
        if (this.damageMode.passesFilter(item)) {
            boolean canPassFilter = this.damageMode != DamageMode.DISABLED;
            for (int i = 0; i < this.items.size(); ++i) {
                ItemStack filterStack = (ItemStack)this.items.get(i);
                if (!Prep.isValid(filterStack)) continue;
                if (!(item.func_77973_b() != filterStack.func_77973_b() || this.matchMeta && item.func_77981_g() && item.func_77952_i() != filterStack.func_77952_i() || this.matchNBT && !this.isNBTMatch(item, filterStack))) {
                    return new FilterResult(filterStack.func_190916_E());
                }
                if (this.useOreDict && this.isOreDicMatch(i, item)) {
                    return new FilterResult(filterStack.func_190916_E());
                }
                canPassFilter = false;
            }
            return canPassFilter ? FilterResult.PASS : FilterResult.FAIL;
        }
        return FilterResult.FAIL;
    }

    private boolean isOreDicMatch(int filterItemIndex, @Nonnull ItemStack item) {
        int[] ids1 = this.getCachedIds(filterItemIndex);
        if (ids1.length == 0) {
            return false;
        }
        int[] ids2 = OreDictionary.getOreIDs((ItemStack)item);
        if (ids2 == null || ids2.length == 0) {
            return false;
        }
        for (int id1 : ids1) {
            for (int id2 : ids2) {
                if (id1 != id2) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNBTMatch(@Nonnull ItemStack filter, @Nonnull ItemStack item) {
        return this.getTag(filter).equals((Object)this.getTag(item));
    }

    @Nonnull
    private NBTTagCompound getTag(@Nonnull ItemStack item) {
        if (Prep.isInvalid(item) || !item.func_77942_o()) {
            return EMPTY_NBT;
        }
        NBTTagCompound nbt = item.func_77978_p();
        if (nbt == null || nbt.func_82582_d()) {
            return EMPTY_NBT;
        }
        if (nbt.func_74764_b("GEN")) {
            nbt = nbt.func_74737_b();
            nbt.func_82580_o("GEN");
        }
        return nbt;
    }

    @Nonnull
    private int[] getCachedIds(int filterItemIndex) {
        int[] res = this.oreIds.get(filterItemIndex);
        if (res == null) {
            ItemStack item = (ItemStack)this.items.get(filterItemIndex);
            if (Prep.isInvalid(item)) {
                res = new int[]{};
            } else {
                res = OreDictionary.getOreIDs((ItemStack)item);
                if (res == null) {
                    res = new int[]{};
                }
            }
            this.oreIds.set(filterItemIndex, res);
        }
        return res;
    }

    @Override
    public boolean isValid() {
        if (this.damageMode != DamageMode.DISABLED) {
            return true;
        }
        for (ItemStack item : this.items) {
            if (item == null || !Prep.isValid(item)) continue;
            return true;
        }
        return false;
    }

    public boolean isBlacklist() {
        return this.isBlacklist;
    }

    public void setBlacklist(boolean isBlacklist) {
        this.isBlacklist = isBlacklist;
    }

    public boolean isMatchMeta() {
        return this.matchMeta;
    }

    public void setMatchMeta(boolean matchMeta) {
        this.matchMeta = matchMeta;
    }

    public boolean isMatchNBT() {
        return this.matchNBT;
    }

    public void setMatchNBT(boolean matchNbt) {
        this.matchNBT = matchNbt;
    }

    public boolean isUseOreDict() {
        return this.useOreDict;
    }

    public void setUseOreDict(boolean useOreDict) {
        this.useOreDict = useOreDict;
    }

    @Override
    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    public DamageMode getDamageMode() {
        return this.damageMode;
    }

    public void setDamageMode(@Nonnull DamageMode damageMode) {
        this.damageMode = damageMode;
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        NbtValue.FILTER_BLACKLIST.setBoolean(nbtRoot, this.isBlacklist);
        NbtValue.FILTER_META.setBoolean(nbtRoot, this.matchMeta);
        NbtValue.FILTER_NBT.setBoolean(nbtRoot, this.matchNBT);
        NbtValue.FILTER_OREDICT.setBoolean(nbtRoot, this.useOreDict);
        NbtValue.FILTER_STICKY.setBoolean(nbtRoot, this.sticky);
        NbtValue.FILTER_ADVANCED.setBoolean(nbtRoot, this.isAdvanced);
        NbtValue.FILTER_LIMITED.setBoolean(nbtRoot, this.isLimited);
        NbtValue.FILTER_BIG.setBoolean(nbtRoot, this.isBig);
        NbtValue.FILTER_DAMAGE.setInt(nbtRoot, this.damageMode.ordinal());
        final NBTTagList tagList = new NBTTagList();
        this.items.apply((NNList.Callback)new NNList.Callback<ItemStack>(){

            public void apply(@Nonnull ItemStack item) {
                NBTTagCompound itemTag = new NBTTagCompound();
                if (Prep.isValid(item)) {
                    item.func_77955_b(itemTag);
                    tagList.func_74742_a((NBTBase)itemTag);
                }
            }
        });
        nbtRoot.func_74782_a("items", (NBTBase)tagList);
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        int numItems;
        this.isBlacklist = NbtValue.FILTER_BLACKLIST.getBoolean(nbtRoot);
        this.matchMeta = NbtValue.FILTER_META.getBoolean(nbtRoot);
        this.matchNBT = NbtValue.FILTER_NBT.getBoolean(nbtRoot);
        this.useOreDict = NbtValue.FILTER_OREDICT.getBoolean(nbtRoot);
        this.sticky = NbtValue.FILTER_STICKY.getBoolean(nbtRoot);
        this.isAdvanced = NbtValue.FILTER_ADVANCED.getBoolean(nbtRoot);
        this.isLimited = NbtValue.FILTER_LIMITED.getBoolean(nbtRoot);
        this.isBig = NbtValue.FILTER_BIG.getBoolean(nbtRoot);
        this.damageMode = (DamageMode)((Object)NullHelper.notnullJ((Object)((Object)DamageMode.values()[NbtValue.FILTER_DAMAGE.getInt(nbtRoot) & 0xFF]), (String)"Enum.values()"));
        this.items.clear();
        NBTTagList tagList = nbtRoot.func_150295_c("items", (int)nbtRoot.func_74732_a());
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            this.items.add((Object)new ItemStack(tagList.func_150305_b(i)));
        }
        int n = this.isBig ? BasicFilterTypes.filterUpgradeBig.getSlots() : (numItems = this.isAdvanced ? BasicFilterTypes.filterUpgradeAdvanced.getSlots() : BasicFilterTypes.filterUpgradeBasic.getSlots());
        while (this.items.size() < numItems) {
            this.items.add((Object)Prep.getEmpty());
        }
        this.oreIds.clear();
        for (int i = 0; i < numItems; ++i) {
            this.oreIds.add(null);
        }
    }

    @Override
    public void writeToByteBuf(@Nonnull ByteBuf buf) {
        NBTTagCompound root = new NBTTagCompound();
        this.writeToNBT(root);
        NetworkUtil.writeNBTTagCompound((NBTTagCompound)root, (ByteBuf)buf);
    }

    @Override
    public void readFromByteBuf(@Nonnull ByteBuf buf) {
        NBTTagCompound tag = NetworkUtil.readNBTTagCompound((ByteBuf)buf);
        this.readFromNBT(tag);
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    @Nonnull
    public ItemStack func_70301_a(int i) {
        if (i < 0 || i >= this.items.size()) {
            return Prep.getEmpty();
        }
        return (ItemStack)this.items.get(i);
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int amount) {
        if (index < 0 || index >= this.items.size()) {
            return Prep.getEmpty();
        }
        this.oreIds.set(index, null);
        return ((ItemStack)this.items.get(index)).func_77979_a(amount);
    }

    public void func_70299_a(int index, @Nonnull ItemStack itemstack) {
        if (index < 0 || index >= this.items.size()) {
            return;
        }
        ItemStack copy = itemstack.func_77946_l();
        copy.func_190920_e(1);
        this.items.set(index, (Object)copy);
        this.oreIds.set(index, null);
    }

    @Override
    @Nonnull
    public ItemStack getInventorySlotContents(int slot) {
        if (slot < 0 || slot >= this.items.size()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.items.get(slot);
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        if (index < 0 || index >= this.items.size()) {
            return Prep.getEmpty();
        }
        ItemStack res = (ItemStack)this.items.get(index);
        this.items.set(index, (Object)Prep.getEmpty());
        return res;
    }

    public void func_174888_l() {
        for (int index = 0; index < this.items.size(); ++index) {
            this.items.set(index, (Object)Prep.getEmpty());
        }
    }

    @Nonnull
    public String func_70005_c_() {
        return "Item Filter";
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70296_d() {
    }

    public void func_174889_b(@Nonnull EntityPlayer e) {
    }

    public void func_174886_c(@Nonnull EntityPlayer e) {
    }

    public boolean func_94041_b(int i, @Nonnull ItemStack itemstack) {
        return true;
    }

    @Override
    public void createGhostSlots(@Nonnull NNList<GhostSlot> slots, int xOffset, int yOffset, @Nullable Runnable cb) {
        int topY = yOffset;
        int leftX = xOffset;
        int index = 0;
        int numRows = this.isBig ? 4 : (this.isAdvanced ? 2 : 1);
        int rowSpacing = this.isBig ? 0 : 2;
        int numCols = this.isBig ? 9 : 5;
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < numCols; ++col) {
                int x = leftX + col * 18;
                int y = topY + row * 18 + rowSpacing * row;
                slots.add((Object)new ItemFilterGhostSlot(index, x, y, cb));
                ++index;
            }
        }
    }

    @Override
    public int getSlotCount() {
        return this.func_70302_i_();
    }

    public boolean isAdvanced() {
        return this.isAdvanced;
    }

    @Override
    public boolean isLimited() {
        return this.isLimited;
    }

    public boolean isBig() {
        return this.isBig;
    }

    public boolean isDefault() {
        return !this.isAdvanced && !this.isValid() && !this.isBlacklist && this.matchMeta && this.matchNBT && !this.useOreDict && !this.sticky && !this.isBig;
    }

    public String toString() {
        return "ItemFilter [isAdvanced=" + this.isAdvanced + ", items=" + this.items + "]";
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public boolean func_191420_l() {
        for (ItemStack s : this.items) {
            if (s.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return true;
    }

    public static class FilterResult {
        static final FilterResult PASS = new FilterResult(true);
        static final FilterResult FAIL = new FilterResult(false);
        private final boolean pass;
        private final int limit;

        private FilterResult(boolean pass) {
            this.pass = pass;
            this.limit = -1;
        }

        public FilterResult(int limit) {
            this.pass = true;
            this.limit = limit;
        }

        public boolean isPass() {
            return this.pass;
        }

        public boolean isPass(boolean invert) {
            return this.pass != invert;
        }

        public int getLimit() {
            return this.limit;
        }

        public boolean hasLimit() {
            return this.pass && this.limit >= 0;
        }
    }

    class ItemFilterGhostSlot
    extends GhostSlot {
        private final Runnable cb;

        ItemFilterGhostSlot(int slot, int x, int y, Runnable cb) {
            this.setX(x);
            this.setY(y);
            this.setSlot(slot);
            this.cb = cb;
            this.setDisplayStdOverlay(ItemFilter.this.isLimited);
            this.setStackSizeLimit(ItemFilter.this.isLimited ? 192 : 1);
        }

        public void putStack(@Nonnull ItemStack stack, int realsize) {
            if (Prep.isValid(stack)) {
                stack = stack.func_77946_l();
                stack.func_190920_e(MathHelper.func_76125_a((int)realsize, (int)1, (int)this.getStackSizeLimit()));
            }
            ItemFilter.this.items.set(this.getSlot(), (Object)stack);
            this.cb.run();
        }

        @Nonnull
        public ItemStack getStack() {
            return (ItemStack)ItemFilter.this.items.get(this.getSlot());
        }
    }
}

