/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.item.items;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.TileEntityBase;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.filter.FilterRegistry;
import crazypants.enderio.base.filter.IFilterContainer;
import crazypants.enderio.base.filter.gui.BasicItemFilterGui;
import crazypants.enderio.base.filter.gui.ContainerFilter;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.base.filter.item.ItemFilter;
import crazypants.enderio.base.filter.item.items.BasicFilterTypes;
import crazypants.enderio.base.filter.item.items.IItemFilterItemUpgrade;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.util.NbtValue;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBasicItemFilter
extends Item
implements IItemFilterItemUpgrade,
IResourceTooltipProvider {
    protected BasicFilterTypes filterType;

    public static ItemBasicItemFilter createBasicItemFilter(@Nonnull IModObject modObject) {
        return new ItemBasicItemFilter(modObject, BasicFilterTypes.filterUpgradeBasic);
    }

    public static ItemBasicItemFilter createAdvancedItemFilter(@Nonnull IModObject modObject) {
        return new ItemBasicItemFilter(modObject, BasicFilterTypes.filterUpgradeAdvanced);
    }

    public static ItemBasicItemFilter createLimitedItemFilter(@Nonnull IModObject modObject) {
        return new ItemBasicItemFilter(modObject, BasicFilterTypes.filterUpgradeLimited);
    }

    public static ItemBasicItemFilter createBigItemFilter(@Nonnull IModObject modObject) {
        return new ItemBasicItemFilter(modObject, BasicFilterTypes.filterUpgradeBig);
    }

    public static ItemBasicItemFilter createBigAdvancedItemFilter(@Nonnull IModObject modObject) {
        return new ItemBasicItemFilter(modObject, BasicFilterTypes.filterUpgradeBigAdvanced);
    }

    protected ItemBasicItemFilter(@Nonnull IModObject modObject, BasicFilterTypes filterType) {
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        modObject.apply(this);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77625_d(64);
        this.filterType = filterType;
    }

    @Override
    public IItemFilter createFilterFromStack(@Nonnull ItemStack stack) {
        ItemFilter filter = new ItemFilter(this.filterType);
        NBTTagCompound tag = NbtValue.FILTER.getTag(stack);
        if (!tag.func_82582_d()) {
            filter.readFromNBT(tag);
        }
        return filter;
    }

    @Nonnull
    public String getUnlocalizedNameForTooltip(@Nonnull ItemStack itemStack) {
        return this.func_77658_a();
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        if (!world.field_72995_K && player.func_70093_af()) {
            ModObject.itemBasicItemFilter.openGui(world, player.func_180425_c(), player, null, hand.ordinal());
            return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        return super.func_77659_a(world, player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (FilterRegistry.isFilterSet(stack) && SpecialTooltipHandler.showAdvancedTooltips()) {
            tooltip.add(Lang.ITEM_FILTER_CONFIGURED.get(TextFormatting.ITALIC));
            tooltip.add(Lang.ITEM_FILTER_CLEAR.get(TextFormatting.ITALIC));
        }
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getClientGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1) {
        Container container = player.field_71070_bA;
        if (container != null && container instanceof IFilterContainer) {
            return new BasicItemFilterGui(player.field_71071_by, new ContainerFilter(player, (TileEntityBase)world.func_175625_s(pos), facing, param1), world.func_175625_s(pos), (IItemFilter)((IFilterContainer)container).getFilter(param1));
        }
        return new BasicItemFilterGui(player.field_71071_by, new ContainerFilter(player, null, facing, param1), null, (IItemFilter)FilterRegistry.getFilterForUpgrade(player.func_184586_b(EnumHand.values()[param1])));
    }
}

