/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.item.items;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.TileEntityBase;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.capability.ItemTools;
import crazypants.enderio.base.filter.FilterRegistry;
import crazypants.enderio.base.filter.IFilterContainer;
import crazypants.enderio.base.filter.gui.ContainerFilter;
import crazypants.enderio.base.filter.gui.ExistingItemFilterGui;
import crazypants.enderio.base.filter.item.ExistingItemFilter;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.base.filter.item.items.IItemFilterItemUpgrade;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.util.NbtValue;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class ItemExistingItemFilter
extends Item
implements IItemFilterItemUpgrade,
IResourceTooltipProvider {
    public static ItemExistingItemFilter create(@Nonnull IModObject modObject) {
        return new ItemExistingItemFilter(modObject);
    }

    protected ItemExistingItemFilter(@Nonnull IModObject modObject) {
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        modObject.apply(this);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(64);
    }

    @Override
    public IItemFilter createFilterFromStack(@Nonnull ItemStack stack) {
        ExistingItemFilter filter = new ExistingItemFilter();
        NBTTagCompound tag = NbtValue.FILTER.getTag(stack);
        filter.readFromNBT(tag);
        return filter;
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        IItemHandler externalInventory;
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (player.func_70093_af() && (externalInventory = ItemTools.getExternalInventory((IBlockAccess)world, pos, side)) != null) {
            ItemStack heldItem = player.func_184586_b(hand);
            ExistingItemFilter filter = (ExistingItemFilter)this.createFilterFromStack(heldItem);
            player.func_146105_b((ITextComponent)(filter.mergeSnapshot(externalInventory) ? Lang.ITEM_FILTER_UPDATED.toChatServer() : Lang.ITEM_FILTER_NOTUPDATED.toChatServer()), true);
            FilterRegistry.writeFilterToStack(filter, heldItem);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        if (!worldIn.field_72995_K && playerIn.func_70093_af()) {
            ModObject.itemExistingItemFilter.openGui(worldIn, playerIn.func_180425_c(), playerIn, null, handIn.ordinal());
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Nonnull
    public String getUnlocalizedNameForTooltip(@Nonnull ItemStack stack) {
        return this.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (FilterRegistry.isFilterSet(stack) && SpecialTooltipHandler.showAdvancedTooltips()) {
            tooltip.add(Lang.ITEM_FILTER_CONFIGURED.get(TextFormatting.ITALIC));
            tooltip.add(Lang.ITEM_FILTER_CLEAR.get(TextFormatting.ITALIC));
        }
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getClientGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1) {
        Container container = player.field_71070_bA;
        if (container != null && container instanceof IFilterContainer) {
            return new ExistingItemFilterGui(player.field_71071_by, new ContainerFilter(player, (TileEntityBase)world.func_175625_s(pos), facing, param1), world.func_175625_s(pos), (IItemFilter)((IFilterContainer)container).getFilter(param1));
        }
        return new ExistingItemFilterGui(player.field_71071_by, new ContainerFilter(player, null, facing, param1), null, (IItemFilter)FilterRegistry.getFilterForUpgrade(player.func_184586_b(EnumHand.values()[param1])));
    }
}

