/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.gui.handler;

import com.mojang.authlib.GameProfile;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.gui.handler.GuiHandler;
import crazypants.enderio.base.gui.handler.IEioGuiHandler;
import crazypants.enderio.base.init.ModObjectRegistry;
import crazypants.enderio.base.lang.Lang;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.BlockPosContext;
import net.minecraftforge.server.permission.context.IContext;
import net.minecraftforge.server.permission.context.PlayerContext;

public class GuiHelper {
    public static void init(@Nonnull FMLInitializationEvent event) {
        for (IModObject mo : ModObjectRegistry.getRegistry()) {
            if (!(mo.getBlock() instanceof IEioGuiHandler.WithServerComponent) && !(mo.getItem() instanceof IEioGuiHandler.WithServerComponent)) continue;
            Log.info("Registered permission ", PermissionAPI.registerNode((String)GuiHelper.getPermission(mo), (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)("Permission to open the GUI(s) of Ender IO's " + mo.getUnlocalisedName())));
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)EnderIO.getInstance(), (IGuiHandler)new GuiHandler());
    }

    public static boolean openGui(@Nonnull IModObject mo, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer entityPlayer, @Nullable EnumFacing side, int param) {
        if (!world.field_72995_K) {
            if (PermissionAPI.hasPermission((GameProfile)entityPlayer.func_146103_bH(), (String)GuiHelper.getPermission(mo), (IContext)new BlockPosContext(entityPlayer, pos, world.func_180495_p(pos), side))) {
                return GuiHelper.openGui(world, entityPlayer, GuiHelper.getID(mo), pos, side, param, 0, 0);
            }
            entityPlayer.func_146105_b((ITextComponent)Lang.GUI_PERMISSION_DENIED.toChatServer(), true);
            entityPlayer.func_71053_j();
            return false;
        }
        return true;
    }

    public static boolean openGui(@Nonnull IModObject mo, @Nonnull World world, @Nonnull EntityPlayer entityPlayer, int a, int b, int c) {
        if (!world.field_72995_K) {
            if (PermissionAPI.hasPermission((GameProfile)entityPlayer.func_146103_bH(), (String)GuiHelper.getPermission(mo), (IContext)new PlayerContext(entityPlayer))) {
                return GuiHelper.openGui(world, entityPlayer, GuiHelper.getID(mo), null, null, a, b, c);
            }
            entityPlayer.func_146105_b((ITextComponent)Lang.GUI_PERMISSION_DENIED.toChatServer(), true);
            entityPlayer.func_71053_j();
            return false;
        }
        return true;
    }

    public static boolean openClientGui(@Nonnull IModObject mo, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer entityPlayer, @Nullable EnumFacing side, int param) {
        if (world.field_72995_K) {
            return GuiHelper.openGui(world, entityPlayer, GuiHelper.getID(mo), pos, side, param, 0, 0);
        }
        return false;
    }

    public static boolean openClientGui(@Nonnull IModObject mo, @Nonnull World world, @Nonnull EntityPlayer entityPlayer, int a, int b, int c) {
        if (world.field_72995_K) {
            return GuiHelper.openGui(world, entityPlayer, GuiHelper.getID(mo), null, null, a, b, c);
        }
        return false;
    }

    protected static boolean openGui(@Nonnull World world, @Nonnull EntityPlayer entityPlayer, int id, @Nullable BlockPos pos, @Nullable EnumFacing facing, int param1, int param2, int param3) {
        int c;
        int b;
        int a = (facing == null ? 255 : facing.ordinal()) | id << 8;
        if (pos != null) {
            long posl = pos.func_177986_g();
            b = (int)posl;
            c = (int)(posl >>> 32);
            if (param2 != 0 | param3 != 0) {
                Log.warn("Invalid parameters 2+3 together with pos for gui " + id);
            }
        } else {
            b = param2;
            c = param3;
        }
        int d = param1;
        entityPlayer.openGui((Object)EnderIO.getInstance(), a, world, b, c, d);
        return true;
    }

    protected static int getID(@Nonnull IModObject mo) {
        int id = ModObjectRegistry.getRegistry().getID((IForgeRegistryEntry)mo);
        if (id < 0) {
            throw new RuntimeException("Cannot open GUI for object " + mo + " because it is not registered.");
        }
        return id & 0xFFFFFF;
    }

    @Nonnull
    protected static IModObject getFromID(int id) {
        IModObject modObject = (IModObject)ModObjectRegistry.getRegistry().getValue(id);
        if (modObject == null) {
            throw new RuntimeException("Failed to open GUI " + id + "---not a valid ID");
        }
        return modObject;
    }

    @Nonnull
    protected static String getPermission(@Nonnull IModObject mo) {
        if (mo.getBlock() instanceof IEioGuiHandler.WithServerComponent || mo.getItem() instanceof IEioGuiHandler.WithServerComponent) {
            return "enderio.gui." + mo.getUnlocalisedName();
        }
        throw new RuntimeException("Cannot open GUI for object " + mo + " because it has no server-side GUI handler.");
    }
}

