/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler.darksteel;

import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.mojang.authlib.GameProfile;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.base.config.Config;
import crazypants.enderio.base.handler.darksteel.PacketDarkSteelPowerPacket;
import crazypants.enderio.base.handler.darksteel.PacketDarkSteelSFXPacket;
import crazypants.enderio.base.handler.darksteel.PacketUpgradeState;
import crazypants.enderio.base.handler.darksteel.UpgradeRegistry;
import crazypants.enderio.base.integration.top.TheOneProbeUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.elytra.ElytraUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.item.darksteel.upgrade.glider.GliderUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.jump.JumpUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.nightvision.NightVisionUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.speed.SpeedController;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.base.power.PowerHandlerUtil;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MovementInput;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="enderio")
public class DarkSteelController {
    private static final EnumSet<PacketUpgradeState.Type> DEFAULT_ACTIVE = EnumSet.of(PacketUpgradeState.Type.SPEED, PacketUpgradeState.Type.STEP_ASSIST, PacketUpgradeState.Type.JUMP);
    private static ThreadLocal<Data> DATA = new ThreadLocal<Data>(){

        @Override
        protected Data initialValue() {
            return new Data();
        }
    };
    private static final float MAGIC_STEP_HEIGHT = 1.0023f;

    private static EnumSet<PacketUpgradeState.Type> getActiveSet(EntityPlayer player) {
        Object active;
        GameProfile gameProfile = player.func_146103_bH();
        UUID id = gameProfile.getId();
        Object object = active = id == null ? null : (EnumSet)DATA.get().allActive.get(id);
        if (active == null) {
            active = DEFAULT_ACTIVE.clone();
            if (id != null) {
                DATA.get().allActive.put(id, active);
            }
        }
        return active;
    }

    public static boolean isActive(EntityPlayer player, PacketUpgradeState.Type type) {
        return DarkSteelController.getActiveSet(player).contains((Object)type);
    }

    public static void setActive(EntityPlayer player, PacketUpgradeState.Type type, boolean isActive) {
        EnumSet<PacketUpgradeState.Type> set = DarkSteelController.getActiveSet(player);
        if (isActive) {
            set.add(type);
        } else {
            set.remove((Object)type);
        }
    }

    public static boolean isGlideActive(EntityPlayer player) {
        return DarkSteelController.isActive(player, PacketUpgradeState.Type.GLIDE);
    }

    public static boolean isSpeedActive(EntityPlayer player) {
        return DarkSteelController.isActive(player, PacketUpgradeState.Type.SPEED);
    }

    public static boolean isStepAssistActive(EntityPlayer player) {
        return DarkSteelController.isActive(player, PacketUpgradeState.Type.STEP_ASSIST);
    }

    public static boolean isJumpActive(EntityPlayer player) {
        return DarkSteelController.isActive(player, PacketUpgradeState.Type.JUMP);
    }

    public static boolean isElytraActive(EntityPlayer player) {
        return DarkSteelController.isActive(player, PacketUpgradeState.Type.ELYTRA);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        final EntityPlayer player = event.player;
        if (event.phase == TickEvent.Phase.START && !player.func_175149_v()) {
            DarkSteelController.updateStepHeightAndFallDistance(player);
            SpeedController.updateSpeed(player);
            NNList.of(EntityEquipmentSlot.class).apply((NNList.Callback)new NNList.Callback<EntityEquipmentSlot>(){

                public void apply(@Nonnull EntityEquipmentSlot slot) {
                    ItemStack item = player.func_184582_a(slot);
                    if (item.func_77973_b() instanceof IDarkSteelItem) {
                        for (IDarkSteelUpgrade upgrade : UpgradeRegistry.getUpgrades()) {
                            if (!upgrade.hasUpgrade(item)) continue;
                            upgrade.onPlayerTick(item, (IDarkSteelItem)item.func_77973_b(), player);
                        }
                    }
                }
            });
        }
    }

    public static boolean isGliderUpgradeEquipped(EntityPlayer player) {
        ItemStack chestPlate = player.func_184582_a(EntityEquipmentSlot.CHEST);
        return GliderUpgrade.INSTANCE.hasUpgrade(chestPlate);
    }

    public static boolean isElytraUpgradeEquipped(EntityPlayer player) {
        ItemStack chestPlate = player.func_184582_a(EntityEquipmentSlot.CHEST);
        return DarkSteelController.isElytraUpgradeEquipped(chestPlate);
    }

    public static boolean isElytraUpgradeEquipped(@Nonnull ItemStack chestPlate) {
        return ElytraUpgrade.INSTANCE.hasUpgrade(chestPlate);
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        int energyStored;
        ItemStack boots;
        float distance = event.getDistance();
        if (distance > 3.0f && (boots = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.FEET)).func_77973_b() instanceof IDarkSteelItem && (energyStored = EnergyUpgradeManager.getEnergyStored(boots)) > 0) {
            float toMitigate = distance - 3.0f;
            int energyCost = (int)Math.min((double)energyStored, Math.ceil(toMitigate * (float)Config.darkSteelFallDistanceCost));
            float mitigated = (float)energyCost / (float)Config.darkSteelFallDistanceCost;
            if (!event.getEntity().field_70170_p.field_72995_K) {
                EnergyUpgradeManager.extractEnergy(boots, (IDarkSteelItem)boots.func_77973_b(), energyCost, false);
            }
            if (mitigated < toMitigate) {
                event.setDistance(distance - mitigated);
            } else {
                event.setCanceled(true);
            }
        }
    }

    private static void updateStepHeightAndFallDistance(EntityPlayer player) {
        if (player.field_70138_W < 1.0023f && !player.func_70093_af() && JumpUpgrade.isEquipped(player) && DarkSteelController.isStepAssistActive(player)) {
            player.field_70138_W = 1.0023f;
        } else if (player.field_70138_W == 1.0023f) {
            player.field_70138_W = 0.6f;
        }
    }

    public static void usePlayerEnergy(EntityPlayer player, EntityEquipmentSlot armorSlot, int cost) {
        if (cost == 0) {
            return;
        }
        int remaining = cost;
        if (Config.darkSteelDrainPowerFromInventory) {
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                int used;
                IEnergyStorage cap = PowerHandlerUtil.getCapability((ItemStack)NullHelper.notnullM((Object)stack, (String)"null stack in main player inventory"));
                if (cap == null || !cap.canExtract() || (remaining -= (used = cap.extractEnergy(remaining, false))) > 0) continue;
                return;
            }
        }
        if (armorSlot != null && remaining > 0) {
            ItemStack stack = player.func_184582_a(armorSlot);
            EnergyUpgradeManager.extractEnergy(stack, remaining, false);
        }
    }

    public static int getPlayerEnergy(EntityPlayer player, EntityEquipmentSlot slot) {
        int res = 0;
        if (Config.darkSteelDrainPowerFromInventory) {
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                IEnergyStorage cap = PowerHandlerUtil.getCapability((ItemStack)NullHelper.notnullM((Object)stack, (String)"null stack in main player inventory"));
                if (cap == null || !cap.canExtract()) continue;
                res += cap.extractEnergy(Integer.MAX_VALUE, true);
            }
        }
        if (slot != null) {
            ItemStack stack = player.func_184582_a(slot);
            res = EnergyUpgradeManager.getEnergyStored(stack);
        }
        return res;
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof EntityPlayerMP) {
            for (PacketUpgradeState.Type type : PacketUpgradeState.Type.values()) {
                PacketHandler.sendTo(new PacketUpgradeState(type, DarkSteelController.isActive((EntityPlayer)event.getTarget(), type), event.getTarget().func_145782_y()), (EntityPlayerMP)event.getEntityPlayer());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (NullHelper.untrust((Object)player) == null) {
            return;
        }
        if (NullHelper.untrust((Object)player.field_71158_b) == null) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            DATA.get().jumpPre = player.field_71158_b.field_78901_c;
            return;
        }
        DarkSteelController.updateNightvision((EntityPlayer)player);
        if (player.field_71075_bZ.field_75100_b) {
            return;
        }
        MovementInput input = player.field_71158_b;
        boolean jumpHandled = false;
        if (input.field_78901_c && (!DATA.get().wasJumping || DATA.get().ticksSinceLastJump > 5)) {
            jumpHandled = DarkSteelController.doJump(player);
        }
        if (!jumpHandled && input.field_78901_c && !DATA.get().jumpPre && !player.field_70122_E && player.field_70181_x < 0.0 && !player.field_71075_bZ.field_75100_b && DarkSteelController.isElytraUpgradeEquipped((EntityPlayer)player) && !DarkSteelController.isElytraActive((EntityPlayer)player)) {
            DarkSteelController.setActive((EntityPlayer)player, PacketUpgradeState.Type.ELYTRA, true);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketUpgradeState(PacketUpgradeState.Type.ELYTRA, true));
        }
        DATA.get().wasJumping = !player.field_70122_E;
        if (!DATA.get().wasJumping) {
            DATA.get().jumpCount = 0;
        }
        DATA.get().ticksSinceLastJump++;
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean doJump(EntityPlayerSP player) {
        if (!DarkSteelController.isJumpActive((EntityPlayer)player)) {
            return false;
        }
        ItemStack boots = player.func_184582_a(EntityEquipmentSlot.FEET);
        JumpUpgrade jumpUpgrade = JumpUpgrade.loadAnyFromItem(boots);
        if (jumpUpgrade == null) {
            return false;
        }
        boolean autoJump = Minecraft.func_71410_x().field_71474_y.func_74308_b(GameSettings.Options.AUTO_JUMP);
        if (autoJump && DATA.get().jumpCount <= 0) {
            DATA.get().jumpCount++;
            return false;
        }
        int autoJumpOffset = autoJump ? 1 : 0;
        int requiredPower = Config.darkSteelBootsJumpPowerCost * (int)Math.pow(DATA.get().jumpCount + 1 - autoJumpOffset, 2.5);
        int availablePower = DarkSteelController.getPlayerEnergy((EntityPlayer)player, EntityEquipmentSlot.FEET);
        int maxJumps = jumpUpgrade.getLevel() + autoJumpOffset;
        if (availablePower > 0 && requiredPower <= availablePower && DATA.get().jumpCount < maxJumps) {
            DATA.get().jumpCount++;
            player.field_70181_x += 0.15 * Config.darkSteelBootsJumpModifier * (double)(DATA.get().jumpCount - autoJumpOffset);
            DATA.get().ticksSinceLastJump = 0;
            DarkSteelController.usePlayerEnergy((EntityPlayer)player, EntityEquipmentSlot.FEET, requiredPower);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketDarkSteelPowerPacket(requiredPower, EntityEquipmentSlot.FEET));
            jumpUpgrade.doMultiplayerSFX((EntityPlayer)player);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketDarkSteelSFXPacket(jumpUpgrade, (EntityPlayer)player));
            return true;
        }
        return false;
    }

    private static void updateNightvision(EntityPlayer player) {
        if (DarkSteelController.isNightVisionUpgradeEquipped(player) && DATA.get().nightVisionActive) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 210, 0, true, true));
        }
        if (!DarkSteelController.isNightVisionUpgradeEquipped(player) && DATA.get().nightVisionActive) {
            DATA.get().nightVisionActive = false;
            DATA.get().removeNightvision = true;
        }
        if (DATA.get().removeNightvision) {
            player.func_184589_d(MobEffects.field_76439_r);
            DATA.get().removeNightvision = false;
        }
    }

    public static boolean isNightVisionUpgradeEquipped(EntityPlayer player) {
        ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
        return NightVisionUpgrade.INSTANCE.hasUpgrade(helmet);
    }

    public static void setNightVisionActive(boolean isNightVisionActive) {
        if (DATA.get().nightVisionActive && !isNightVisionActive) {
            DATA.get().removeNightvision = true;
        }
        DATA.get().nightVisionActive = isNightVisionActive;
    }

    public static boolean isNightVisionActive() {
        return DATA.get().nightVisionActive;
    }

    public static boolean isTopUpgradeEquipped(EntityPlayer player) {
        ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
        return TheOneProbeUpgrade.getInstance().hasUpgrade(helmet);
    }

    public static void setTopActive(EntityPlayer player, boolean active) {
        ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
        if (active) {
            ItemUtil.getOrCreateNBT((ItemStack)helmet).func_74768_a("theoneprobe", 1);
        } else {
            ItemUtil.getOrCreateNBT((ItemStack)helmet).func_82580_o("theoneprobe");
        }
    }

    public static boolean isTopActive(EntityPlayer player) {
        ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
        return ItemUtil.getOrCreateNBT((ItemStack)helmet).func_74764_b("theoneprobe");
    }

    private static class Data {
        private boolean jumpPre;
        private boolean wasJumping;
        private int jumpCount;
        private int ticksSinceLastJump;
        @Nonnull
        private final Map<UUID, EnumSet<PacketUpgradeState.Type>> allActive = new HashMap<UUID, EnumSet<PacketUpgradeState.Type>>();
        private boolean nightVisionActive = false;
        private boolean removeNightvision = false;

        private Data() {
        }
    }
}

