/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.init;

import com.enderio.core.EnderCore;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.block.coldfire.ColdFireStateMapper;
import crazypants.enderio.base.block.lever.LeverStateMapper;
import crazypants.enderio.base.diagnostics.EnderIOCrashCallable;
import crazypants.enderio.base.gui.IoConfigRenderer;
import crazypants.enderio.base.gui.tooltip.TooltipHandlerBurnTime;
import crazypants.enderio.base.gui.tooltip.TooltipHandlerFluid;
import crazypants.enderio.base.gui.tooltip.TooltipHandlerGrinding;
import crazypants.enderio.base.handler.KeyTracker;
import crazypants.enderio.base.init.CommonProxy;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.init.ModObjectRegistry;
import crazypants.enderio.base.integration.jei.JeiAccessor;
import crazypants.enderio.base.item.conduitprobe.ConduitProbeOverlayRenderer;
import crazypants.enderio.base.item.darksteel.upgrade.sound.SoundDetector;
import crazypants.enderio.base.item.yetawrench.YetaWrenchOverlayRenderer;
import crazypants.enderio.base.material.glass.EnderIOGlassesStateMapper;
import crazypants.enderio.base.paint.YetaUtil;
import crazypants.enderio.base.render.ICustomSubItems;
import crazypants.enderio.base.render.IDefaultRenderers;
import crazypants.enderio.base.render.IHaveRenderers;
import crazypants.enderio.base.render.IHaveTESR;
import crazypants.enderio.base.render.ranged.MarkerParticle;
import crazypants.enderio.base.render.registry.ItemModelRegistry;
import crazypants.enderio.base.render.registry.SmartModelAttacher;
import crazypants.enderio.base.teleport.TravelController;
import crazypants.enderio.util.ClientUtil;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="enderio", value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    @Override
    public World getClientWorld() {
        return FMLClientHandler.instance().getClient().field_71441_e;
    }

    @Override
    public boolean isAnEiInstalled() {
        return JeiAccessor.isJeiRuntimeAvailable();
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @SubscribeEvent
    public static void onModelRegistryEvent(@Nonnull ModelRegistryEvent event) {
        EnderIOGlassesStateMapper.create();
        ColdFireStateMapper.create();
        LeverStateMapper.create();
        StateMap doorMapper = new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a();
        ModelLoader.setCustomStateMapper((Block)ModObject.blockDarkSteelDoor.getBlockNN(), (IStateMapper)doorMapper);
        ModelLoader.setCustomStateMapper((Block)ModObject.blockPaintedDarkSteelDoor.getBlockNN(), (IStateMapper)doorMapper);
        ModelLoader.setCustomStateMapper((Block)ModObject.blockPaintedIronDoor.getBlockNN(), (IStateMapper)doorMapper);
        ModelLoader.setCustomStateMapper((Block)ModObject.blockPaintedWoodenDoor.getBlockNN(), (IStateMapper)doorMapper);
        SmartModelAttacher.registerBlockItemModels();
        for (IModObject mo : ModObjectRegistry.getRegistry()) {
            Block block = mo.getBlock();
            if (!(block instanceof ICustomSubItems)) {
                Item item;
                if (block instanceof IHaveRenderers) {
                    ((IHaveRenderers)block).registerRenderers(mo);
                } else if (block instanceof IDefaultRenderers) {
                    ClientUtil.registerDefaultItemRenderer(mo);
                } else if (!(block != null && block != Blocks.field_150350_a || (item = mo.getItem()) instanceof ICustomSubItems)) {
                    if (item instanceof IHaveRenderers) {
                        ((IHaveRenderers)item).registerRenderers(mo);
                    } else if (item != null && item != Items.field_190931_a) {
                        ClientUtil.registerDefaultItemRenderer(mo);
                    }
                }
            }
            if (!(block instanceof IHaveTESR)) continue;
            ((IHaveTESR)block).bindTileEntitySpecialRenderer();
        }
    }

    @Override
    public void init(@Nonnull FMLPreInitializationEvent event) {
        super.init(event);
        SpecialTooltipHandler.addCallback((SpecialTooltipHandler.ITooltipCallback)new TooltipHandlerGrinding());
        SpecialTooltipHandler.addCallback((SpecialTooltipHandler.ITooltipCallback)new TooltipHandlerBurnTime());
        SpecialTooltipHandler.addCallback((SpecialTooltipHandler.ITooltipCallback)new TooltipHandlerFluid());
        IoConfigRenderer.init(event);
        MinecraftForge.EVENT_BUS.register((Object)new YetaWrenchOverlayRenderer());
        MinecraftForge.EVENT_BUS.register((Object)new ConduitProbeOverlayRenderer());
        ItemModelRegistry.create();
        MinecraftForge.EVENT_BUS.register((Object)TravelController.instance);
        MinecraftForge.EVENT_BUS.register((Object)KeyTracker.instance);
        MinecraftForge.EVENT_BUS.register((Object)SoundDetector.instance);
    }

    @Override
    public void init(@Nonnull FMLInitializationEvent event) {
        super.init(event);
        SmartModelAttacher.registerColoredBlocksAndItems();
    }

    @Override
    public void init(@Nonnull FMLPostInitializationEvent event) {
        super.init(event);
    }

    @Override
    public double getReachDistanceForPlayer(EntityPlayer entityPlayer) {
        if (entityPlayer instanceof EntityPlayerMP) {
            return ((EntityPlayerMP)entityPlayer).field_71134_c.getBlockReachDistance();
        }
        return super.getReachDistanceForPlayer(entityPlayer);
    }

    @Override
    public void setInstantConfusionOnPlayer(@Nonnull EntityPlayer ent, int duration) {
        ent.func_70690_d(new PotionEffect(MobEffects.field_76431_k, duration, 1, true, true));
        Minecraft.func_71410_x().field_71439_g.field_71086_bY = 1.0f;
    }

    @Override
    public long getTickCount() {
        return this.clientTickCount;
    }

    @Override
    protected void onClientTick() {
        if (!Minecraft.func_71410_x().func_147113_T()) {
            ++this.clientTickCount;
            YetaUtil.onClientTick();
        }
    }

    @Override
    public void markBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vector4f color) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new MarkerParticle(world, pos, color));
    }

    @Override
    protected void registerCommands() {
    }

    @Override
    public boolean isDedicatedServer() {
        return false;
    }

    @Override
    public CreativeTabs getCreativeTab(@Nonnull ItemStack stack) {
        return stack.func_77973_b().func_77640_w();
    }

    @Override
    public void stopWithErrorScreen(String ... message) {
        EnderIOCrashCallable.registerStopScreenMessage(message);
        ArrayList<String> lines = new ArrayList<String>();
        for (String string : message) {
            Log.error(string);
            while (string.length() > 71) {
                lines.add(string.substring(0, 70));
                string = string.substring(70, string.length());
            }
            lines.add(string);
        }
        EnderCore.proxy.throwModCompatibilityError(lines.toArray(new String[lines.size()]));
    }
}

