/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.integration.thaumcraft;

import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.base.config.Config;
import crazypants.enderio.base.handler.darksteel.AbstractUpgrade;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ThaumaturgeRobesUpgrade
extends AbstractUpgrade {
    @Nonnull
    public static final String UPGRADE_NAME = "thaumaturge_robes_";
    @Nonnull
    public static final ThaumaturgeRobesUpgrade CHEST = new ThaumaturgeRobesUpgrade(EntityEquipmentSlot.CHEST);
    @Nonnull
    public static final ThaumaturgeRobesUpgrade LEGS = new ThaumaturgeRobesUpgrade(EntityEquipmentSlot.LEGS);
    @Nonnull
    public static final ThaumaturgeRobesUpgrade BOOTS = new ThaumaturgeRobesUpgrade(EntityEquipmentSlot.FEET);
    @Nonnull
    private final EntityEquipmentSlot slot;

    @Nonnull
    public static ItemStack getRobeArmor(EntityEquipmentSlot slot) {
        switch (slot) {
            case FEET: {
                Item i = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("thaumcraft", "cloth_boots"));
                if (i != null) {
                    return new ItemStack(i);
                }
            }
            case LEGS: {
                Item i = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("thaumcraft", "cloth_legs"));
                if (i != null) {
                    return new ItemStack(i);
                }
            }
            case CHEST: {
                Item i = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("thaumcraft", "cloth_chest"));
                if (i == null) break;
                return new ItemStack(i);
            }
        }
        return Prep.getEmpty();
    }

    public ThaumaturgeRobesUpgrade(@Nonnull EntityEquipmentSlot slot) {
        super(UPGRADE_NAME + slot.func_188450_d(), "enderio.darksteel.upgrade.thaumaturge_robes." + slot.func_188450_d(), ThaumaturgeRobesUpgrade.getRobeArmor(slot), Config.darkSteelThaumaturgeRobeCost);
        this.slot = slot;
    }

    @Override
    public boolean canAddToItem(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        return item.isForSlot(this.slot) && item.hasUpgradeCallbacks(this) && Prep.isValid(this.getUpgradeItem()) && !this.hasUpgrade(stack, item);
    }

    @Override
    @Nonnull
    public ItemStack getUpgradeItem() {
        this.upgradeItem = ThaumaturgeRobesUpgrade.getRobeArmor(this.slot);
        return this.upgradeItem;
    }

    @Override
    @Nonnull
    public String getUpgradeItemName() {
        if (Prep.isInvalid(this.getUpgradeItem())) {
            return "(???)";
        }
        return super.getUpgradeItemName();
    }
}

