/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.transform.EnderCoreMethods;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NNMap;
import com.enderio.core.common.util.OreDictionaryHelper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.api.upgrades.IEquipmentData;
import crazypants.enderio.api.upgrades.IHasPlayerRenderer;
import crazypants.enderio.api.upgrades.IRenderUpgrade;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.capacitor.CapacitorKey;
import crazypants.enderio.base.handler.darksteel.DarkSteelController;
import crazypants.enderio.base.handler.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.base.handler.darksteel.PacketUpgradeState;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.integration.thaumcraft.GogglesOfRevealingUpgrade;
import crazypants.enderio.base.integration.thaumcraft.ThaumaturgeRobesUpgrade;
import crazypants.enderio.base.item.darksteel.PaintedHelmetLayer;
import crazypants.enderio.base.item.darksteel.attributes.EquipmentData;
import crazypants.enderio.base.item.darksteel.upgrade.elytra.ElytraUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.item.darksteel.upgrade.glider.GliderUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.nightvision.NightVisionUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.sound.SoundDetectorUpgrade;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.painter.HelmetPainterTemplate;
import crazypants.enderio.base.render.itemoverlay.PowerBarOverlayRenderHelper;
import crazypants.enderio.util.Prep;
import forestry.api.apiculture.IArmorApiarist;
import forestry.api.core.IArmorNaturalist;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.items.IVisDiscountGear;

@Optional.InterfaceList(value={@Optional.Interface(iface="thaumcraft.api.items.IVisDiscountGear", modid="thaumcraft"), @Optional.Interface(iface="forestry.api.apiculture.IArmorApiarist", modid="forestry"), @Optional.Interface(iface="forestry.api.core.IArmorNaturalist", modid="forestry")})
public class ItemDarkSteelArmor
extends ItemArmor
implements ISpecialArmor,
IAdvancedTooltipProvider,
IDarkSteelItem,
EnderCoreMethods.IOverlayRenderAware,
IHasPlayerRenderer,
PaintUtil.IWithPaintName,
EnderCoreMethods.IElytraFlyingProvider,
IArmorApiarist,
IArmorNaturalist,
IVisDiscountGear {
    @Nonnull
    private final IEquipmentData data;
    private static final NNMap<EntityEquipmentSlot, UUID> ARMOR_MODIFIERS = new NNMap.Brutal();
    boolean gogglesUgradeActive = true;
    @GameRegistry.ObjectHolder(value="enderiointegrationforestry:apiarist_armor_feet")
    public static final IDarkSteelUpgrade FORESTRY_FEET;
    @GameRegistry.ObjectHolder(value="enderiointegrationforestry:apiarist_armor_legs")
    public static final IDarkSteelUpgrade FORESTRY_LEGS;
    @GameRegistry.ObjectHolder(value="enderiointegrationforestry:apiarist_armor_chest")
    public static final IDarkSteelUpgrade FORESTRY_CHEST;
    @GameRegistry.ObjectHolder(value="enderiointegrationforestry:apiarist_armor_head")
    public static final IDarkSteelUpgrade FORESTRY_HEAD;
    @GameRegistry.ObjectHolder(value="enderiointegrationforestry:naturalist_eye")
    public static final IDarkSteelUpgrade FORESTRY_EYES;

    public static ItemDarkSteelArmor createDarkSteelBoots(@Nonnull IModObject modObject) {
        return new ItemDarkSteelArmor(EquipmentData.DARK_STEEL, modObject, EntityEquipmentSlot.FEET, 1);
    }

    public static ItemDarkSteelArmor createDarkSteelLeggings(@Nonnull IModObject modObject) {
        return new ItemDarkSteelArmor(EquipmentData.DARK_STEEL, modObject, EntityEquipmentSlot.LEGS, 1);
    }

    public static ItemDarkSteelArmor createDarkSteelChestplate(@Nonnull IModObject modObject) {
        return new ItemDarkSteelArmor(EquipmentData.DARK_STEEL, modObject, EntityEquipmentSlot.CHEST, 1);
    }

    public static ItemDarkSteelArmor createDarkSteelHelmet(@Nonnull IModObject modObject) {
        ItemDarkSteelArmor helmet = new ItemDarkSteelArmor(EquipmentData.DARK_STEEL, modObject, EntityEquipmentSlot.HEAD, 1);
        MachineRecipeRegistry.instance.registerRecipe("painter", new HelmetPainterTemplate(helmet));
        return helmet;
    }

    public static ItemDarkSteelArmor createEndSteelBoots(@Nonnull IModObject modObject) {
        return new ItemDarkSteelArmor(EquipmentData.END_STEEL, modObject, EntityEquipmentSlot.FEET, 2);
    }

    public static ItemDarkSteelArmor createEndSteelLeggings(@Nonnull IModObject modObject) {
        return new ItemDarkSteelArmor(EquipmentData.END_STEEL, modObject, EntityEquipmentSlot.LEGS, 2);
    }

    public static ItemDarkSteelArmor createEndSteelChestplate(@Nonnull IModObject modObject) {
        return new ItemDarkSteelArmor(EquipmentData.END_STEEL, modObject, EntityEquipmentSlot.CHEST, 2);
    }

    public static ItemDarkSteelArmor createEndSteelHelmet(@Nonnull IModObject modObject) {
        ItemDarkSteelArmor helmet = new ItemDarkSteelArmor(EquipmentData.END_STEEL, modObject, EntityEquipmentSlot.HEAD, 2);
        MachineRecipeRegistry.instance.registerRecipe("painter", new HelmetPainterTemplate(helmet));
        return helmet;
    }

    protected ItemDarkSteelArmor(@Nonnull IEquipmentData data, @Nonnull IModObject modObject, @Nonnull EntityEquipmentSlot armorType, @Nonnull Integer tier) {
        super(data.getArmorMaterial(), 0, armorType);
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        modObject.apply(this);
        this.data = data;
    }

    protected int getPowerPerDamagePoint(@Nonnull ItemStack stack) {
        EnergyUpgrade.EnergyUpgradeHolder eu = EnergyUpgradeManager.loadFromItem(stack);
        if (eu != null) {
            return eu.getCapacity() / this.data.getArmorMaterial().func_78046_a(this.field_77881_a);
        }
        return 1;
    }

    @Nonnull
    protected ItemArmor.ArmorMaterial getMaterial(@Nonnull ItemStack stack) {
        return EnergyUpgradeManager.getEnergyStored(stack) > 0 ? this.data.getArmorMaterialEmpowered() : this.func_82812_d();
    }

    public int getItemEnchantability(@Nonnull ItemStack stack) {
        return this.getMaterial(stack).func_78045_a();
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> par3List) {
        if (this.func_194125_a(tab)) {
            ItemStack is = new ItemStack((Item)this);
            par3List.add((Object)is);
            is = new ItemStack((Item)this);
            ((EnergyUpgrade)EnergyUpgrade.UPGRADES.get(3)).addToItem(is, this);
            EnergyUpgradeManager.setPowerFull(is, this);
            Iterator<IDarkSteelUpgrade> iter = DarkSteelRecipeManager.recipeIterator();
            while (iter.hasNext()) {
                IDarkSteelUpgrade upgrade = iter.next();
                if (upgrade instanceof EnergyUpgrade || upgrade instanceof GliderUpgrade || upgrade instanceof ElytraUpgrade || !upgrade.canAddToItem(is, this)) continue;
                upgrade.addToItem(is, this);
            }
            if (GliderUpgrade.INSTANCE.canAddToItem(is, this)) {
                ItemStack is2 = is.func_77946_l();
                GliderUpgrade.INSTANCE.addToItem(is2, this);
                par3List.add((Object)is2);
                if (ElytraUpgrade.INSTANCE.canAddToItem(is, this)) {
                    ItemStack is3 = is.func_77946_l();
                    ElytraUpgrade.INSTANCE.addToItem(is3, this);
                    par3List.add((Object)is3);
                }
                return;
            }
            par3List.add((Object)is);
        }
    }

    public boolean func_82789_a(@Nonnull ItemStack i1, @Nonnull ItemStack i2) {
        return false;
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        switch (this.field_77881_a) {
            case HEAD: {
                return 5;
            }
            case CHEST: {
                return 8;
            }
            case LEGS: {
                return 7;
            }
        }
        return 4;
    }

    @Override
    public boolean isItemForRepair(@Nonnull ItemStack right) {
        return OreDictionaryHelper.hasName((ItemStack)right, (String)this.data.getRepairIngotOredict());
    }

    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelRecipeManager.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelRecipeManager.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        String str;
        if (!SpecialTooltipHandler.showDurability((boolean)flag)) {
            list.add(ItemUtil.getDurabilityString((ItemStack)itemstack));
        }
        if ((str = EnergyUpgradeManager.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        if (EnergyUpgradeManager.itemHasAnyPowerUpgrade(itemstack)) {
            list.addAll((Collection<String>)Lang.DARK_STEEL_POWERED.getLines(TextFormatting.WHITE));
            if (this.field_77881_a == EntityEquipmentSlot.FEET) {
                list.addAll((Collection<String>)Lang.DARK_BOOTS_POWERED.getLines(TextFormatting.WHITE));
            }
        }
        DarkSteelRecipeManager.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    @Override
    public String getPaintName(@Nonnull ItemStack itemStack) {
        NBTTagCompound subCompound;
        ItemStack paintSource = PaintUtil.getPaintSource(itemStack);
        if (Prep.isValid(paintSource) && (subCompound = itemStack.func_179543_a("DSPAINT")) != null) {
            paintSource = new ItemStack(subCompound);
        }
        if (Prep.isValid(paintSource)) {
            return paintSource.func_82833_r();
        }
        return null;
    }

    public String getArmorTexture(@Nonnull ItemStack itemStack, @Nonnull Entity entity, @Nonnull EntityEquipmentSlot slot, @Nonnull String layer) {
        if (this.field_77881_a == EntityEquipmentSlot.LEGS || this.field_77881_a == EntityEquipmentSlot.HEAD && !NightVisionUpgrade.INSTANCE.hasUpgrade(itemStack) && !SoundDetectorUpgrade.INSTANCE.hasUpgrade(itemStack)) {
            return this.data.getTexture2();
        }
        return this.data.getTexture1();
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(@Nonnull EntityLivingBase entityLiving, @Nonnull ItemStack itemStack, @Nonnull EntityEquipmentSlot armorSlot, @Nonnull ModelBiped _default) {
        if (this.field_77881_a == EntityEquipmentSlot.HEAD && (PaintUtil.hasPaintSource(itemStack) || itemStack.func_179543_a("DSPAINT") != null)) {
            return PaintedHelmetLayer.no_render;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderUpgrade getRender() {
        return this.field_77881_a == EntityEquipmentSlot.HEAD ? PaintedHelmetLayer.instance : PaintedHelmetLayer.not_an_helmet;
    }

    public void renderItemOverlayIntoGUI(@Nonnull ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance_upgradeable.render(stack, xPosition, yPosition);
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot equipmentSlot, @Nonnull ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == this.field_77881_a) {
            ItemArmor.ArmorMaterial armorMaterial = this.getMaterial(stack);
            multimap.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier((UUID)ARMOR_MODIFIERS.get((Object)equipmentSlot), "Armor modifier", (double)armorMaterial.func_78044_b(equipmentSlot), 0));
            multimap.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier((UUID)ARMOR_MODIFIERS.get((Object)equipmentSlot), "Armor toughness", (double)armorMaterial.func_189416_e(), 0));
        }
        return multimap;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        ItemArmor.ArmorMaterial armorMaterial;
        int damageReductionAmount;
        double ratio = 0.0;
        if (!source.func_76363_c() && (damageReductionAmount = (armorMaterial = this.getMaterial(armor)).func_78044_b(this.field_77881_a) - ItemArmor.ArmorMaterial.DIAMOND.func_78044_b(this.field_77881_a)) > 0) {
            ratio = (double)damageReductionAmount * 0.05;
        }
        return new ISpecialArmor.ArmorProperties(0, ratio, Integer.MAX_VALUE);
    }

    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, @Nonnull ItemStack stack, DamageSource source, int damage, int slot) {
        if (entity != null) {
            stack.func_77972_a(damage, entity);
        }
    }

    public void setDamage(@Nonnull ItemStack stack, int damageNew) {
        int damage = damageNew - this.getDamage(stack);
        EnergyUpgrade.EnergyUpgradeHolder eu = EnergyUpgradeManager.loadFromItem(stack);
        if (damage > 0 && eu != null && eu.isAbsorbDamageWithPower() && eu.getEnergy() > 0) {
            eu.extractEnergy(damage * this.getPowerPerDamagePoint(stack), false);
            eu.writeToItem();
        } else {
            super.setDamage(stack, damageNew);
        }
    }

    public boolean isElytraFlying(@Nonnull EntityLivingBase entity, @Nonnull ItemStack itemstack, boolean shouldStop) {
        if (entity instanceof EntityPlayer && DarkSteelController.isElytraUpgradeEquipped(itemstack) && DarkSteelController.isElytraActive((EntityPlayer)entity)) {
            if (shouldStop && !entity.field_70170_p.field_72995_K) {
                DarkSteelController.setActive((EntityPlayer)entity, PacketUpgradeState.Type.ELYTRA, false);
                PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketUpgradeState(PacketUpgradeState.Type.ELYTRA, false, entity.func_145782_y()), entity.field_70170_p.field_73011_w.getDimension());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isForSlot(@Nonnull EntityEquipmentSlot slot) {
        return slot == this.field_77881_a;
    }

    @Override
    public boolean hasUpgradeCallbacks(@Nonnull IDarkSteelUpgrade upgrade) {
        return upgrade == FORESTRY_FEET || upgrade == FORESTRY_LEGS || upgrade == FORESTRY_CHEST || upgrade == FORESTRY_HEAD || upgrade == FORESTRY_EYES || upgrade == ElytraUpgrade.INSTANCE || upgrade == GogglesOfRevealingUpgrade.INSTANCE || upgrade == ThaumaturgeRobesUpgrade.BOOTS || upgrade == ThaumaturgeRobesUpgrade.LEGS || upgrade == ThaumaturgeRobesUpgrade.CHEST;
    }

    @Optional.Method(modid="thaumcraft")
    public int getVisDiscount(ItemStack stack, EntityPlayer player) {
        if (stack == null) {
            return -100;
        }
        return ThaumaturgeRobesUpgrade.BOOTS.hasUpgrade(stack) ? 2 : (ThaumaturgeRobesUpgrade.LEGS.hasUpgrade(stack) ? 3 : (ThaumaturgeRobesUpgrade.CHEST.hasUpgrade(stack) ? 3 : 0));
    }

    public boolean isGogglesUgradeActive() {
        return this.gogglesUgradeActive;
    }

    public void setGogglesUgradeActive(boolean gogglesUgradeActive) {
        this.gogglesUgradeActive = gogglesUgradeActive;
    }

    @Optional.Method(modid="forestry")
    public boolean canSeePollination(@Nonnull EntityPlayer player, @Nonnull ItemStack armor, boolean doSee) {
        if (armor.func_77973_b() != ModObject.itemDarkSteelHelmet.getItemNN()) {
            return false;
        }
        return FORESTRY_EYES != null && FORESTRY_EYES.hasUpgrade(player.func_184582_a(EntityEquipmentSlot.HEAD));
    }

    @Optional.Method(modid="forestry")
    public boolean protectEntity(@Nonnull EntityLivingBase entity, @Nonnull ItemStack armor, @Nullable String cause, boolean doProtect) {
        return FORESTRY_HEAD != null && FORESTRY_HEAD.hasUpgrade(armor) || FORESTRY_CHEST != null && FORESTRY_CHEST.hasUpgrade(armor) || FORESTRY_FEET != null && FORESTRY_FEET.hasUpgrade(armor) || FORESTRY_LEGS != null && FORESTRY_LEGS.hasUpgrade(armor);
    }

    @Override
    @Nonnull
    public IEquipmentData getEquipmentData() {
        return this.data;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyStorageKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_ARMOR_ENERGY_BUFFER;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyInputKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_ARMOR_ENERGY_INPUT;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyUseKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_ARMOR_ENERGY_USE;
    }

    @Override
    @Nonnull
    public ICapacitorKey getAbsorptionRatioKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_ARMOR_ABSORPTION_RATIO;
    }

    static {
        ARMOR_MODIFIERS.put((Object)EntityEquipmentSlot.FEET, (Object)UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"));
        ARMOR_MODIFIERS.put((Object)EntityEquipmentSlot.LEGS, (Object)UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"));
        ARMOR_MODIFIERS.put((Object)EntityEquipmentSlot.CHEST, (Object)UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"));
        ARMOR_MODIFIERS.put((Object)EntityEquipmentSlot.HEAD, (Object)UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150"));
        FORESTRY_FEET = null;
        FORESTRY_LEGS = null;
        FORESTRY_CHEST = null;
        FORESTRY_HEAD = null;
        FORESTRY_EYES = null;
    }
}

