/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel.attributes;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.upgrades.IEquipmentData;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.config.Config;
import crazypants.enderio.base.config.config.PersonalConfig;
import crazypants.enderio.base.material.alloy.Alloy;
import crazypants.enderio.base.material.material.Material;
import javax.annotation.Nonnull;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum EquipmentData implements IEquipmentData
{
    IRON(ItemArmor.ArmorMaterial.IRON, ItemArmor.ArmorMaterial.IRON, Item.ToolMaterial.IRON, "ingotIron", "stickWood", "", "", 0),
    DARK_STEEL(new Builder(1).setMaxDamageFactor(35).setDamageReduction(2, 5, 6, 2).setDamageReductionEmpowered(3, 6, 8, 3).setArmorEnchantability(15).setSoundEvent(SoundEvents.field_187725_r).setToughness(1.0f).setToughnessEmpowered(2.0f).setToolMaterialName("darkSteel").setHarvestLevel(Config.darkSteelPickMinesTiCArdite ? 5 : 3).setMaxUses(2000).setEfficiency(8.0f).setDamage(3.0001f).setToolEnchanability(25).setRepairIngotOredict(Alloy.DARK_STEEL.getOreIngot()).setBowRepairIngotOredict(Material.NUTRITIOUS_STICK.getOreDict()).setTexture1("dark_steel_layer_1").setTexture2("dark_steel_layer_2")),
    END_STEEL(new Builder(2).setMaxDamageFactor(50).setDamageReduction(4, 7, 10, 4).setDamageReductionEmpowered(5, 8, 12, 5).setArmorEnchantability(25).setSoundEvent(SoundEvents.field_187725_r).setToughness(3.0f).setToughnessEmpowered(4.0f).setToolMaterialName("endSteel").setHarvestLevel(Config.darkSteelPickMinesTiCArdite ? 5 : 3).setMaxUses(2000).setEfficiency(12.0f).setDamage(5.0f).setToolEnchanability(30).setRepairIngotOredict(Alloy.END_STEEL.getOreIngot()).setBowRepairIngotOredict(Material.INFINITY_ROD.getOreDict()).setTexture1("end_steel_layer_1").setTexture2("end_steel_layer_2")){

        @Override
        @SideOnly(value=Side.CLIENT)
        @Nonnull
        protected String getAnimationFrame() {
            if (PersonalConfig.animatedEnderArmorEnabled.get().booleanValue()) {
                int tick = (int)(EnderIO.proxy.getTickCount() / 2L % 26L);
                switch (tick) {
                    case 16: 
                    case 25: {
                        return "_1";
                    }
                    case 17: 
                    case 24: {
                        return "_2";
                    }
                    case 18: 
                    case 23: {
                        return "_3";
                    }
                    case 19: 
                    case 22: {
                        return "_4";
                    }
                    case 20: 
                    case 21: {
                        return "_5";
                    }
                }
                return "";
            }
            return "";
        }
    }
    ,
    STELLAR_ALLOY(new Builder(4).setMaxDamageFactor(75).setDamageReduction(8, 14, 18, 7).setDamageReductionEmpowered(10, 15, 22, 10).setArmorEnchantability(40).setSoundEvent(SoundEvents.field_187716_o).setToughness(7.0f).setToughnessEmpowered(9.0f).setToolMaterialName("stellarAlloy").setHarvestLevel(Config.darkSteelPickMinesTiCArdite ? 5 : 3).setMaxUses(5000).setEfficiency(22.0f).setDamage(11.0f).setToolEnchanability(40).setRepairIngotOredict(Material.STELLAR_ALLOY.getOreDict()).setBowRepairIngotOredict(Material.STELLAR_ALLOY.getOreDict()).setTexture1("stellar_alloy_layer_1").setTexture2("stellar_alloy_layer_2"));

    @Nonnull
    private final ItemArmor.ArmorMaterial armorMaterial;
    @Nonnull
    private final ItemArmor.ArmorMaterial armorMaterialEmpowered;
    @Nonnull
    private final Item.ToolMaterial toolMaterial;
    @Nonnull
    private final String repairIngotOredict;
    @Nonnull
    private final String bowRepairIngotOredict;
    @Nonnull
    private final String texture1;
    @Nonnull
    private final String texture2;
    @Nonnull
    private final Integer tier;

    private EquipmentData(@Nonnull int maxDamageFactor, int[] damageReduction, int[] damageReductionEmpowered, int armorEnchantability, SoundEvent soundEvent, float toughness, float toughnessEmpowered, String toolMaterialName, int harvestLevel, int maxUses, float efficiency, @Nonnull float damage, @Nonnull int toolEnchanability, @Nonnull String repairIngotOredict, @Nonnull String bowRepairIngotOredict, @Nonnull String texture1, String texture2, Integer tier) {
        this.armorMaterial = (ItemArmor.ArmorMaterial)NullHelper.notnullF((Object)EnumHelper.addArmorMaterial((String)this.name(), (String)this.name(), (int)maxDamageFactor, (int[])damageReduction, (int)armorEnchantability, (SoundEvent)soundEvent, (float)toughness), (String)"Failed to create armor material");
        this.armorMaterialEmpowered = (ItemArmor.ArmorMaterial)NullHelper.notnullF((Object)EnumHelper.addArmorMaterial((String)(this.name() + "_EMPOWERED"), (String)(this.name() + "_EMPOWERED"), (int)maxDamageFactor, (int[])damageReductionEmpowered, (int)armorEnchantability, (SoundEvent)soundEvent, (float)toughnessEmpowered), (String)"Failed to create armor material");
        this.toolMaterial = (Item.ToolMaterial)NullHelper.notnullF((Object)EnumHelper.addToolMaterial((String)toolMaterialName, (int)harvestLevel, (int)maxUses, (float)efficiency, (float)damage, (int)toolEnchanability), (String)"failed to add tool material dark steel");
        this.repairIngotOredict = repairIngotOredict;
        this.bowRepairIngotOredict = bowRepairIngotOredict;
        this.texture1 = "enderio:textures/models/armor/" + texture1;
        this.texture2 = "enderio:textures/models/armor/" + texture2;
        this.tier = tier;
    }

    private EquipmentData(@Nonnull ItemArmor.ArmorMaterial armorMaterial, @Nonnull ItemArmor.ArmorMaterial armorMaterialEmpowered, @Nonnull Item.ToolMaterial toolMaterial, @Nonnull String repairIngotOredict, @Nonnull String bowRepairIngotOredict, @Nonnull String texture1, String texture2, Integer tier) {
        this.armorMaterial = armorMaterial;
        this.armorMaterialEmpowered = armorMaterialEmpowered;
        this.toolMaterial = toolMaterial;
        this.repairIngotOredict = repairIngotOredict;
        this.bowRepairIngotOredict = bowRepairIngotOredict;
        this.texture1 = texture1;
        this.texture2 = texture2;
        this.tier = tier;
    }

    private EquipmentData(Builder b) {
        this((Integer)NullHelper.notnull((Object)b.maxDamageFactor, (Object[])new Object[]{"maxDamageFactor", " must be set"}), (int[])NullHelper.notnull((Object)b.damageReduction, (Object[])new Object[]{"damageReduction", " must be set"}), (int[])NullHelper.notnull((Object)b.damageReductionEmpowered, (Object[])new Object[]{"damageReductionEmpowered", " must be set"}), (Integer)NullHelper.notnull((Object)b.armorEnchantability, (Object[])new Object[]{"armorEnchantability", " must be set"}), (SoundEvent)NullHelper.notnull((Object)b.soundEvent, (Object[])new Object[]{"soundEvent", " must be set"}), ((Float)NullHelper.notnull((Object)b.toughness, (Object[])new Object[]{"toughness", " must be set"})).floatValue(), ((Float)NullHelper.notnull((Object)b.toughnessEmpowered, (Object[])new Object[]{"toughnessEmpowered", " must be set"})).floatValue(), (String)NullHelper.notnull((Object)b.toolMaterialName, (Object[])new Object[]{"toolMaterialName", " must be set"}), (Integer)NullHelper.notnull((Object)b.harvestLevel, (Object[])new Object[]{"harvestLevel", " must be set"}), (Integer)NullHelper.notnull((Object)b.maxUses, (Object[])new Object[]{"maxUses", " must be set"}), ((Float)NullHelper.notnull((Object)b.efficiency, (Object[])new Object[]{"efficiency", " must be set"})).floatValue(), ((Float)NullHelper.notnull((Object)b.damage, (Object[])new Object[]{"damage", " must be set"})).floatValue(), (Integer)NullHelper.notnull((Object)b.toolEnchanability, (Object[])new Object[]{"toolEnchanability", " must be set"}), (String)NullHelper.notnull((Object)b.repairIngotOredict, (Object[])new Object[]{"repairIngotOredict", " must be set"}), (String)NullHelper.notnull((Object)b.bowRepairIngotOredict, (Object[])new Object[]{"bowRepairIngotOredict", " must be set"}), (String)NullHelper.notnull((Object)b.texture1, (Object[])new Object[]{"texture1", " must be set"}), (String)NullHelper.notnull((Object)b.texture2, (Object[])new Object[]{"texture2", " must be set"}), (Integer)NullHelper.notnull((Object)b.tier, (Object[])new Object[]{"tier", " must be set"}));
    }

    @Override
    @Nonnull
    public ItemArmor.ArmorMaterial getArmorMaterial() {
        return this.armorMaterial;
    }

    @Override
    @Nonnull
    public ItemArmor.ArmorMaterial getArmorMaterialEmpowered() {
        return this.armorMaterialEmpowered;
    }

    @Override
    @Nonnull
    public Item.ToolMaterial getToolMaterial() {
        return this.toolMaterial;
    }

    @Override
    @Nonnull
    public String getRepairIngotOredict() {
        return this.repairIngotOredict;
    }

    @Override
    @Nonnull
    public String getTexture1() {
        return this.texture1 + this.getAnimationFrame() + ".png";
    }

    @Override
    @Nonnull
    public String getTexture2() {
        return this.texture2 + this.getAnimationFrame() + ".png";
    }

    @Nonnull
    protected String getAnimationFrame() {
        return "";
    }

    @Override
    @Nonnull
    public Integer getTier() {
        return this.tier;
    }

    @Override
    @Nonnull
    public String getBowRepairIngotOredict() {
        return this.bowRepairIngotOredict;
    }

    private static final class Builder {
        Integer maxDamageFactor;
        int[] damageReduction;
        int[] damageReductionEmpowered;
        Integer armorEnchantability;
        SoundEvent soundEvent;
        Float toughness;
        Float toughnessEmpowered;
        String toolMaterialName;
        Integer harvestLevel;
        Integer maxUses;
        Float efficiency;
        Float damage;
        Integer toolEnchanability;
        String repairIngotOredict;
        String bowRepairIngotOredict;
        String texture1;
        String texture2;
        Integer tier;

        @Nonnull
        Builder setMaxDamageFactor(int maxDamageFactor) {
            this.maxDamageFactor = maxDamageFactor;
            return this;
        }

        @Nonnull
        Builder setDamageReduction(int ... damageReduction) {
            if (damageReduction.length != 4) {
                throw new RuntimeException("damageReduction must have 4 elements");
            }
            this.damageReduction = damageReduction;
            return this;
        }

        @Nonnull
        Builder setDamageReductionEmpowered(int ... damageReductionEmpowered) {
            if (damageReductionEmpowered.length != 4) {
                throw new RuntimeException("damageReductionEmpowered must have 4 elements");
            }
            this.damageReductionEmpowered = damageReductionEmpowered;
            return this;
        }

        @Nonnull
        Builder setArmorEnchantability(int armorEnchantability) {
            this.armorEnchantability = armorEnchantability;
            return this;
        }

        @Nonnull
        Builder setSoundEvent(@Nonnull SoundEvent soundEvent) {
            this.soundEvent = soundEvent;
            return this;
        }

        @Nonnull
        Builder setToughness(float toughness) {
            this.toughness = Float.valueOf(toughness);
            return this;
        }

        @Nonnull
        Builder setToughnessEmpowered(float toughnessEmpowered) {
            this.toughnessEmpowered = Float.valueOf(toughnessEmpowered);
            return this;
        }

        @Nonnull
        Builder setToolMaterialName(@Nonnull String toolMaterialName) {
            this.toolMaterialName = toolMaterialName;
            return this;
        }

        @Nonnull
        Builder setHarvestLevel(int harvestLevel) {
            this.harvestLevel = harvestLevel;
            return this;
        }

        @Nonnull
        Builder setMaxUses(int maxUses) {
            this.maxUses = maxUses;
            return this;
        }

        @Nonnull
        Builder setEfficiency(float efficiency) {
            this.efficiency = Float.valueOf(efficiency);
            return this;
        }

        @Nonnull
        Builder setDamage(float damage) {
            this.damage = Float.valueOf(damage);
            return this;
        }

        @Nonnull
        Builder setToolEnchanability(int toolEnchanability) {
            this.toolEnchanability = toolEnchanability;
            return this;
        }

        @Nonnull
        Builder setRepairIngotOredict(@Nonnull String repairIngotOredict) {
            this.repairIngotOredict = repairIngotOredict;
            return this;
        }

        @Nonnull
        Builder setBowRepairIngotOredict(@Nonnull String bowRepairIngotOredict) {
            this.bowRepairIngotOredict = bowRepairIngotOredict;
            return this;
        }

        @Nonnull
        Builder setTexture1(@Nonnull String texture1) {
            this.texture1 = texture1;
            return this;
        }

        @Nonnull
        Builder setTexture2(@Nonnull String texture2) {
            this.texture2 = texture2;
            return this;
        }

        Builder(int tier) {
            this.tier = tier;
        }
    }
}

