/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel.upgrade.energy;

import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.capacitor.ICapacitorData;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.block.skull.SkullType;
import crazypants.enderio.base.config.config.DarkSteelConfig;
import crazypants.enderio.base.config.factory.IValue;
import crazypants.enderio.base.handler.darksteel.AbstractUpgrade;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.item.travelstaff.ItemTravelStaff;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.base.material.material.Material;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnergyUpgrade
extends AbstractUpgrade {
    @Nonnull
    public static final NNList<EnergyUpgrade> UPGRADES = new NNList((Object[])new EnergyUpgrade[]{new EnergyUpgrade("energyUpgrade", 0, "enderio.darksteel.upgrade.empowered_one", DarkSteelConfig.energyUpgradeLevelCostEmpowered0, Material.VIBRANT_CYSTAL.getStack()), new EnergyUpgrade("energyUpgrade", 1, "enderio.darksteel.upgrade.empowered_two", DarkSteelConfig.energyUpgradeLevelCostEmpowered1, new ItemStack(ModObject.itemBasicCapacitor.getItemNN(), 1, 0)), new EnergyUpgrade("energyUpgrade", 2, "enderio.darksteel.upgrade.empowered_three", DarkSteelConfig.energyUpgradeLevelCostEmpowered2, new ItemStack(ModObject.itemBasicCapacitor.getItemNN(), 1, 1)), new EnergyUpgrade("energyUpgrade", 3, "enderio.darksteel.upgrade.empowered_four", DarkSteelConfig.energyUpgradeLevelCostEmpowered3, new ItemStack(ModObject.itemBasicCapacitor.getItemNN(), 1, 2)), new EnergyUpgrade("energyUpgrade", 4, "enderio.darksteel.upgrade.empowered_five", DarkSteelConfig.energyUpgradeLevelCostEmpowered4, new ItemStack(ModObject.blockEndermanSkull.getBlockNN(), 1, SkullType.TORMENTED.ordinal()))});
    protected final int level;
    @Nonnull
    protected final ICapacitorData capData;

    public static EnergyUpgrade loadAnyFromItem(@Nonnull ItemStack stack) {
        for (EnergyUpgrade energyUpgrade : UPGRADES) {
            if (!energyUpgrade.hasUpgrade(stack)) continue;
            return energyUpgrade;
        }
        if (stack.func_77973_b() instanceof ItemTravelStaff) {
            return (EnergyUpgrade)UPGRADES.get(0);
        }
        return null;
    }

    public static EnergyUpgrade next(EnergyUpgrade upgrade) {
        int next = upgrade == null ? 0 : upgrade.level + 1;
        return next >= UPGRADES.size() ? null : (EnergyUpgrade)UPGRADES.get(next);
    }

    public EnergyUpgrade(@Nonnull String id, final int level, final @Nonnull String name, @Nonnull IValue<Integer> levels, @Nonnull ItemStack upgradeItem) {
        super(id, level, name, upgradeItem, levels);
        this.level = level;
        this.capData = new ICapacitorData(){

            @Override
            public float getUnscaledValue(@Nonnull ICapacitorKey key) {
                return level + 1;
            }

            @Override
            @Nonnull
            public String getUnlocalizedName() {
                return name;
            }

            @Override
            @Nonnull
            public String getLocalizedName() {
                return EnderIO.lang.localize(this.getUnlocalizedName());
            }
        };
    }

    @Override
    public boolean canAddToItem(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        EnergyUpgrade existing = EnergyUpgrade.loadAnyFromItem(stack);
        EnergyUpgrade up = EnergyUpgrade.next(existing);
        return up != null && up.id.equals(this.id) && up.level == this.level && item.getMaxEmpoweredLevel(stack) >= this.level;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        ArrayList<String> upgradeStr = new ArrayList<String>();
        upgradeStr.add(TextFormatting.DARK_AQUA + EnderIO.lang.localizeExact(this.getUnlocalizedName() + ".name"));
        if (itemstack.func_77984_f() && itemstack.func_77973_b() instanceof IDarkSteelItem) {
            SpecialTooltipHandler.addDetailedTooltipFromResources(upgradeStr, (String)this.getUnlocalizedName());
            EnergyUpgradeHolder eu = this.getEnergyUpgradeHolder(itemstack, (IDarkSteelItem)itemstack.func_77973_b());
            String percDamage = Math.round(eu.getAbsorptionRatio() * 100.0f) + "";
            String capString = LangPower.RF(eu.getCapacity());
            for (int i = 0; i < upgradeStr.size(); ++i) {
                String str = (String)upgradeStr.get(i);
                str = str.replaceAll("\\$P", capString);
                str = str.replaceAll("\\$D", percDamage);
                upgradeStr.set(i, str);
            }
        }
        list.addAll(upgradeStr);
    }

    public int getLevel() {
        return this.level;
    }

    @Nonnull
    public EnergyUpgradeHolder getEnergyUpgradeHolder(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        return new EnergyUpgradeHolder(stack, item);
    }

    public class EnergyUpgradeHolder {
        private int energy;
        @Nonnull
        private final ItemStack stack;
        @Nonnull
        private final IDarkSteelItem item;

        private EnergyUpgradeHolder(@Nonnull ItemStack stack, IDarkSteelItem item) {
            this.stack = stack;
            this.item = item;
            this.setEnergy(EnergyUpgrade.this.getOrCreateUpgradeNBT(stack).func_74762_e("energy"));
        }

        public int getEnergy() {
            return this.energy;
        }

        public void setEnergy(int energy) {
            this.energy = MathHelper.func_76125_a((int)energy, (int)0, (int)this.getCapacity());
        }

        public int receiveEnergy(int maxRF, boolean simulate) {
            int energyReceived = Math.max(0, Math.min(this.getCapacity() - this.energy, Math.min(this.getMaxInput(), maxRF)));
            if (!simulate) {
                this.energy += energyReceived;
            }
            return energyReceived;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int energyExtracted = Math.max(0, Math.min(this.energy, Math.min(this.getMaxOutput(), maxExtract)));
            if (!simulate) {
                this.energy -= energyExtracted;
            }
            return energyExtracted;
        }

        @Nonnull
        public EnergyUpgrade getUpgrade() {
            return EnergyUpgrade.this;
        }

        public void writeToItem() {
            EnergyUpgrade.this.addToItem(this.stack, this.item);
            EnergyUpgrade.this.getOrCreateUpgradeNBT(this.stack).func_74768_a("energy", this.energy);
        }

        public int getCapacity() {
            return this.item.getEnergyStorageKey(this.stack).get(EnergyUpgrade.this.capData);
        }

        public int getMaxInput() {
            return this.item.getEnergyInputKey(this.stack).get(EnergyUpgrade.this.capData);
        }

        public int getMaxOutput() {
            return this.item.getEnergyUseKey(this.stack).get(EnergyUpgrade.this.capData);
        }

        public float getAbsorptionRatio() {
            return this.item.getAbsorptionRatioKey(this.stack).getFloat(EnergyUpgrade.this.capData);
        }

        public boolean isAbsorbDamageWithPower() {
            return EnergyUpgradeManager.RANDOM.nextDouble() < (double)this.getAbsorptionRatio();
        }
    }
}

