/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel.upgrade.jump;

import com.enderio.core.client.ClientUtil;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.base.config.Config;
import crazypants.enderio.base.handler.darksteel.AbstractUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.sound.IModSound;
import crazypants.enderio.base.sound.SoundHelper;
import crazypants.enderio.base.sound.SoundRegistry;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class JumpUpgrade
extends AbstractUpgrade {
    @Nonnull
    private static final String UPGRADE_NAME = "jumpBoost";
    @Nonnull
    public static final JumpUpgrade JUMP_ONE = new JumpUpgrade("enderio.darksteel.upgrade.jump_one", 1, Config.darkSteelJumpOneCost);
    @Nonnull
    public static final JumpUpgrade JUMP_TWO = new JumpUpgrade("enderio.darksteel.upgrade.jump_two", 2, Config.darkSteelJumpTwoCost);
    @Nonnull
    public static final JumpUpgrade JUMP_THREE = new JumpUpgrade("enderio.darksteel.upgrade.jump_three", 3, Config.darkSteelJumpThreeCost);
    private final short level;

    public static JumpUpgrade loadAnyFromItem(@Nonnull ItemStack stack) {
        if (JUMP_THREE.hasUpgrade(stack)) {
            return JUMP_THREE;
        }
        if (JUMP_TWO.hasUpgrade(stack)) {
            return JUMP_TWO;
        }
        if (JUMP_ONE.hasUpgrade(stack)) {
            return JUMP_ONE;
        }
        return null;
    }

    public static boolean isEquipped(@Nonnull EntityPlayer player) {
        return JumpUpgrade.loadAnyFromItem(player.func_184582_a(EntityEquipmentSlot.FEET)) != null;
    }

    public JumpUpgrade(@Nonnull String unlocName, int level, int levelCost) {
        super(UPGRADE_NAME, level, unlocName, new ItemStack((Block)Blocks.field_150331_J), levelCost);
        this.level = (short)level;
    }

    @Override
    public boolean canAddToItem(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        if (!item.isForSlot(EntityEquipmentSlot.FEET) || !EnergyUpgradeManager.itemHasAnyPowerUpgrade(stack)) {
            return false;
        }
        JumpUpgrade up = JumpUpgrade.loadAnyFromItem(stack);
        if (up == null) {
            return this.getLevel() == 1;
        }
        return up.getLevel() == this.getLevel() - 1;
    }

    public short getLevel() {
        return this.level;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void doMultiplayerSFX(@Nonnull EntityPlayer player) {
        SoundHelper.playSound(player.field_70170_p, (Entity)player, (IModSound)SoundRegistry.JUMP, 1.0f, player.field_70170_p.field_73012_v.nextFloat() * 0.5f + 0.75f);
        Random rand = player.field_70170_p.field_73012_v;
        for (int i = rand.nextInt(10) + 5; i >= 0; --i) {
            Particle fx = Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.REDSTONE.func_179348_c(), player.field_70165_t + (rand.nextDouble() * 0.5 - 0.25), player.field_70163_u - player.func_70033_W(), player.field_70161_v + (rand.nextDouble() * 0.5 - 0.25), 1.0, 1.0, 1.0, new int[0]);
            ClientUtil.setParticleVelocity((Particle)fx, (double)(player.field_70159_w + (rand.nextDouble() * 0.5 - 0.25)), (double)(player.field_70181_x / 2.0 + rand.nextDouble() * -0.05), (double)(player.field_70179_y + (rand.nextDouble() * 0.5 - 0.25)));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)NullHelper.notnullM((Object)fx, (String)"spawnEffectParticle() failed unexptedly"));
        }
    }
}

