/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel.upgrade.speed;

import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.base.config.Config;
import crazypants.enderio.base.handler.darksteel.AbstractUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.potion.PotionUtil;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionUtils;

public class SpeedUpgrade
extends AbstractUpgrade {
    @Nonnull
    private static final String UPGRADE_NAME = "speedBoost";
    @Nonnull
    public static final SpeedUpgrade SPEED_ONE = new SpeedUpgrade("enderio.darksteel.upgrade.speed_one", 1, Config.darkSteelSpeedOneCost);
    @Nonnull
    public static final SpeedUpgrade SPEED_TWO = new SpeedUpgrade("enderio.darksteel.upgrade.speed_two", 2, Config.darkSteelSpeedTwoCost);
    @Nonnull
    public static final SpeedUpgrade SPEED_THREE = new SpeedUpgrade("enderio.darksteel.upgrade.speed_three", 3, Config.darkSteelSpeedThreeCost);
    private final short level;

    public static SpeedUpgrade loadAnyFromItem(@Nonnull ItemStack stack) {
        if (SPEED_THREE.hasUpgrade(stack)) {
            return SPEED_THREE;
        }
        if (SPEED_TWO.hasUpgrade(stack)) {
            return SPEED_TWO;
        }
        if (SPEED_ONE.hasUpgrade(stack)) {
            return SPEED_ONE;
        }
        return null;
    }

    public static boolean isEquipped(@Nonnull EntityPlayer player) {
        return SpeedUpgrade.loadAnyFromItem(player.func_184582_a(EntityEquipmentSlot.LEGS)) != null;
    }

    @Nonnull
    private static ItemStack createUpgradeItem() {
        return PotionUtil.createSwiftnessPotion(true, false);
    }

    public SpeedUpgrade(@Nonnull String unlocName, int level, int levelCost) {
        super(UPGRADE_NAME, level, unlocName, SpeedUpgrade.createUpgradeItem(), levelCost);
        this.level = (short)level;
    }

    @Override
    public boolean canAddToItem(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        if (!item.isForSlot(EntityEquipmentSlot.LEGS) || !EnergyUpgradeManager.itemHasAnyPowerUpgrade(stack)) {
            return false;
        }
        SpeedUpgrade up = SpeedUpgrade.loadAnyFromItem(stack);
        if (up == null) {
            return this.getLevel() == 1;
        }
        return up.getLevel() == this.getLevel() - 1;
    }

    public short getLevel() {
        return this.level;
    }

    @Override
    public boolean isUpgradeItem(@Nonnull ItemStack stack) {
        return super.isUpgradeItem(stack) && PotionUtils.func_185191_c((ItemStack)this.getUpgradeItem()).equals(PotionUtils.func_185191_c((ItemStack)stack));
    }
}

