/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.base.te;

import com.enderio.core.common.NBTAction;
import com.enderio.core.common.inventory.EnderInventory;
import com.enderio.core.common.inventory.InventorySlot;
import crazypants.enderio.base.capability.ItemTools;
import crazypants.enderio.base.machine.base.te.AbstractMachineEntity;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@Storable
public abstract class AbstractCapabilityMachineEntity
extends AbstractMachineEntity {
    @Store(value={NBTAction.SAVE, NBTAction.ITEM})
    @Nonnull
    private final EnderInventory inventory = new EnderInventory();
    @Nonnull
    private final EnderInventory inventoryDelegate;
    @Nonnull
    private final EnderInventory.View upgradeSlots;
    @Nonnull
    private final EnderInventory.View inputSlots;
    @Nonnull
    private final EnderInventory.View outputSlots;

    protected AbstractCapabilityMachineEntity() {
        this(null);
    }

    protected AbstractCapabilityMachineEntity(EnderInventory subclassInventory) {
        this.inventoryDelegate = subclassInventory != null ? subclassInventory : this.inventory;
        this.upgradeSlots = this.inventoryDelegate.getView(EnderInventory.Type.UPGRADE);
        this.inputSlots = this.inventoryDelegate.getView(EnderInventory.Type.INPUT);
        this.outputSlots = this.inventoryDelegate.getView(EnderInventory.Type.OUTPUT);
        this.inventoryDelegate.setOwner((TileEntity)this);
    }

    @Nonnull
    public EnderInventory getInventory() {
        return this.inventoryDelegate;
    }

    public boolean isValidUpgrade(@Nonnull ItemStack itemstack) {
        for (InventorySlot slot : this.upgradeSlots) {
            if (!slot.isItemValidForSlot(itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidInput(@Nonnull ItemStack itemstack) {
        for (InventorySlot slot : this.inputSlots) {
            if (!slot.isItemValidForSlot(itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidOutput(@Nonnull ItemStack itemstack) {
        for (InventorySlot slot : this.outputSlots) {
            if (!slot.isItemValidForSlot(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean doPush(@Nullable EnumFacing dir) {
        if (dir == null || this.outputSlots.getSlots() <= 0 || !this.shouldDoWorkThisTick(20)) {
            return false;
        }
        return ItemTools.move(this.getPushLimit(), (IBlockAccess)this.field_145850_b, (TileEntity)this, dir, this.func_174877_v().func_177972_a(dir), dir.func_176734_d()) == ItemTools.MoveResult.MOVED;
    }

    @Override
    protected boolean doPull(@Nullable EnumFacing dir) {
        if (dir == null || this.inputSlots.getSlots() <= 0 || !this.shouldDoWorkThisTick(20) || !this.hasSpaceToPull()) {
            return false;
        }
        return ItemTools.move(this.getPullLimit(), (IBlockAccess)this.field_145850_b, this.func_174877_v().func_177972_a(dir), dir.func_176734_d(), (TileEntity)this, dir) == ItemTools.MoveResult.MOVED;
    }

    protected boolean hasSpaceToPull() {
        for (InventorySlot slot : this.inputSlots) {
            ItemStack stack = slot.getStackInSlot(0);
            if (!Prep.isInvalid(stack) && stack.func_190916_E() >= Math.min(stack.func_77976_d(), slot.getMaxStackSize())) continue;
            return true;
        }
        return false;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facingIn) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return facingIn == null || this.getIoMode(facingIn).canInputOrOutput();
        }
        return super.hasCapability(capability, facingIn);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facingIn) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new Side(facingIn);
        }
        return (T)super.getCapability(capability, facingIn);
    }

    private class Side
    implements IItemHandler {
        private final EnumFacing side;

        protected Side(EnumFacing side) {
            this.side = side;
        }

        @Nonnull
        private IItemHandler getView() {
            if (this.side == null) {
                return AbstractCapabilityMachineEntity.this.getInventory().getView(EnderInventory.Type.INTERNAL);
            }
            switch (AbstractCapabilityMachineEntity.this.getIoMode(this.side)) {
                case NONE: 
                case PUSH_PULL: {
                    return AbstractCapabilityMachineEntity.this.getInventory().getView(EnderInventory.Type.INOUT);
                }
                case PULL: {
                    return AbstractCapabilityMachineEntity.this.getInventory().getView(EnderInventory.Type.INPUT);
                }
                case PUSH: {
                    return AbstractCapabilityMachineEntity.this.getInventory().getView(EnderInventory.Type.OUTPUT);
                }
            }
            return EnderInventory.OFF;
        }

        public int getSlots() {
            return this.getView().getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.getView().getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            IoMode mode;
            if (!Prep.isInvalid(stack) && (mode = AbstractCapabilityMachineEntity.this.getIoMode(this.side)).canRecieveInput()) {
                return AbstractCapabilityMachineEntity.this.getInventory().getView(EnderInventory.Type.INPUT).insertItem(slot, stack, simulate);
            }
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            IoMode mode = AbstractCapabilityMachineEntity.this.getIoMode(this.side);
            if (mode.canOutput()) {
                return AbstractCapabilityMachineEntity.this.getInventory().getView(EnderInventory.Type.OUTPUT).extractItem(slot, amount, simulate);
            }
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return this.getView().getSlotLimit(slot);
        }
    }
}

