/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.material.glass;

import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.BlockEio;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.TileEntityEio;
import crazypants.enderio.base.block.painted.BlockItemPaintedBlock;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.material.glass.FusedQuartzType;
import crazypants.enderio.base.render.ICustomItemResourceLocation;
import crazypants.enderio.base.render.ISmartRenderAwareBlock;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockFusedQuartzBase<T extends TileEntityEio>
extends BlockEio<T>
implements ISmartRenderAwareBlock {
    public BlockFusedQuartzBase(@Nonnull IModObject modObject) {
        super(modObject, Material.field_151592_s);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149647_a(EnderIOTab.tabEnderIO);
        this.setShape(this.mkShape(BlockFaceShape.SOLID));
    }

    @Override
    public Item createBlockItem(@Nonnull IModObject modObject) {
        return modObject.apply(new BlockItemFusedQuartzBase((Block)this));
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FusedQuartzType.KIND, (Comparable)((Object)FusedQuartzType.getTypeFromMeta(meta)));
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return FusedQuartzType.getMetaFromType((FusedQuartzType)((Object)state.func_177229_b(FusedQuartzType.KIND)));
    }

    public float getExplosionResistance(@Nonnull World world, @Nonnull BlockPos pos, @Nullable Entity exploder, @Nonnull Explosion explosion) {
        if (((FusedQuartzType)((Object)world.func_180495_p(pos).func_177229_b(FusedQuartzType.KIND))).isBlastResistant()) {
            return 1200.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public int func_149717_k(@Nonnull IBlockState state) {
        return ((FusedQuartzType)((Object)state.func_177229_b(FusedQuartzType.KIND))).getLightOpacity();
    }

    @Deprecated
    public int func_149750_m(@Nonnull IBlockState state) {
        return ((FusedQuartzType)((Object)state.func_177229_b(FusedQuartzType.KIND))).isEnlightened() ? 15 : super.func_149750_m(state);
    }

    public int func_180651_a(@Nonnull IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean isSideSolid(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return side != EnumFacing.UP;
    }

    public boolean canPlaceTorchOnTop(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return true;
    }

    public boolean doesSideBlockChestOpening(@Nonnull IBlockState blockStateIn, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return side != EnumFacing.DOWN;
    }

    @Override
    public boolean canBeWrenched() {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public static class BlockItemFusedQuartzBase
    extends BlockItemPaintedBlock
    implements ICustomItemResourceLocation {
        public BlockItemFusedQuartzBase(@Nonnull Block block) {
            super(block);
        }

        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, tooltip, flagIn);
            FusedQuartzType type = this.determineQuartzType(stack);
            if (type.isBlastResistant()) {
                tooltip.add(Lang.BLOCK_BLAST_RESISTANT.get());
            }
            if (type.isEnlightened()) {
                tooltip.add(Lang.BLOCK_LIGHT_EMITTER.get());
            }
            if (type.getLightOpacity() > 0) {
                tooltip.add(Lang.BLOCK_LIGHT_BLOCKER.get());
            }
        }

        @SideOnly(value=Side.CLIENT)
        protected FusedQuartzType determineQuartzType(ItemStack par1ItemStack) {
            int meta = par1ItemStack.func_77952_i();
            FusedQuartzType type = FusedQuartzType.getTypeFromMeta(meta);
            return type;
        }

        @Override
        @Nonnull
        public ResourceLocation getRegistryNameForCustomModelResourceLocation() {
            return ModObject.blockFusedQuartz.getItem().getRegistryName();
        }
    }
}

