/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.material.glass;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.config.Config;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.util.IStringSerializable;

public enum FusedQuartzType implements IStringSerializable
{
    FUSED_QUARTZ("fusedQuartz", BaseMaterial.QUARTZ, Upgrade.NONE),
    FUSED_GLASS("fusedGlass", BaseMaterial.GLASS, Upgrade.NONE),
    ENLIGHTENED_FUSED_QUARTZ("enlightenedFusedQuartz", BaseMaterial.QUARTZ, Upgrade.ENLIGHTENED),
    ENLIGHTENED_FUSED_GLASS("enlightenedFusedGlass", BaseMaterial.GLASS, Upgrade.ENLIGHTENED),
    DARK_FUSED_QUARTZ("darkFusedQuartz", BaseMaterial.QUARTZ, Upgrade.DARKENED),
    DARK_FUSED_GLASS("darkFusedGlass", BaseMaterial.GLASS, Upgrade.DARKENED);

    @Nonnull
    public static final PropertyEnum<FusedQuartzType> KIND;
    @Nonnull
    private final String oreDictName;
    @Nonnull
    private final BaseMaterial baseMaterial;
    @Nonnull
    private final Upgrade upgrade;
    private Block block;

    private FusedQuartzType(@Nonnull String oreDictName, BaseMaterial baseMaterial, Upgrade upgrade) {
        this.oreDictName = oreDictName;
        this.baseMaterial = baseMaterial;
        this.upgrade = upgrade;
    }

    public boolean connectTo(FusedQuartzType other) {
        return other != null && (Config.clearGlassConnectToFusedQuartz && Config.glassConnectToTheirVariants || Config.clearGlassConnectToFusedQuartz && this.upgrade == other.upgrade || Config.glassConnectToTheirVariants && this.baseMaterial == other.baseMaterial);
    }

    @Nonnull
    public String func_176610_l() {
        return (String)NullHelper.notnullJ((Object)this.name().toLowerCase(Locale.ENGLISH), (String)"String.toLowerCase()");
    }

    @Nonnull
    public static FusedQuartzType getTypeFromMeta(int meta) {
        return (FusedQuartzType)((Object)NullHelper.notnullJ((Object)((Object)FusedQuartzType.values()[meta >= 0 && meta < FusedQuartzType.values().length ? meta : 0]), (String)"Enum.values()"));
    }

    public static int getMetaFromType(@Nonnull FusedQuartzType fusedQuartzType) {
        return fusedQuartzType.ordinal();
    }

    public boolean isEnlightened() {
        return this.upgrade == Upgrade.ENLIGHTENED;
    }

    public boolean isBlastResistant() {
        return this.baseMaterial == BaseMaterial.QUARTZ;
    }

    public int getLightOpacity() {
        return this.upgrade == Upgrade.DARKENED ? 255 : 0;
    }

    @Nonnull
    public String getOreDictName() {
        return this.oreDictName;
    }

    @Nonnull
    public Block getBlock() {
        return (Block)NullHelper.notnull((Object)this.block, (String)"block not initialized");
    }

    public void setBlock(@Nonnull Block block) {
        this.block = block;
    }

    static {
        KIND = PropertyEnum.func_177709_a((String)"kind", FusedQuartzType.class);
    }

    private static enum Upgrade {
        NONE,
        ENLIGHTENED,
        DARKENED;

    }

    private static enum BaseMaterial {
        QUARTZ,
        GLASS;

    }
}

