/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.material.material;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.init.ModObject;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;

public enum Material {
    SIMPLE_MACHINE_CHASSI("simpleMachineChassi"),
    MACHINE_CHASSI("machineChassi"),
    CHASSIPARTS("chassiParts"),
    PLATE_PHOTOVOLTAIC("platePhotovoltaic"),
    CONDUIT_BINDER("conduitBinder"),
    SILICON("silicon"),
    GLIDER_WING("gliderWing"),
    GLIDER_WINGS("gliderWings"),
    NUTRITIOUS_STICK("nutritiousStick"),
    GEAR_WOOD("gear_wood", "gearWood"),
    GEAR_STONE("gear_stone", "gearStone"),
    GEAR_IRON("gear_iron", "gearIronInfinity"),
    GEAR_ENERGIZED("gear_energized", "gearEnergized"),
    GEAR_VIBRANT("gear_vibrant", "gearVibrant"),
    PULSATING_CYSTAL("pulsatingCrystal", true),
    VIBRANT_CYSTAL("vibrantCrystal", true),
    ENDER_CRYSTAL("enderCrystal", true),
    ATTRACTOR_CRYSTAL("attractorCrystal", true),
    WEATHER_CRYSTAL("weatherCrystal", true),
    PRECIENT_CRYSTAL("precientCrystal", true),
    POWDER_INFINITY("powder_infinity", "dustBedrock"),
    POWDER_FLOUR("dust_wheat", "dustWheat"),
    POWDER_BINDER_COMPOSITE("binderComposite"),
    POWDER_COAL("powder_coal", "dustCoal"),
    POWDER_IRON("powder_iron", "dustIron"),
    POWDER_GOLD("powder_gold", "dustGold"),
    POWDER_COPPER("powder_copper", "dustCopper", "ingotCopper"),
    POWDER_TIN("powder_tin", "dustTin", "ingotTin"),
    POWDER_ENDER("powder_ender", "nuggetEnderpearl"),
    POWDER_OBSIDIAN("powder_obsidian", "dustObsidian"),
    POWDER_ARDITE("powder_ardite", "dustArdite", "oreArdite"),
    POWDER_COBALT("powder_cobalt", "dustCobalt", "oreCobalt"),
    POWDER_LAPIS("powder_lapis_lazuli", "dustLapis"),
    POWDER_QUARTZ("powder_quartz", "dustNetherQuartz"),
    POWDER_PRECIENT("precientPowder", true),
    POWDER_VIBRANT("vibrantPowder", true),
    POWDER_PULSATING("pulsatingPowder", true),
    POWDER_ENDER_CYSTAL("enderCrystalPowder", true),
    POWDER_PHOTOVOLTAIC("powderPhotovoltaic"),
    INGOT_ENDERIUM_BASE("ingot_enderium_base", "ingotEnderiumBase", "ingotEnderium"),
    ZOMBIE_ELECTRODE("skullZombieElectrode", "skullZombieElectrode"),
    ZOMBIE_CONTROLLER("skullZombieController", "skullZombieController"),
    FRANKEN_ZOMBIE("skullZombieFrankenstien", "skullZombieFrankenstein", true),
    ENDER_RESONATOR("skullEnderResonator", "skullEnderResonator"),
    SENTIENT_ENDER("skullSentientEnder", "skullSentientEnder", true),
    SKELETAL_CONTRACTOR("skullSkeletalContractor", "skullSkeletalContractor"),
    PLANT_GREEN("plantgreen"),
    PLANT_BROWN("plantbrown"),
    DYE_GREEN("organic_green_dye", "dyeGreen"),
    DYE_BROWN("organic_brown_dye", "dyeBrown"),
    DYE_BLACK("organic_black_dye", "dyeBlack"),
    DYE_MACHINE("machine_dye", "dyeMachine"),
    DYE_SOUL_MACHINE("soul_machine_dye", "dyeSoulMachine"),
    SOUL_MACHINE_CHASSIS("soulMachineChassi"),
    ENHANCED_MACHINE_CHASSIS("enhancedMachineChassi"),
    UNSOULED_MACHINE_CHASSIS("unsouledMachineChassi"),
    GUARDIAN_DIODE("skullGuardianDiode", "skullGuardianDiode"),
    GRINDING_BALL_SIGNALUM("grindingBallSignalum"),
    GRINDING_BALL_ENDERIUM("grindingBallEnderium"),
    GRINDING_BALL_LUMIUM("grindingBallLumium"),
    REDSTONE_FILTER_BASE("redstoneFilterBase"),
    POWDER_CONFUSION("confusingDust"),
    SHARD_ENDER("enderFragment"),
    POWDER_WITHERING("witheringDust"),
    REMOTE_AWARENESS_UPGRADE("remoteAwarenessUpgrade"),
    DISH("dish", "itemWirelessDish"),
    END_STEEL_MACHINE_CHASSIS("endSteelMachineChassi"),
    DYE_ENHANCED_MACHINE("enhanced_machine_dye", "dyeEnhancedMachine"),
    ENHANCED_CHASSIPARTS("enhancedChassiParts"),
    SIMPLE_CHASSIPARTS("simpleChassiParts"),
    CAKE_BASE("cakeBase"),
    INFINITY_ROD("infinityRod"),
    BRICK_GLAZED_NETHER("glazedNetherBrick", "ingotBrickNetherGlazed"),
    GEAR_DARKSTEEL("gear_darksteel", "gearDark"),
    POWDER_SOUL("powder_soul", "dustSoularium"),
    INFINITY_GOOP("infinity_goop", "itemInfinityGoop"),
    ENERGETIC_SILVER("ingot_energetic_silver", "ingotEnergeticSilver"),
    COMBUSTIVE_METAL("ingot_combustive_metal", "ingotCombustiveMetal"),
    CRUDE_STEEL("ingot_crude_steel", "ingotCrudeSteel"),
    CRYSTALLINE_ALLOY("ingot_crystalline_alloy", "ingotCrystallineAlloy"),
    MELODIC_ALLOY("ingot_melodic_alloy", "ingotMelodicAlloy"),
    STELLAR_ALLOY("ingot_stellar_alloy", "ingotStellarAlloy"),
    CRYSTAlLINE_PINK_SLIME("ingot_crystalline_pink_slime", "ingotCrystallinePinkSlime");

    public final boolean hasEffect;
    @Nonnull
    private final String baseName;
    @Nonnull
    private final String oreDict;
    private final String dependency;

    private Material(String baseName) {
        this(baseName, "item" + StringUtils.capitalize((String)baseName), false);
    }

    private Material(String baseName, String oreDict) {
        this(baseName, oreDict, false);
    }

    private Material(String baseName, boolean hasEffect) {
        this(baseName, "item" + StringUtils.capitalize((String)baseName), hasEffect);
    }

    private Material(String baseName, String oreDict, boolean hasEffect) {
        this(baseName, oreDict, hasEffect, null);
    }

    private Material(@Nullable String baseName, String oreDict, String dependency) {
        this(baseName, oreDict, false, dependency);
    }

    private Material(String baseName, @Nullable String oreDict, boolean hasEffect, String dependency) {
        this.baseName = baseName.replaceAll("([A-Z])", "_$0").toLowerCase(Locale.ENGLISH);
        this.oreDict = oreDict;
        this.hasEffect = hasEffect;
        this.dependency = dependency;
    }

    @Nonnull
    public String getBaseName() {
        return this.baseName;
    }

    @Nonnull
    public String getOreDict() {
        return this.oreDict;
    }

    @Nonnull
    public static Material getTypeFromMeta(int meta) {
        return (Material)((Object)NullHelper.notnullJ((Object)((Object)Material.values()[meta >= 0 && meta < Material.values().length ? meta : 0]), (String)"Enum.values()"));
    }

    public static int getMetaFromType(@Nonnull Material value) {
        return value.ordinal();
    }

    @Nonnull
    public ItemStack getStack() {
        return this.getStack(1);
    }

    @Nonnull
    public ItemStack getStack(int size) {
        return new ItemStack(ModObject.itemMaterial.getItemNN(), size, this.ordinal());
    }

    public boolean isDependencyMet() {
        return this.dependency == null || !OreDictionary.getOres((String)this.dependency).isEmpty();
    }

    public boolean hasDependency() {
        return this.dependency != null;
    }

    @Nonnull
    public static NNList<Material> getActiveMaterials() {
        NNList result = new NNList();
        for (Material material : NNList.of(Material.class)) {
            if (!material.isDependencyMet()) continue;
            result.add((Object)material);
        }
        return result;
    }
}

