/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.material.material;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.util.FluidUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.OreDictionaryHelper;
import crazypants.enderio.base.fluid.Fluids;
import crazypants.enderio.base.material.material.Material;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.IngredientNBT;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.oredict.OreIngredient;

public class NutritiousStickRecipe
extends ShapelessRecipes {
    @Nonnull
    private final NNList<Ingredient> dummyIngredients = new NNList((Object[])new Ingredient[]{new OreIngredient("stickWood"), new IngredientNBT(Fluids.NUTRIENT_DISTILLATION.getBucket()){}});

    public NutritiousStickRecipe() {
        super("", Prep.getEmpty(), (NonNullList)NNList.emptyList());
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World worldIn) {
        boolean foundStick = false;
        boolean foundFluid = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            FluidStack fluidStack;
            ItemStack stack = inv.func_70301_a(i);
            if (!Prep.isValid(stack)) continue;
            if (!foundStick && this.isStick(stack)) {
                foundStick = true;
                continue;
            }
            if (!foundFluid && (fluidStack = FluidUtil.tryDrainContainer((ItemStack)stack, (ITankAccess)new NutDistTank()).result.fluidStack) != null && fluidStack.amount >= 1000) {
                foundFluid = true;
                continue;
            }
            return false;
        }
        return foundStick && foundFluid;
    }

    private boolean isStick(@Nonnull ItemStack stack) {
        return OreDictionaryHelper.hasName((ItemStack)stack, (String)"stickWood");
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
        return Material.NUTRITIOUS_STICK.getStack();
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return Material.NUTRITIOUS_STICK.getStack();
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(@Nonnull InventoryCrafting inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            nonnulllist.set(i, (Object)this.getResult(inv.func_70301_a(i)));
        }
        return nonnulllist;
    }

    @Nonnull
    private ItemStack getResult(@Nonnull ItemStack in) {
        if (Prep.isValid(in)) {
            FluidUtil.FluidAndStackResult fill = FluidUtil.tryDrainContainer((ItemStack)in, (ITankAccess)new NutDistTank());
            FluidStack fluidStack = fill.result.fluidStack;
            if (fluidStack != null && fluidStack.amount >= 1000) {
                return fill.result.itemStack;
            }
        }
        return ForgeHooks.getContainerItem((ItemStack)in);
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return this.dummyIngredients;
    }

    public boolean func_192399_d() {
        return true;
    }

    private static class NutDistTank
    implements ITankAccess {
        private FluidTank inputTank = new FluidTank(Fluids.NUTRIENT_DISTILLATION.getFluid(), 0, 1000);

        private NutDistTank() {
        }

        public FluidTank getInputTank(FluidStack forFluidType) {
            if (forFluidType == null || FluidUtil.areFluidsTheSame((Fluid)Fluids.NUTRIENT_DISTILLATION.getFluid(), (Fluid)forFluidType.getFluid())) {
                return this.inputTank;
            }
            return null;
        }

        @Nonnull
        public FluidTank[] getOutputTanks() {
            return new FluidTank[0];
        }

        public void setTanksDirty() {
        }
    }
}

