/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.material.recipes;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.material.alloy.Alloy;
import crazypants.enderio.base.material.glass.FusedQuartzType;
import crazypants.enderio.base.material.material.Material;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;

@Mod.EventBusSubscriber(modid="enderio")
public class MaterialOredicts {
    static final String[] dyes = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};

    public static void init(FMLInterModComms.IMCEvent event) {
        Material.getActiveMaterials().apply((NNList.Callback)new NNList.Callback<Material>(){

            public void apply(@Nonnull Material material) {
                if (material.hasDependency()) {
                    OreDictionary.registerOre((String)material.getOreDict(), (ItemStack)material.getStack());
                }
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerOredict(@Nonnull RegistryEvent.Register<Item> event) {
        Material.getActiveMaterials().apply((NNList.Callback)new NNList.Callback<Material>(){

            public void apply(@Nonnull Material material) {
                if (!material.hasDependency()) {
                    OreDictionary.registerOre((String)material.getOreDict(), (ItemStack)material.getStack());
                }
            }
        });
        NNList.of(Alloy.class).apply((NNList.Callback)new NNList.Callback<Alloy>(){

            public void apply(@Nonnull Alloy alloy) {
                OreDictionary.registerOre((String)alloy.getOreBlock(), (ItemStack)alloy.getStackBlock());
                OreDictionary.registerOre((String)alloy.getOreIngot(), (ItemStack)alloy.getStackIngot());
                OreDictionary.registerOre((String)alloy.getOreNugget(), (ItemStack)alloy.getStackNugget());
                OreDictionary.registerOre((String)alloy.getOreBall(), (ItemStack)alloy.getStackBall());
            }
        });
        OreDictionary.registerOre((String)"blockGlass", (ItemStack)new ItemStack(FusedQuartzType.FUSED_GLASS.getBlock(), 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"blockGlassColorless", (ItemStack)new ItemStack(FusedQuartzType.FUSED_GLASS.getBlock(), 1, EnumDyeColor.WHITE.func_176765_a()));
        OreDictionary.registerOre((String)"blockGlassHardened", (ItemStack)new ItemStack(FusedQuartzType.FUSED_QUARTZ.getBlock(), 1, Short.MAX_VALUE));
        for (int i = 0; i < dyes.length; ++i) {
            OreDictionary.registerOre((String)("blockGlass" + dyes[i]), (ItemStack)new ItemStack(FusedQuartzType.FUSED_GLASS.getBlock(), 1, EnumDyeColor.func_176766_a((int)i).func_176765_a()));
            OreDictionary.registerOre((String)("blockGlassHardened" + dyes[i]), (ItemStack)new ItemStack(FusedQuartzType.FUSED_QUARTZ.getBlock(), 1, EnumDyeColor.func_176766_a((int)i).func_176765_a()));
        }
        for (FusedQuartzType type : FusedQuartzType.values()) {
            OreDictionary.registerOre((String)type.getOreDictName(), (ItemStack)new ItemStack(type.getBlock(), 1, Short.MAX_VALUE));
        }
        OreDictionary.registerOre((String)"itemSkull", (ItemStack)new ItemStack(Items.field_151144_bL, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"itemSkull", (ItemStack)new ItemStack(ModObject.blockEndermanSkull.getBlockNN()));
        Things.addAlias((String)Material.DYE_GREEN.getBaseName().toUpperCase(Locale.ENGLISH), (String)(ModObject.itemMaterial.getItemNN().getRegistryName() + ":" + Material.DYE_GREEN.ordinal()));
        Things.addAlias((String)Material.DYE_BROWN.getBaseName().toUpperCase(Locale.ENGLISH), (String)(ModObject.itemMaterial.getItemNN().getRegistryName() + ":" + Material.DYE_BROWN.ordinal()));
        Things.addAlias((String)Material.DYE_BLACK.getBaseName().toUpperCase(Locale.ENGLISH), (String)(ModObject.itemMaterial.getItemNN().getRegistryName() + ":" + Material.DYE_BLACK.ordinal()));
        OreDictionary.registerOre((String)"toolHoe", (ItemStack)new ItemStack(Items.field_151017_I, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"toolHoe", (ItemStack)new ItemStack(Items.field_151019_K, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"toolHoe", (ItemStack)new ItemStack(Items.field_151018_J, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"toolHoe", (ItemStack)new ItemStack(Items.field_151012_L, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"toolHoe", (ItemStack)new ItemStack(Items.field_151013_M, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"egg", (ItemStack)new ItemStack(ModObject.item_owl_egg.getItemNN()));
        OreDictionary.registerOre((String)"toolShears", (ItemStack)new ItemStack((Item)Items.field_151097_aZ, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"toolShears", (ItemStack)new ItemStack(ModObject.itemDarkSteelShears.getItemNN(), 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"toolTreetap", (ItemStack)new ItemStack(ModObject.itemDarkSteelTreetap.getItemNN(), 1, Short.MAX_VALUE));
    }
}

