/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.power.forge;

import crazypants.enderio.base.power.ILegacyPoweredTile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class InternalPoweredTileWrapper
implements IEnergyStorage {
    @Nonnull
    private final ILegacyPoweredTile tile;
    @Nullable
    protected final EnumFacing from;

    public InternalPoweredTileWrapper(@Nonnull ILegacyPoweredTile tile, @Nullable EnumFacing from) {
        this.tile = tile;
        this.from = from;
    }

    public int getEnergyStored() {
        return this.tile.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.tile.getMaxEnergyStored();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return false;
    }

    public static class PoweredTileCapabilityProvider
    implements ICapabilityProvider {
        @Nonnull
        private final ILegacyPoweredTile tile;

        public PoweredTileCapabilityProvider(@Nonnull ILegacyPoweredTile tile) {
            this.tile = tile;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityEnergy.ENERGY && facing != null && this.tile.canConnectEnergy(facing);
        }

        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityEnergy.ENERGY && facing != null && this.tile.canConnectEnergy(facing)) {
                return (T)new InternalPoweredTileWrapper(this.tile, facing);
            }
            return null;
        }
    }
}

