/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;

public class MachineRecipeRegistry {
    @Nonnull
    public static final String PAINTER = "painter";
    @Nonnull
    public static final String SAGMILL = "sagmill";
    @Nonnull
    public static final String ALLOYSMELTER = "alloysmelter";
    @Nonnull
    public static final String SLICENSPLICE = "slicensplice";
    @Nonnull
    public static final String SOULBINDER = "soulbinder";
    @Nonnull
    public static final String VAT = "vat";
    @Nonnull
    public static final String SPAWNER = "spawner";
    @Nonnull
    public static final String FARM = "farmingstation";
    @Nonnull
    public static final String TRANSCEIVER = "transceiver";
    @Nonnull
    public static final String ENCHANTER = "enchanter";
    @Nonnull
    public static final MachineRecipeRegistry instance = new MachineRecipeRegistry();
    private final Map<String, Map<String, IMachineRecipe>> machineRecipes = new HashMap<String, Map<String, IMachineRecipe>>();

    public void registerRecipe(@Nonnull String machine, @Nonnull IMachineRecipe recipe) {
        this.getRecipesForMachine(machine).put(recipe.getUid(), recipe);
    }

    @Nonnull
    public Map<String, IMachineRecipe> getRecipesForMachine(@Nonnull String machineName) {
        Map<String, IMachineRecipe> res = this.machineRecipes.get(machineName);
        if (res == null) {
            res = new LinkedHashMap<String, IMachineRecipe>();
            this.machineRecipes.put(machineName, res);
        }
        return res;
    }

    public void enableRecipeSorting(@Nonnull String machineName) {
        Map<String, IMachineRecipe> res = this.machineRecipes.get(machineName);
        if (res == null) {
            res = new TreeMap<String, IMachineRecipe>();
            this.machineRecipes.put(machineName, res);
        } else if (!(res instanceof TreeMap)) {
            res = new TreeMap<String, IMachineRecipe>(res);
            this.machineRecipes.put(machineName, res);
        }
    }

    public IMachineRecipe getRecipeForUid(@Nonnull String uid) {
        for (Map<String, IMachineRecipe> recipes : this.machineRecipes.values()) {
            for (IMachineRecipe recipe : recipes.values()) {
                if (!uid.equals(recipe.getUid())) continue;
                return recipe;
            }
        }
        return null;
    }

    public IMachineRecipe getRecipeForInputs(@Nonnull String machineName, @Nonnull NNList<MachineRecipeInput> inputs) {
        for (IMachineRecipe recipe : this.getRecipesForMachine(machineName).values()) {
            if (!recipe.isRecipe(inputs)) continue;
            return recipe;
        }
        return null;
    }

    @Nonnull
    public NNList<IMachineRecipe> getRecipesForInput(@Nonnull String machineName, @Nonnull MachineRecipeInput input) {
        NNList result = new NNList();
        Map<String, IMachineRecipe> recipes = this.getRecipesForMachine(machineName);
        for (IMachineRecipe recipe : recipes.values()) {
            if (!recipe.isValidInput(input)) continue;
            result.add((Object)recipe);
        }
        return result;
    }
}

