/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe.sagmill;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.recipe.IRecipe;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.Recipe;
import crazypants.enderio.base.recipe.sagmill.GrindingBall;
import crazypants.enderio.base.recipe.sagmill.IGrindingMultiplier;
import crazypants.enderio.base.recipe.sagmill.SagMillMachineRecipe;
import crazypants.enderio.util.Prep;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class SagMillRecipeManager {
    public static final int ORE_ENERGY_COST = 400;
    public static final int INGOT_ENERGY_COST = 240;
    @Nonnull
    static final SagMillRecipeManager instance = new SagMillRecipeManager();
    @Nonnull
    private final NNList<Recipe> recipes = new NNList();
    @Nonnull
    private final NNList<GrindingBall> balls = new NNList();
    @Nonnull
    private final Set<ItemStack> excludedStackCache = new HashSet<ItemStack>();

    @Nonnull
    public static SagMillRecipeManager getInstance() {
        return instance;
    }

    private SagMillRecipeManager() {
    }

    public boolean isValidSagBall(@Nonnull ItemStack stack) {
        return this.getGrindballFromStack(stack) != null;
    }

    public boolean isExcludedFromBallBonus(@Nonnull NNList<MachineRecipeInput> inputs) {
        if (inputs.size() < 1) {
            return true;
        }
        for (MachineRecipeInput input : inputs) {
            if (!Prep.isValid(input.item)) continue;
            if (this.isExcludedStack(input.item)) {
                return true;
            }
            int[] ids = OreDictionary.getOreIDs((ItemStack)input.item);
            if (ids == null) continue;
            for (int id : ids) {
                String name = OreDictionary.getOreName((int)id);
                if (!name.startsWith("ingot") && !name.startsWith("block") && !name.startsWith("nugget")) continue;
                this.addExcludedStack(input.item);
                return true;
            }
        }
        return false;
    }

    private void addExcludedStack(@Nonnull ItemStack item) {
        item = item.func_77946_l();
        item.func_190920_e(1);
        this.excludedStackCache.add(item);
    }

    private boolean isExcludedStack(@Nonnull ItemStack item) {
        item = item.func_77946_l();
        item.func_190920_e(1);
        return this.excludedStackCache.contains(item);
    }

    public IGrindingMultiplier getGrindballFromStack(@Nonnull ItemStack stack) {
        if (Prep.isInvalid(stack)) {
            return null;
        }
        for (GrindingBall ball : this.balls) {
            if (!ball.isInput(stack)) continue;
            return ball;
        }
        return null;
    }

    public boolean isValidInput(@Nonnull MachineRecipeInput input) {
        if (input.slotNumber == 1) {
            return this.isValidSagBall(input.item);
        }
        return this.getRecipeForInput(input.item) != null;
    }

    public void create() {
        MachineRecipeRegistry.instance.registerRecipe("sagmill", new SagMillMachineRecipe());
    }

    public IRecipe getRecipeForInput(@Nonnull ItemStack input) {
        if (Prep.isInvalid(input)) {
            return null;
        }
        NNList machineRecipeInput = new NNList((Object[])new MachineRecipeInput[]{new MachineRecipeInput(0, input)});
        for (Recipe recipe : this.recipes) {
            if (!recipe.isInputForRecipe((NNList<MachineRecipeInput>)machineRecipeInput)) continue;
            return recipe;
        }
        return null;
    }

    public void addRecipe(@Nonnull Recipe recipe) {
        if (!recipe.isValid()) {
            Log.debug("Could not add invalid recipe: " + recipe);
            return;
        }
        IRecipe rec = this.getRecipeForInput(SagMillRecipeManager.getInput(recipe));
        if (rec != null) {
            Log.warn("Not adding supplied recipe as a recipe already exists for the input: " + SagMillRecipeManager.getInput(recipe));
            return;
        }
        this.recipes.add((Object)recipe);
    }

    @Nonnull
    public NNList<Recipe> getRecipes() {
        return this.recipes;
    }

    @Nonnull
    public static ItemStack getInput(@Nonnull IRecipe recipe) {
        if (recipe.getInputs().length == 0) {
            return Prep.getEmpty();
        }
        return recipe.getInputs()[0].getInput();
    }

    @Nonnull
    public NNList<GrindingBall> getBalls() {
        return this.balls;
    }

    public void addBall(@Nonnull GrindingBall ball) {
        this.balls.add((Object)ball);
    }
}

