/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe.vat;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.recipe.AbstractMachineRecipe;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.IRecipe;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.vat.VatRecipe;
import crazypants.enderio.base.recipe.vat.VatRecipeManager;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class VatMachineRecipe
extends AbstractMachineRecipe {
    @Override
    @Nonnull
    public String getUid() {
        return "StillRecipe";
    }

    @Override
    public IRecipe getRecipeForInputs(@Nonnull NNList<MachineRecipeInput> inputs) {
        return VatRecipeManager.instance.getRecipeForInput(inputs);
    }

    @Override
    public boolean isValidInput(@Nonnull MachineRecipeInput input) {
        return VatRecipeManager.instance.isValidInput(input);
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return "vat";
    }

    @Override
    @Nonnull
    public NNList<MachineRecipeInput> getQuantitiesConsumed(@Nonnull NNList<MachineRecipeInput> inputs) {
        NNList result = new NNList();
        VatRecipe rec = (VatRecipe)this.getRecipeForInputs(inputs);
        FluidStack inputFluidStack = rec.getRequiredFluidInput(inputs);
        result.add((Object)new MachineRecipeInput(0, inputFluidStack));
        for (MachineRecipeInput ri : inputs) {
            if (ri.isFluid() || !Prep.isValid(ri.item)) continue;
            ItemStack st = ri.item.func_77946_l();
            st.func_190920_e(rec.getNumConsumed(ri.item));
            result.add((Object)new MachineRecipeInput(ri.slotNumber, st));
        }
        return result;
    }

    @Override
    @Nonnull
    public IMachineRecipe.ResultStack[] getCompletedResult(long nextSeed, float chanceMultiplier, @Nonnull NNList<MachineRecipeInput> inputs) {
        if (inputs.size() <= 0) {
            return new IMachineRecipe.ResultStack[0];
        }
        VatRecipe recipe = (VatRecipe)this.getRecipeForInputs(inputs);
        if (recipe == null || !recipe.isValid()) {
            return new IMachineRecipe.ResultStack[0];
        }
        FluidStack fluidOutput = recipe.getFluidOutput(inputs);
        if (fluidOutput == null) {
            return new IMachineRecipe.ResultStack[0];
        }
        return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(fluidOutput)};
    }
}

