/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.transceiver;

import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.UserIdent;
import com.mojang.authlib.GameProfile;
import crazypants.enderio.base.transceiver.ChannelType;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;

@Storable
public class Channel {
    @Store
    @Nonnull
    private final String name;
    @Store
    @Nonnull
    private final UserIdent user;
    @Store
    @Nonnull
    private final ChannelType type;

    public static Channel readFromNBT(NBTTagCompound root) {
        String name = root.func_74779_i("name");
        UserIdent user = UserIdent.readfromNbt((NBTTagCompound)root, (String)"user");
        ChannelType type = (ChannelType)((Object)NullHelper.notnullJ((Object)((Object)ChannelType.values()[root.func_74765_d("type")]), (String)"Enum.values()"));
        return name.isEmpty() ? null : new Channel(name, user, type);
    }

    public Channel(@Nonnull String name, @Nonnull UserIdent user, @Nonnull ChannelType type) {
        this.name = (String)NullHelper.first((Object[])new String[]{name.trim(), ""});
        this.user = user;
        this.type = type;
    }

    public Channel(@Nonnull String name, @Nonnull GameProfile profile, @Nonnull ChannelType type) {
        this(name, UserIdent.create((GameProfile)profile), type);
    }

    public Channel(@Nonnull String name, @Nonnull ChannelType type) {
        this(name, (UserIdent)UserIdent.NOBODY, type);
    }

    public boolean isPublic() {
        return this.user == UserIdent.NOBODY;
    }

    public void writeToNBT(NBTTagCompound root) {
        if (this.name.isEmpty()) {
            return;
        }
        root.func_74778_a("name", this.name);
        this.user.saveToNbt(root, "user");
        root.func_74777_a("type", (short)this.type.ordinal());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.user.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Channel other = (Channel)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return this.user.equals(other.user);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public ChannelType getType() {
        return this.type;
    }

    @Nonnull
    public UserIdent getUser() {
        return this.user;
    }

    public String toString() {
        return "Channel [name=" + this.name + ", user=" + this.user + ", type=" + (Object)((Object)this.type) + "]";
    }
}

