/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.liquid;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector4f;
import com.enderio.core.common.vecmath.Vertex;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.conduit.geom.Offset;
import crazypants.enderio.conduits.conduit.liquid.AdvancedLiquidConduit;
import crazypants.enderio.conduits.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduits.geom.ConnectionModeGeometry;
import crazypants.enderio.conduits.render.BakedQuadBuilder;
import crazypants.enderio.conduits.render.ConduitBundleRenderManager;
import crazypants.enderio.conduits.render.DefaultConduitRenderer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;

public class AdvancedLiquidConduitRenderer
extends DefaultConduitRenderer {
    @Override
    public boolean isRendererForConduit(@Nonnull IConduit conduit) {
        return conduit instanceof AdvancedLiquidConduit;
    }

    @Override
    protected BlockRenderLayer getConduitQuadsLayer() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    protected BlockRenderLayer getTransmissionQuadsLayer() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    protected void addConduitQuads(@Nonnull IConduitBundle bundle, @Nonnull IConduit conduit, @Nonnull TextureAtlasSprite tex, @Nonnull CollidableComponent component, float selfIllum, BlockRenderLayer layer, @Nonnull List<BakedQuad> quads) {
        super.addConduitQuads(bundle, conduit, tex, component, selfIllum, layer, quads);
        if (!this.isNSEWUD(component.dir)) {
            return;
        }
        AdvancedLiquidConduit lc = (AdvancedLiquidConduit)conduit;
        if (layer == BlockRenderLayer.CUTOUT) {
            for (EnumFacing dir : conduit.getExternalConnections()) {
                TextureAtlasSprite ioTex = null;
                if (conduit.getConnectionMode(dir) == ConnectionMode.INPUT) {
                    ioTex = lc.getTextureForInputMode();
                } else if (conduit.getConnectionMode(dir) == ConnectionMode.OUTPUT) {
                    ioTex = lc.getTextureForOutputMode();
                }
                if (ioTex == null) continue;
                Offset offset = bundle.getOffset(ILiquidConduit.class, dir);
                ConnectionModeGeometry.addModeConnectorQuads(dir, offset, ioTex, new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), quads);
            }
        }
        if (layer == BlockRenderLayer.TRANSLUCENT) {
            FluidStack fluid = lc.getFluidType();
            TextureAtlasSprite texture = fluid != null ? RenderUtil.getStillTexture((FluidStack)fluid) : lc.getNotSetEdgeTexture();
            float shrink = 0.03125f;
            float xLen = Math.abs(component.dir.func_82601_c()) == 1 ? 0.0f : shrink;
            float yLen = Math.abs(component.dir.func_96559_d()) == 1 ? 0.0f : shrink;
            float zLen = Math.abs(component.dir.func_82599_e()) == 1 ? 0.0f : shrink;
            BoundingBox cube = component.bound;
            BoundingBox bb = cube.expand((double)(-xLen), (double)(-yLen), (double)(-zLen));
            ArrayList<Vertex> vertices = new ArrayList<Vertex>();
            for (EnumFacing d : EnumFacing.field_82609_l) {
                if (d == component.dir || d == component.dir.func_176734_d()) continue;
                EnumFacing vDir = RenderUtil.getVDirForFace((EnumFacing)d);
                if (component.dir == EnumFacing.UP || component.dir == EnumFacing.DOWN) {
                    vDir = RenderUtil.getUDirForFace((EnumFacing)d);
                } else if ((component.dir == EnumFacing.NORTH || component.dir == EnumFacing.SOUTH) && d.func_96559_d() != 0) {
                    vDir = RenderUtil.getUDirForFace((EnumFacing)d);
                }
                float minU = texture.func_94209_e();
                float maxU = texture.func_94212_f();
                float minV = texture.func_94206_g();
                float maxV = texture.func_94210_h();
                double sideScale = Math.max(bb.sizeX(), bb.sizeY()) * 2.0 / 16.0;
                sideScale = Math.max(sideScale, bb.sizeZ() * 2.0 / 16.0);
                double width = Math.min(bb.sizeX(), bb.sizeY()) * 15.0 / 16.0;
                NNList corners = bb.getCornersWithUvForFace(d, minU, maxU, minV, maxV);
                this.moveEdgeCorners((List<Vertex>)corners, vDir, width);
                this.moveEdgeCorners((List<Vertex>)corners, component.dir.func_176734_d(), sideScale);
                for (Vertex c : corners) {
                    vertices.add(c);
                }
                corners = bb.getCornersWithUvForFace(d, minU, maxU, minV, maxV);
                this.moveEdgeCorners((List<Vertex>)corners, vDir.func_176734_d(), width);
                this.moveEdgeCorners((List<Vertex>)corners, component.dir.func_176734_d(), sideScale);
                for (Vertex c : corners) {
                    vertices.add(c);
                }
            }
            BakedQuadBuilder.addBakedQuads(quads, vertices, texture, null);
        }
        if (layer == BlockRenderLayer.TRANSLUCENT && conduit.getConnectionMode(component.dir) == ConnectionMode.DISABLED) {
            tex = ConduitBundleRenderManager.instance.getConnectorIcon(component.data);
            NNList corners = component.bound.getCornersWithUvForFace(component.dir, tex.func_94209_e(), tex.func_94212_f(), tex.func_94206_g(), tex.func_94210_h());
            ArrayList<Vertex> vertices = new ArrayList<Vertex>();
            for (Vertex c : corners) {
                vertices.add(c);
            }
            for (int i = corners.size() - 1; i >= 0; --i) {
                Vertex c = (Vertex)corners.get(i);
                vertices.add(c);
            }
            BakedQuadBuilder.addBakedQuads(quads, vertices, tex, null);
        }
    }

    private void moveEdgeCorners(List<Vertex> vertices, EnumFacing edge, double scaleFactor) {
        int[] indices = this.getClosest(edge, vertices);
        vertices.get((int)indices[0]).xyz.x -= scaleFactor * (double)edge.func_82601_c();
        vertices.get((int)indices[1]).xyz.x -= scaleFactor * (double)edge.func_82601_c();
        vertices.get((int)indices[0]).xyz.y -= scaleFactor * (double)edge.func_96559_d();
        vertices.get((int)indices[1]).xyz.y -= scaleFactor * (double)edge.func_96559_d();
        vertices.get((int)indices[0]).xyz.z -= scaleFactor * (double)edge.func_82599_e();
        vertices.get((int)indices[1]).xyz.z -= scaleFactor * (double)edge.func_82599_e();
    }

    private int[] getClosest(EnumFacing edge, List<Vertex> vertices) {
        int[] res = new int[]{-1, -1};
        boolean highest = edge.func_82601_c() > 0 || edge.func_96559_d() > 0 || edge.func_82599_e() > 0;
        double minMax = highest ? -1.7976931348623157E308 : Double.MAX_VALUE;
        int index = 0;
        for (Vertex v : vertices) {
            double val = this.get(v.xyz, edge);
            if (highest ? val >= minMax : val <= minMax) {
                if (val != minMax) {
                    res[0] = index;
                } else {
                    res[1] = index;
                }
                minMax = val;
            }
            ++index;
        }
        return res;
    }

    private double get(Vector3d xyz, EnumFacing edge) {
        if (edge == EnumFacing.EAST || edge == EnumFacing.WEST) {
            return xyz.x;
        }
        if (edge == EnumFacing.UP || edge == EnumFacing.DOWN) {
            return xyz.y;
        }
        return xyz.z;
    }
}

