/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.liquid;

import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.fluid.IFluidWrapper;
import com.enderio.core.common.util.FluidUtil;
import com.enderio.core.common.util.Log;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitNetwork;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.conduits.conduit.IConduitComponent;
import crazypants.enderio.conduits.conduit.liquid.AbstractLiquidConduit;
import crazypants.enderio.conduits.conduit.liquid.AbstractTankConduit;
import crazypants.enderio.conduits.conduit.liquid.AbstractTankConduitNetwork;
import crazypants.enderio.conduits.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduits.conduit.liquid.LiquidConduitNetwork;
import crazypants.enderio.conduits.conduit.liquid.PacketConduitFluidLevel;
import crazypants.enderio.conduits.config.ConduitConfig;
import crazypants.enderio.conduits.init.ConduitObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LiquidConduit
extends AbstractTankConduit
implements IConduitComponent {
    static final int VOLUME_PER_CONNECTION = 250;
    public static final TextureRegistry.TextureSupplier ICON_KEY = TextureRegistry.registerTexture("blocks/liquid_conduit");
    public static final TextureRegistry.TextureSupplier ICON_KEY_LOCKED = TextureRegistry.registerTexture("blocks/liquid_conduit_locked");
    public static final TextureRegistry.TextureSupplier ICON_CORE_KEY = TextureRegistry.registerTexture("blocks/liquid_conduit_core");
    public static final TextureRegistry.TextureSupplier ICON_EXTRACT_KEY = TextureRegistry.registerTexture("blocks/liquid_conduit_extract");
    public static final TextureRegistry.TextureSupplier ICON_EMPTY_EXTRACT_KEY = TextureRegistry.registerTexture("blocks/empty_liquid_conduit_extract");
    public static final TextureRegistry.TextureSupplier ICON_INSERT_KEY = TextureRegistry.registerTexture("blocks/liquid_conduit_insert");
    public static final TextureRegistry.TextureSupplier ICON_EMPTY_INSERT_KEY = TextureRegistry.registerTexture("blocks/empty_liquid_conduit_insert");
    private LiquidConduitNetwork network;
    private float lastSyncRatio = -99.0f;
    private int currentPushToken;
    private EnumFacing startPushDir = EnumFacing.DOWN;
    private long ticksSinceFailedExtract = 0L;

    @Override
    public void updateEntity(@Nonnull World world) {
        super.updateEntity(world);
        if (world.field_72995_K) {
            return;
        }
        this.updateStartPushDir();
        this.doExtract();
        if (this.stateDirty) {
            this.getBundle().dirty();
            this.stateDirty = false;
            this.lastSyncRatio = this.tank.getFilledRatio();
        } else if (this.lastSyncRatio != this.tank.getFilledRatio() && world.func_82737_E() % 2L == 0L) {
            BlockPos pos = this.getBundle().getLocation();
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketConduitFluidLevel(this), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0));
            this.lastSyncRatio = this.tank.getFilledRatio();
        }
    }

    private void doExtract() {
        if (!this.hasExtractableMode()) {
            return;
        }
        ++this.ticksSinceFailedExtract;
        if (this.ticksSinceFailedExtract > 9L && this.ticksSinceFailedExtract % 10L != 0L) {
            return;
        }
        for (EnumFacing dir : this.externalConnections) {
            int used;
            FluidStack couldDrain;
            IFluidWrapper extTank;
            if (!this.autoExtractForDir(dir) || (extTank = this.getExternalHandler(dir)) == null || (couldDrain = extTank.getAvailableFluid()) == null || couldDrain.amount <= 0 || !this.canFill(dir, couldDrain)) continue;
            couldDrain = couldDrain.copy();
            if (couldDrain.amount > ConduitConfig.fluid_tier1_extractRate.get()) {
                couldDrain.amount = ConduitConfig.fluid_tier1_extractRate.get();
            }
            if ((used = this.pushLiquid(dir, couldDrain, true, this.network == null ? -1 : this.network.getNextPushToken())) <= 0) continue;
            couldDrain.amount = used;
            extTank.drain(couldDrain);
            if (this.network != null && this.network.getFluidType() == null) {
                this.network.setFluidType(couldDrain);
            }
            this.ticksSinceFailedExtract = 0L;
        }
    }

    public IFluidTankProperties[] getTankProperties() {
        if (this.network == null) {
            return new FluidTankProperties[0];
        }
        return new FluidTankProperties[]{new FluidTankProperties(this.tank.getFluid(), this.tank.getCapacity())};
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.drain(resource.amount, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill, boolean doPush, int pushToken) {
        if (this.network == null) {
            Log.error((String)"The network for this conduit was null when asked to fill. Please report this to the Ender IO github");
            return 0;
        }
        if (!this.network.canAcceptLiquid(resource)) {
            return 0;
        }
        this.network.setFluidType(resource);
        resource = resource.copy();
        resource.amount = Math.min(ConduitConfig.fluid_tier1_maxIO.get(), resource.amount);
        if (doPush) {
            return this.pushLiquid(from, resource, doFill, pushToken);
        }
        return this.tank.fill(resource, doFill);
    }

    private void updateStartPushDir() {
        EnumFacing newVal = this.getNextDir(this.startPushDir);
        boolean foundNewStart = false;
        while (newVal != this.startPushDir && !foundNewStart) {
            foundNewStart = this.getConduitConnections().contains(newVal) || this.getExternalConnections().contains(newVal);
            newVal = this.getNextDir(newVal);
        }
        this.startPushDir = newVal;
    }

    private EnumFacing getNextDir(@Nonnull EnumFacing dir) {
        if (dir.ordinal() >= EnumFacing.field_82609_l.length - 1) {
            return EnumFacing.field_82609_l[0];
        }
        return EnumFacing.field_82609_l[dir.ordinal() + 1];
    }

    private int pushLiquid(@Nullable EnumFacing from, FluidStack pushStack, boolean doPush, int token) {
        if (token == this.currentPushToken || pushStack == null || pushStack.amount <= 0 || this.network == null) {
            return 0;
        }
        this.currentPushToken = token;
        int pushed = 0;
        int total = pushStack.amount;
        EnumFacing dir = this.startPushDir;
        FluidStack toPush = pushStack.copy();
        int filledLocal = this.tank.fill(toPush, doPush);
        toPush.amount -= filledLocal;
        pushed += filledLocal;
        do {
            IFluidWrapper con;
            if (dir == from || !this.canOutputToDir(dir) || this.autoExtractForDir(dir)) continue;
            if (this.getConduitConnections().contains(dir)) {
                ILiquidConduit conduitCon = this.getFluidConduit(dir);
                if (conduitCon == null) continue;
                int toCon = ((LiquidConduit)conduitCon).pushLiquid(dir.func_176734_d(), toPush, doPush, token);
                toPush.amount -= toCon;
                pushed += toCon;
                continue;
            }
            if (!this.getExternalConnections().contains(dir) || (con = this.getExternalHandler(dir)) == null) continue;
            int toExt = doPush ? con.fill(toPush) : con.offer(toPush);
            toPush.amount -= toExt;
            pushed += toExt;
            if (!doPush) continue;
            this.network.outputedToExternal(toExt);
        } while ((dir = this.getNextDir(dir)) != this.startPushDir && pushed < total);
        return pushed;
    }

    private ILiquidConduit getFluidConduit(@Nonnull EnumFacing dir) {
        TileEntity ent = this.getBundle().getEntity();
        return ConduitUtil.getConduit(ent.func_145831_w(), ent, dir, ILiquidConduit.class);
    }

    @Override
    public boolean canFill(EnumFacing from, FluidStack fluid) {
        if (!this.getConnectionMode(from).acceptsInput() || this.network == null || fluid == null || fluid.amount <= 0) {
            return false;
        }
        if (this.tank.getFluid() == null) {
            return true;
        }
        return fluid != null && FluidUtil.areFluidsTheSame((Fluid)fluid.getFluid(), (Fluid)this.tank.getFluid().getFluid());
    }

    @Override
    public boolean canDrain(EnumFacing from, FluidStack fluid) {
        if (!this.getConnectionMode(from).acceptsOutput() || this.tank.getFluid() == null || fluid == null) {
            return false;
        }
        return FluidUtil.areFluidsTheSame((Fluid)this.tank.getFluid().getFluid(), (Fluid)fluid.getFluid());
    }

    @Override
    public void connectionsChanged() {
        super.connectionsChanged();
        this.updateTank();
    }

    @Override
    @Nonnull
    public ItemStack createItem() {
        return new ItemStack(ConduitObject.item_liquid_conduit.getItemNN(), 1, 0);
    }

    @Override
    @Nonnull
    public IConduitNetwork<?, ?> getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(@Nonnull IConduitNetwork<?, ?> network) {
        if (!(network instanceof AbstractTankConduitNetwork)) {
            return false;
        }
        AbstractTankConduitNetwork n = (AbstractTankConduitNetwork)network;
        if (this.tank.getFluid() == null) {
            this.tank.setLiquid(n.getFluidType() == null ? null : n.getFluidType().copy());
        } else if (n.getFluidType() == null) {
            n.setFluidType(this.tank.getFluid());
        } else if (!this.tank.getFluid().isFluidEqual(n.getFluidType())) {
            return false;
        }
        this.network = (LiquidConduitNetwork)network;
        return true;
    }

    @Override
    public void clearNetwork() {
        this.network = null;
    }

    @Override
    public boolean canConnectToConduit(@Nonnull EnumFacing direction, @Nonnull IConduit con) {
        if (!super.canConnectToConduit(direction, con)) {
            return false;
        }
        if (!(con instanceof LiquidConduit)) {
            return false;
        }
        if (this.getFluidType() != null && ((LiquidConduit)con).getFluidType() == null) {
            return false;
        }
        return LiquidConduitNetwork.areFluidsCompatable(this.getFluidType(), ((LiquidConduit)con).getFluidType());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public TextureAtlasSprite getTextureForState(@Nonnull CollidableComponent component) {
        if (component.dir == null) {
            return ICON_CORE_KEY.get(TextureAtlasSprite.class);
        }
        if (this.getConnectionMode(component.dir) == ConnectionMode.INPUT) {
            return (this.getFluidType() == null ? ICON_EMPTY_EXTRACT_KEY : ICON_EXTRACT_KEY).get(TextureAtlasSprite.class);
        }
        if (this.getConnectionMode(component.dir) == ConnectionMode.OUTPUT) {
            return (this.getFluidType() == null ? ICON_EMPTY_INSERT_KEY : ICON_INSERT_KEY).get(TextureAtlasSprite.class);
        }
        return this.fluidTypeLocked ? ICON_KEY_LOCKED.get(TextureAtlasSprite.class) : ICON_KEY.get(TextureAtlasSprite.class);
    }

    @Override
    public TextureAtlasSprite getTransmitionTextureForState(@Nonnull CollidableComponent component) {
        if (this.tank.getFluid() != null && this.tank.getFluid().getFluid() != null) {
            return RenderUtil.getStillTexture((FluidStack)this.tank.getFluid());
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vector4f getTransmitionTextureColorForState(@Nonnull CollidableComponent component) {
        if (this.tank.getFluid() != null && this.tank.getFluid().getFluid() != null) {
            int color = this.tank.getFluid().getFluid().getColor(this.tank.getFluid());
            return new Vector4f((double)(color >> 16 & 0xFF) / 255.0, (double)(color >> 8 & 0xFF) / 255.0, (double)(color & 0xFF) / 255.0, 1.0);
        }
        return null;
    }

    @Override
    public float getTransmitionGeometryScale() {
        return this.tank.getFilledRatio();
    }

    @Override
    protected void updateTank() {
        int totalConnections = this.getConduitConnections().size() + this.getExternalConnections().size();
        this.tank.setCapacity(totalConnections * 250);
    }

    @Override
    protected boolean canJoinNeighbour(ILiquidConduit n) {
        return n instanceof LiquidConduit;
    }

    @Override
    public AbstractTankConduitNetwork<? extends AbstractTankConduit> getTankNetwork() {
        return this.network;
    }

    @Override
    public IFluidHandler getFluidDir(@Nullable EnumFacing dir) {
        if (dir != null) {
            return new ConnectionLiquidConduitSide(dir);
        }
        return this;
    }

    @Nonnull
    public LiquidConduitNetwork createNetworkForType() {
        return new LiquidConduitNetwork();
    }

    protected class ConnectionLiquidConduitSide
    extends AbstractLiquidConduit.ConnectionLiquidSide {
        public ConnectionLiquidConduitSide(EnumFacing side) {
            super(side);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int fill(FluidStack resource, boolean doFill) {
            if (LiquidConduit.this.canFill(this.side, resource) && LiquidConduit.this.network.lockNetworkForFill()) {
                try {
                    int res = LiquidConduit.this.fill(this.side, resource, doFill, true, LiquidConduit.this.network == null ? -1 : LiquidConduit.this.network.getNextPushToken());
                    if (doFill && LiquidConduit.this.externalConnections.contains(this.side) && LiquidConduit.this.network != null) {
                        LiquidConduit.this.network.addedFromExternal(res);
                    }
                    int n = res;
                    return n;
                }
                finally {
                    LiquidConduit.this.network.unlockNetworkFromFill();
                }
            }
            return 0;
        }
    }
}

