/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.redstone;

import com.enderio.core.api.client.gui.ITabPanel;
import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.vecmath.Vector4f;
import com.google.common.collect.Lists;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitNetwork;
import crazypants.enderio.base.conduit.IGuiExternalConnection;
import crazypants.enderio.base.conduit.RaytraceResult;
import crazypants.enderio.base.conduit.geom.CollidableCache;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.conduit.redstone.ConnectivityTool;
import crazypants.enderio.base.conduit.redstone.signals.BundledSignal;
import crazypants.enderio.base.conduit.redstone.signals.CombinedSignal;
import crazypants.enderio.base.conduit.redstone.signals.Signal;
import crazypants.enderio.base.conduit.registry.ConduitRegistry;
import crazypants.enderio.base.diagnostics.Prof;
import crazypants.enderio.base.filter.FilterRegistry;
import crazypants.enderio.base.filter.capability.CapabilityFilterHolder;
import crazypants.enderio.base.filter.capability.IFilterHolder;
import crazypants.enderio.base.filter.redstone.DefaultInputSignalFilter;
import crazypants.enderio.base.filter.redstone.DefaultOutputSignalFilter;
import crazypants.enderio.base.filter.redstone.IInputSignalFilter;
import crazypants.enderio.base.filter.redstone.IOutputSignalFilter;
import crazypants.enderio.base.filter.redstone.IRedstoneSignalFilter;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.base.tool.ToolUtil;
import crazypants.enderio.conduits.conduit.AbstractConduit;
import crazypants.enderio.conduits.conduit.IConduitComponent;
import crazypants.enderio.conduits.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduits.conduit.redstone.RedstoneConduitNetwork;
import crazypants.enderio.conduits.config.ConduitConfig;
import crazypants.enderio.conduits.gui.RedstoneSettings;
import crazypants.enderio.conduits.init.ConduitObject;
import crazypants.enderio.conduits.render.BlockStateWrapperConduitBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InsulatedRedstoneConduit
extends AbstractConduit
implements IRedstoneConduit,
IConduitComponent,
IFilterHolder<IRedstoneSignalFilter> {
    static final Map<String, TextureRegistry.TextureSupplier> ICONS = new HashMap<String, TextureRegistry.TextureSupplier>();
    public static final TextureRegistry.TextureSupplier ICON_IN_OUT_KEY;
    public static final TextureRegistry.TextureSupplier ICON_KEY_IN_OUT_BG;
    public static final TextureRegistry.TextureSupplier ICON_KEY_INPUT;
    public static final TextureRegistry.TextureSupplier ICON_KEY_OUTPUT;
    public static final TextureRegistry.TextureSupplier ICON_KEY_IN_OUT_OUT;
    public static final TextureRegistry.TextureSupplier ICON_KEY_IN_OUT_IN;
    private final EnumMap<EnumFacing, IRedstoneSignalFilter> outputFilters = new EnumMap(EnumFacing.class);
    private final EnumMap<EnumFacing, IRedstoneSignalFilter> inputFilters = new EnumMap(EnumFacing.class);
    private final EnumMap<EnumFacing, ItemStack> outputFilterUpgrades = new EnumMap(EnumFacing.class);
    private final EnumMap<EnumFacing, ItemStack> inputFilterUpgrades = new EnumMap(EnumFacing.class);
    private Map<EnumFacing, ConnectionMode> forcedConnections = new EnumMap<EnumFacing, ConnectionMode>(EnumFacing.class);
    private Map<EnumFacing, DyeColor> inputSignalColors = new EnumMap<EnumFacing, DyeColor>(EnumFacing.class);
    private Map<EnumFacing, DyeColor> outputSignalColors = new EnumMap<EnumFacing, DyeColor>(EnumFacing.class);
    private Map<EnumFacing, Boolean> signalStrengths = new EnumMap<EnumFacing, Boolean>(EnumFacing.class);
    private RedstoneConduitNetwork network;
    private int activeUpdateCooldown = 0;
    private boolean activeDirty = false;
    private boolean connectionsDirty = false;
    private int signalIdBase = 0;

    public InsulatedRedstoneConduit() {
        NNList.NNIterator itr = NNList.FACING.fastIterator();
        while (itr.hasNext()) {
            EnumFacing dir = (EnumFacing)itr.next();
            this.outputFilters.put(dir, new DefaultOutputSignalFilter());
            this.inputFilters.put(dir, new DefaultInputSignalFilter());
            this.outputFilterUpgrades.put(dir, ItemStack.field_190927_a);
            this.inputFilterUpgrades.put(dir, ItemStack.field_190927_a);
        }
    }

    @Override
    @Nullable
    public RedstoneConduitNetwork getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(@Nonnull IConduitNetwork<?, ?> network) {
        this.network = (RedstoneConduitNetwork)network;
        return true;
    }

    @Override
    public void clearNetwork() {
        this.network = null;
    }

    @Override
    @Nonnull
    public Class<? extends IConduit> getBaseConduitType() {
        return IRedstoneConduit.class;
    }

    @Override
    public void updateNetwork() {
        World world = this.getBundle().getEntity().func_145831_w();
        if (world != null) {
            this.updateNetwork(world);
        }
    }

    @Override
    public void updateEntity(@Nonnull World world) {
        super.updateEntity(world);
        if (!world.field_72995_K) {
            if (this.activeUpdateCooldown > 0) {
                --this.activeUpdateCooldown;
                Prof.start((IBlockAccess)world, "updateActiveState");
                this.updateActiveState();
                Prof.stop((IBlockAccess)world);
            }
            if (this.connectionsDirty) {
                if (this.hasExternalConnections()) {
                    this.network.updateInputsFromConduit(this, false);
                }
                this.connectionsDirty = false;
            }
        }
    }

    @Override
    public void setActive(boolean active) {
        if (active != this.active) {
            this.activeDirty = true;
        }
        this.active = active;
        this.updateActiveState();
    }

    private void updateActiveState() {
        if (ConduitConfig.showState.get().booleanValue() && this.activeDirty && this.activeUpdateCooldown == 0) {
            this.setClientStateDirty();
            this.activeDirty = false;
            this.activeUpdateCooldown = 4;
        }
    }

    @Override
    public void onChunkUnload() {
        RedstoneConduitNetwork networkR = this.getNetwork();
        if (networkR != null) {
            BundledSignal oldSignals = networkR.getBundledSignal();
            ArrayList conduits = Lists.newArrayList(networkR.getConduits());
            super.onChunkUnload();
            networkR.afterChunkUnload(conduits, oldSignals);
        }
    }

    @Override
    public boolean onBlockActivated(@Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull RaytraceResult res, @Nonnull List<RaytraceResult> all) {
        World world = this.getBundle().getEntity().func_145831_w();
        if (!world.field_72995_K) {
            DyeColor col = DyeColor.getColorFromDye((ItemStack)player.func_184586_b(hand));
            if (col != null && res.component != null) {
                this.setInputSignalColor(res.component.dir, col);
                return true;
            }
            if (ToolUtil.isToolEquipped(player, hand) && res != null && res.component != null) {
                EnumFacing connDir = res.component.dir;
                EnumFacing faceHit = res.movingObjectPosition.field_178784_b;
                if (connDir == null || connDir == faceHit) {
                    BlockPos pos = this.getBundle().getLocation().func_177972_a(faceHit);
                    Block id = world.func_180495_p(pos).func_177230_c();
                    if (id == ConduitRegistry.getConduitModObjectNN().getBlock()) {
                        IRedstoneConduit neighbour = ConduitUtil.getConduit(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), IRedstoneConduit.class);
                        if (neighbour != null && neighbour.getConnectionMode(faceHit.func_176734_d()) == ConnectionMode.DISABLED) {
                            neighbour.setConnectionMode(faceHit.func_176734_d(), ConnectionMode.NOT_SET);
                        }
                        this.setConnectionMode(faceHit, ConnectionMode.NOT_SET);
                        return ConduitUtil.connectConduits(this, faceHit);
                    }
                    this.forceConnectionMode(faceHit, ConnectionMode.INPUT);
                    return true;
                }
                if (this.externalConnections.contains(connDir)) {
                    if (this.network != null) {
                        this.network.destroyNetwork();
                    }
                    this.externalConnectionRemoved(connDir);
                    this.forceConnectionMode(connDir, ConnectionMode.DISABLED);
                    return true;
                }
                if (this.containsConduitConnection(connDir)) {
                    BlockPos pos = this.getBundle().getLocation().func_177972_a(connDir);
                    IRedstoneConduit neighbour = ConduitUtil.getConduit(this.getBundle().getEntity().func_145831_w(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), IRedstoneConduit.class);
                    if (neighbour != null) {
                        if (this.network != null) {
                            this.network.destroyNetwork();
                        }
                        if (neighbour.getNetwork() != null) {
                            neighbour.getNetwork().destroyNetwork();
                        }
                        neighbour.conduitConnectionRemoved(connDir.func_176734_d());
                        this.conduitConnectionRemoved(connDir);
                        neighbour.connectionsChanged();
                        this.connectionsChanged();
                        this.updateNetwork();
                        neighbour.updateNetwork();
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void forceConnectionMode(@Nonnull EnumFacing dir, @Nonnull ConnectionMode mode) {
        this.setConnectionMode(dir, mode);
        this.forcedConnections.put(dir, mode);
        this.onAddedToBundle();
        if (this.network != null) {
            this.network.updateInputsFromConduit(this, false);
        }
    }

    @Override
    @Nonnull
    public ItemStack createItem() {
        return new ItemStack(ConduitObject.item_redstone_conduit.getItemNN(), 1, 0);
    }

    @Override
    public void onInputsChanged(@Nonnull EnumFacing side, int[] inputValues) {
    }

    @Override
    public void onInputChanged(@Nonnull EnumFacing side, int inputValue) {
    }

    @Override
    @Nonnull
    public DyeColor getInputSignalColor(@Nonnull EnumFacing dir) {
        DyeColor res = this.inputSignalColors.get(dir);
        if (res == null) {
            return DyeColor.RED;
        }
        return res;
    }

    @Override
    public void setInputSignalColor(@Nonnull EnumFacing dir, @Nonnull DyeColor col) {
        this.inputSignalColors.put(dir, col);
        if (this.network != null) {
            this.network.updateInputsFromConduit(this, false);
        }
        this.setClientStateDirty();
        this.collidablesDirty = true;
    }

    @Override
    @Nonnull
    public DyeColor getOutputSignalColor(@Nonnull EnumFacing dir) {
        DyeColor res = this.outputSignalColors.get(dir);
        if (res == null) {
            return DyeColor.GREEN;
        }
        return res;
    }

    @Override
    public void setOutputSignalColor(@Nonnull EnumFacing dir, @Nonnull DyeColor col) {
        this.outputSignalColors.put(dir, col);
        if (this.network != null) {
            this.network.updateInputsFromConduit(this, false);
        }
        this.setClientStateDirty();
        this.collidablesDirty = true;
    }

    @Override
    public boolean isOutputStrong(@Nonnull EnumFacing dir) {
        if (this.signalStrengths.containsKey(dir)) {
            return this.signalStrengths.get(dir);
        }
        return false;
    }

    @Override
    public void setOutputStrength(@Nonnull EnumFacing dir, boolean isStrong) {
        if (this.isOutputStrong(dir) != isStrong) {
            if (isStrong) {
                this.signalStrengths.put(dir, isStrong);
            } else {
                this.signalStrengths.remove(dir);
            }
            if (this.network != null) {
                this.network.notifyNeigborsOfSignalUpdate();
            }
        }
    }

    @Override
    public boolean canConnectToExternal(@Nonnull EnumFacing direction, boolean ignoreConnectionState) {
        BlockPos pos;
        if (ignoreConnectionState) {
            return true;
        }
        ConnectionMode forcedConnection = this.forcedConnections.get(direction);
        if (forcedConnection == ConnectionMode.DISABLED) {
            return false;
        }
        if (forcedConnection == ConnectionMode.IN_OUT || forcedConnection == ConnectionMode.OUTPUT || forcedConnection == ConnectionMode.INPUT) {
            return true;
        }
        World world = this.getBundle().getBundleworld();
        IBlockState bs = world.func_180495_p(pos = this.getBundle().getLocation().func_177972_a(direction));
        if (bs.func_177230_c() == ConduitRegistry.getConduitModObjectNN().getBlock()) {
            return false;
        }
        return ConnectivityTool.shouldAutoConnectRedstone(world, bs, pos, direction.func_176734_d());
    }

    @Override
    public int isProvidingWeakPower(@Nonnull EnumFacing toDirection) {
        if (!this.getConnectionMode(toDirection = toDirection.func_176734_d()).acceptsInput()) {
            return 0;
        }
        if (this.network == null || !this.network.isNetworkEnabled()) {
            return 0;
        }
        int result = 0;
        CombinedSignal signal = this.getNetworkOutput(toDirection);
        result = Math.max(result, signal.getStrength());
        return result;
    }

    @Nonnull
    private BlockPos getPos() {
        return this.getBundle().getLocation();
    }

    @Override
    public int isProvidingStrongPower(@Nonnull EnumFacing toDirection) {
        if (this.isOutputStrong(toDirection.func_176734_d())) {
            return this.isProvidingWeakPower(toDirection);
        }
        return 0;
    }

    @Override
    @Nonnull
    public CombinedSignal getNetworkOutput(@Nonnull EnumFacing side) {
        ConnectionMode mode = this.getConnectionMode(side);
        if (this.network == null || !mode.acceptsInput()) {
            return CombinedSignal.NONE;
        }
        DyeColor col = this.getOutputSignalColor(side);
        BundledSignal bundledSignal = this.network.getBundledSignal();
        return bundledSignal.getFilteredSignal(col, (IOutputSignalFilter)this.getSignalFilter(side, true));
    }

    @Override
    @Nonnull
    public Signal getNetworkInput(@Nonnull EnumFacing side) {
        if (this.network != null) {
            this.network.setNetworkEnabled(false);
        }
        CombinedSignal result = CombinedSignal.NONE;
        if (this.acceptSignalsForDir(side)) {
            int input = this.getExternalPowerLevel(side);
            result = new CombinedSignal(input);
            IInputSignalFilter filter = (IInputSignalFilter)this.getSignalFilter(side, false);
            result = filter.apply(result, this.getBundle().getBundleworld(), this.getBundle().getLocation().func_177972_a(side));
        }
        if (this.network != null) {
            this.network.setNetworkEnabled(true);
        }
        return new Signal(result, this.signalIdBase + side.ordinal());
    }

    protected int getExternalPowerLevel(@Nonnull EnumFacing dir) {
        World world = this.getBundle().getBundleworld();
        BlockPos loc = this.getBundle().getLocation().func_177972_a(dir);
        int res = 0;
        if (world.func_175667_e(loc)) {
            int strong = world.func_175627_a(loc, dir);
            if (strong > 0) {
                return strong;
            }
            res = world.func_175651_c(loc, dir);
            IBlockState bs = world.func_180495_p(loc);
            Block block = bs.func_177230_c();
            if (res <= 15 && block == Blocks.field_150488_af) {
                int wireIn = (Integer)bs.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
                res = Math.max(res, wireIn);
            }
        }
        return res;
    }

    @Override
    @Nonnull
    public ConnectionMode getConnectionMode(@Nonnull EnumFacing dir) {
        ConnectionMode res = this.forcedConnections.get(dir);
        if (res == null) {
            return this.getDefaultConnectionMode();
        }
        return res;
    }

    @Override
    @Nonnull
    public ConnectionMode getDefaultConnectionMode() {
        return ConnectionMode.OUTPUT;
    }

    @Override
    @Nonnull
    public NNList<ItemStack> getDrops() {
        NNList<ItemStack> res = super.getDrops();
        for (ItemStack stack : this.inputFilterUpgrades.values()) {
            res.add((Object)stack);
        }
        for (ItemStack stack : this.outputFilterUpgrades.values()) {
            res.add((Object)stack);
        }
        return res;
    }

    @Override
    public boolean onNeighborBlockChange(@Nonnull Block blockId) {
        World world = this.getBundle().getBundleworld();
        if (world.field_72995_K) {
            return false;
        }
        boolean res = super.onNeighborBlockChange(blockId);
        if (this.network == null || this.network.updatingNetwork) {
            return false;
        }
        if (blockId != ConduitRegistry.getConduitModObjectNN().getBlock()) {
            this.connectionsDirty = true;
        }
        return res;
    }

    private boolean acceptSignalsForDir(@Nonnull EnumFacing dir) {
        if (!this.getConnectionMode(dir).acceptsOutput()) {
            return false;
        }
        BlockPos loc = this.getBundle().getLocation().func_177972_a(dir);
        return ConduitUtil.getConduit(this.getBundle().getEntity().func_145831_w(), loc.func_177958_n(), loc.func_177956_o(), loc.func_177952_p(), IRedstoneConduit.class) == null;
    }

    @Override
    @Nonnull
    public Collection<CollidableComponent> createCollidables(@Nonnull CollidableCache.CacheKey key) {
        Collection<CollidableComponent> baseCollidables = super.createCollidables(key);
        if (key.dir == null) {
            return baseCollidables;
        }
        ArrayList<CollidableComponent> result = new ArrayList<CollidableComponent>();
        result.addAll(baseCollidables);
        return result;
    }

    @Override
    public int getRedstoneSignalForColor(@Nonnull DyeColor col) {
        if (this.network != null) {
            return this.network.getSignalStrengthForColor(col);
        }
        return 0;
    }

    @Override
    @Nonnull
    public TextureAtlasSprite getTextureForState(@Nonnull CollidableComponent component) {
        if (component.dir == null) {
            return ConduitConfig.showState.get() != false && this.isActive() ? ICONS.get("blocks/redstone_insulated_conduit_core_on").get(TextureAtlasSprite.class) : ICONS.get("blocks/redstone_insulated_conduit_core_off").get(TextureAtlasSprite.class);
        }
        return ICONS.get("blocks/redstone_insulated_conduit").get(TextureAtlasSprite.class);
    }

    @Override
    @Nonnull
    public TextureAtlasSprite getTransmitionTextureForState(@Nonnull CollidableComponent component) {
        return ConduitConfig.showState.get() != false && this.isActive() ? ICONS.get("blocks/redstone_conduit_transmission").get(TextureAtlasSprite.class) : ICONS.get("blocks/redstone_conduit").get(TextureAtlasSprite.class);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public Vector4f getTransmitionTextureColorForState(@Nonnull CollidableComponent component) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public TextureAtlasSprite getTextureForInputMode() {
        return ICON_KEY_INPUT.get(TextureAtlasSprite.class);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public TextureAtlasSprite getTextureForInOutMode(boolean input) {
        return input ? ICON_KEY_IN_OUT_IN.get(TextureAtlasSprite.class) : ICON_KEY_IN_OUT_OUT.get(TextureAtlasSprite.class);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public TextureAtlasSprite getTextureForOutputMode() {
        return ICON_KEY_OUTPUT.get(TextureAtlasSprite.class);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForInOutMode() {
        return ICON_IN_OUT_KEY.get(TextureAtlasSprite.class);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public TextureAtlasSprite getTextureForInOutBackground() {
        return ICON_KEY_IN_OUT_BG.get(TextureAtlasSprite.class);
    }

    @Override
    protected void readTypeSettings(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound dataRoot) {
        this.forceConnectionMode(dir, ConnectionMode.values()[dataRoot.func_74765_d("connectionMode")]);
        this.setInputSignalColor(dir, DyeColor.values()[dataRoot.func_74765_d("inputSignalColor")]);
        this.setOutputSignalColor(dir, DyeColor.values()[dataRoot.func_74765_d("outputSignalColor")]);
        this.setOutputStrength(dir, dataRoot.func_74767_n("signalStrong"));
    }

    @Override
    protected void writeTypeSettingsToNbt(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound dataRoot) {
        dataRoot.func_74777_a("connectionMode", (short)this.forcedConnections.get(dir).ordinal());
        dataRoot.func_74777_a("inputSignalColor", (short)this.getInputSignalColor(dir).ordinal());
        dataRoot.func_74777_a("outputSignalColor", (short)this.getOutputSignalColor(dir).ordinal());
        dataRoot.func_74757_a("signalStrong", this.isOutputStrong(dir));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        ItemStack up;
        IRedstoneSignalFilter f;
        DyeColor col;
        byte[] modes;
        super.writeToNBT(nbtRoot);
        if (this.forcedConnections.size() >= 0) {
            modes = new byte[6];
            boolean bl = false;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                void var3_4;
                ConnectionMode mode = this.forcedConnections.get(dir);
                modes[var3_4] = mode != null ? (int)mode.ordinal() : -1;
                ++var3_4;
            }
            nbtRoot.func_74773_a("forcedConnections", modes);
        }
        if (this.inputSignalColors.size() >= 0) {
            modes = new byte[6];
            boolean bl = false;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                void var3_6;
                col = this.inputSignalColors.get(dir);
                modes[var3_6] = col != null ? (int)col.ordinal() : -1;
                ++var3_6;
            }
            nbtRoot.func_74773_a("signalColors", modes);
        }
        if (this.outputSignalColors.size() >= 0) {
            modes = new byte[6];
            boolean bl = false;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                void var3_8;
                col = this.outputSignalColors.get(dir);
                modes[var3_8] = col != null ? (int)col.ordinal() : -1;
                ++var3_8;
            }
            nbtRoot.func_74773_a("outputSignalColors", modes);
        }
        if (this.signalStrengths.size() >= 0) {
            modes = new byte[6];
            boolean bl = false;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                void var3_10;
                boolean isStrong = this.isOutputStrong(dir);
                modes[var3_10] = isStrong ? (byte)1 : 0;
                ++var3_10;
            }
            nbtRoot.func_74773_a("signalStrengths", modes);
        }
        for (Map.Entry<EnumFacing, IRedstoneSignalFilter> entry : this.inputFilters.entrySet()) {
            if (entry.getValue() == null) continue;
            f = entry.getValue();
            NBTTagCompound itemRoot = new NBTTagCompound();
            FilterRegistry.writeFilterToNbt(f, itemRoot);
            nbtRoot.func_74782_a("inSignalFilts." + entry.getKey().name(), (NBTBase)itemRoot);
        }
        for (Map.Entry<EnumFacing, IRedstoneSignalFilter> entry : this.outputFilters.entrySet()) {
            if (entry.getValue() == null) continue;
            f = entry.getValue();
            NBTTagCompound itemRoot = new NBTTagCompound();
            FilterRegistry.writeFilterToNbt(f, itemRoot);
            nbtRoot.func_74782_a("outSignalFilts." + entry.getKey().name(), (NBTBase)itemRoot);
        }
        for (Map.Entry<EnumFacing, IRedstoneSignalFilter> entry : this.inputFilterUpgrades.entrySet()) {
            if (entry.getValue() == null) continue;
            up = (ItemStack)entry.getValue();
            IRedstoneSignalFilter filter = this.getSignalFilter(entry.getKey(), true);
            FilterRegistry.writeFilterToStack(filter, up);
            NBTTagCompound itemRoot = new NBTTagCompound();
            up.func_77955_b(itemRoot);
            nbtRoot.func_74782_a("inputSignalFilterUpgrades." + entry.getKey().name(), (NBTBase)itemRoot);
        }
        for (Map.Entry<EnumFacing, IRedstoneSignalFilter> entry : this.outputFilterUpgrades.entrySet()) {
            if (entry.getValue() == null) continue;
            up = (ItemStack)entry.getValue();
            IRedstoneSignalFilter filter = this.getSignalFilter(entry.getKey(), false);
            FilterRegistry.writeFilterToStack(filter, up);
            NBTTagCompound itemRoot = new NBTTagCompound();
            up.func_77955_b(itemRoot);
            nbtRoot.func_74782_a("outputSignalFilterUpgrades." + entry.getKey().name(), (NBTBase)itemRoot);
        }
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        this.forcedConnections.clear();
        byte[] modes = nbtRoot.func_74770_j("forcedConnections");
        if (modes != null && modes.length == 6) {
            int i = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (modes[i] >= 0) {
                    this.forcedConnections.put(dir, ConnectionMode.values()[modes[i]]);
                }
                ++i;
            }
        }
        this.inputSignalColors.clear();
        byte[] cols = nbtRoot.func_74770_j("signalColors");
        if (cols != null && cols.length == 6) {
            int i = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (cols[i] >= 0) {
                    this.inputSignalColors.put(dir, DyeColor.values()[cols[i]]);
                }
                ++i;
            }
        }
        this.outputSignalColors.clear();
        byte[] outCols = nbtRoot.func_74770_j("outputSignalColors");
        if (outCols != null && outCols.length == 6) {
            int i = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (outCols[i] >= 0) {
                    this.outputSignalColors.put(dir, DyeColor.values()[outCols[i]]);
                }
                ++i;
            }
        }
        this.signalStrengths.clear();
        byte[] strengths = nbtRoot.func_74770_j("signalStrengths");
        if (strengths != null && strengths.length == 6) {
            int i = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (strengths[i] > 0) {
                    this.signalStrengths.put(dir, true);
                }
                ++i;
            }
        }
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            ItemStack ups;
            NBTTagCompound upTag;
            IRedstoneSignalFilter filter;
            NBTTagCompound filterTag;
            String key = "inSignalFilts." + dir.name();
            if (nbtRoot.func_74764_b(key)) {
                filterTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                filter = (IRedstoneSignalFilter)FilterRegistry.loadFilterFromNbt(filterTag);
                this.inputFilters.put(dir, filter);
            }
            if (nbtRoot.func_74764_b(key = "inputSignalFilterUpgrades." + dir.name())) {
                upTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                ups = new ItemStack(upTag);
                this.inputFilterUpgrades.put(dir, ups);
            }
            if (nbtRoot.func_74764_b(key = "outputSignalFilterUpgrades." + dir.name())) {
                upTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                ups = new ItemStack(upTag);
                this.outputFilterUpgrades.put(dir, ups);
            }
            if (!nbtRoot.func_74764_b(key = "outSignalFilts." + dir.name())) continue;
            filterTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
            filter = (IRedstoneSignalFilter)FilterRegistry.loadFilterFromNbt(filterTag);
            this.outputFilters.put(dir, filter);
        }
    }

    @Override
    public String toString() {
        return "RedstoneConduit [network=" + this.network + " connections=" + this.conduitConnections + " active=" + this.active + "]";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void hashCodeForModelCaching(BlockStateWrapperConduitBundle.ConduitCacheKey hashCodes) {
        super.hashCodeForModelCaching(hashCodes);
        hashCodes.addEnum(this.inputSignalColors);
        hashCodes.addEnum(this.outputSignalColors);
        if (ConduitConfig.showState.get().booleanValue() && this.isActive()) {
            hashCodes.add(1);
        }
    }

    @Nonnull
    public RedstoneConduitNetwork createNetworkForType() {
        return new RedstoneConduitNetwork();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ITabPanel createGuiPanel(@Nonnull IGuiExternalConnection gui, @Nonnull IClientConduit con) {
        return new RedstoneSettings(gui, con);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean updateGuiPanel(@Nonnull ITabPanel panel) {
        if (panel instanceof RedstoneSettings) {
            return ((RedstoneSettings)panel).updateConduit(this);
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getGuiPanelTabOrder() {
        return 2;
    }

    @Override
    public boolean hasInternalCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY) {
            return true;
        }
        return super.hasInternalCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getInternalCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY) {
            return (T)CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY.cast((Object)this);
        }
        return super.getInternalCapability(capability, facing);
    }

    @Override
    @Nonnull
    public String getConduitProbeInfo(@Nonnull EntityPlayer player) {
        return "";
    }

    @Override
    public void setSignalIdBase(int id) {
        this.signalIdBase = id;
    }

    @Override
    @Nonnull
    public IRedstoneSignalFilter getSignalFilter(@Nonnull EnumFacing dir, boolean isOutput) {
        if (!isOutput) {
            return this.inputFilters.get(dir);
        }
        return this.outputFilters.get(dir);
    }

    public void setSignalFilter(@Nonnull EnumFacing dir, boolean isInput, @Nonnull IRedstoneSignalFilter filter) {
        if (!isInput) {
            this.inputFilters.put(dir, filter != null ? filter : new DefaultInputSignalFilter());
        } else {
            this.outputFilters.put(dir, filter != null ? filter : new DefaultOutputSignalFilter());
        }
        this.setClientStateDirty();
        this.connectionsDirty = true;
    }

    @Override
    public IRedstoneSignalFilter getFilter(int filterIndex, int param1) {
        return this.getSignalFilter(EnumFacing.func_82600_a((int)param1), filterIndex == this.getInputFilterIndex() ? true : filterIndex != this.getOutputFilterIndex());
    }

    @Override
    public void setFilter(int filterIndex, int param1, @Nonnull IRedstoneSignalFilter filter) {
        this.setSignalFilter(EnumFacing.func_82600_a((int)param1), filterIndex == this.getInputFilterIndex() ? true : filterIndex != this.getOutputFilterIndex(), filter);
    }

    @Override
    @Nonnull
    public ItemStack getFilterStack(int filterIndex, int param1) {
        if (filterIndex == this.getInputFilterIndex()) {
            return this.inputFilterUpgrades.get(EnumFacing.func_82600_a((int)param1));
        }
        if (filterIndex == this.getOutputFilterIndex()) {
            return this.outputFilterUpgrades.get(EnumFacing.func_82600_a((int)param1));
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void setFilterStack(int filterIndex, int param1, @Nonnull ItemStack stack) {
        if (filterIndex == this.getInputFilterIndex()) {
            this.inputFilterUpgrades.put(EnumFacing.func_82600_a((int)param1), stack);
        } else if (filterIndex == this.getOutputFilterIndex()) {
            this.outputFilterUpgrades.put(EnumFacing.func_82600_a((int)param1), stack);
        }
        this.setFilter(filterIndex, param1, (IRedstoneSignalFilter)FilterRegistry.getFilterForUpgrade(stack));
    }

    @Override
    public int getInputFilterIndex() {
        return 5;
    }

    @Override
    public int getOutputFilterIndex() {
        return 6;
    }

    static {
        ICONS.put("blocks/redstone_insulated_conduit_core_off", TextureRegistry.registerTexture("blocks/redstone_insulated_conduit_core_off"));
        ICONS.put("blocks/redstone_insulated_conduit_core_on", TextureRegistry.registerTexture("blocks/redstone_insulated_conduit_core_on"));
        ICONS.put("blocks/redstone_insulated_conduit", TextureRegistry.registerTexture("blocks/redstone_insulated_conduit"));
        ICONS.put("blocks/redstone_conduit", TextureRegistry.registerTexture("blocks/redstone_conduit"));
        ICONS.put("blocks/redstone_conduit_transmission", TextureRegistry.registerTexture("blocks/redstone_conduit_transmission"));
        ICON_IN_OUT_KEY = TextureRegistry.registerTexture("blocks/item_conduit_in_out");
        ICON_KEY_IN_OUT_BG = TextureRegistry.registerTexture("blocks/item_conduit_io_connector");
        ICON_KEY_INPUT = TextureRegistry.registerTexture("blocks/item_conduit_input");
        ICON_KEY_OUTPUT = TextureRegistry.registerTexture("blocks/item_conduit_output");
        ICON_KEY_IN_OUT_OUT = TextureRegistry.registerTexture("blocks/item_conduit_in_out_out");
        ICON_KEY_IN_OUT_IN = TextureRegistry.registerTexture("blocks/item_conduit_in_out_in");
    }
}

