/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.gui;

import com.enderio.core.api.client.gui.ITabPanel;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.conduit.IExternalConnectionContainer;
import crazypants.enderio.base.conduit.IGuiExternalConnection;
import crazypants.enderio.base.gui.GuiContainerBaseEIO;
import crazypants.enderio.conduits.conduit.TileConduitBundle;
import crazypants.enderio.conduits.gui.ExternalConnectionContainer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class GuiExternalConnection
extends GuiContainerBaseEIO
implements IGuiExternalConnection {
    private static int nextButtonId = 1;
    final InventoryPlayer playerInv;
    final IConduitBundle bundle;
    @Nonnull
    private final EnumFacing dir;
    private final List<ITabPanel> tabs = new ArrayList<ITabPanel>();
    private int activeTab = 0;
    private final IExternalConnectionContainer container = (ExternalConnectionContainer)this.field_147002_h;

    public static int nextButtonId() {
        return nextButtonId++;
    }

    public GuiExternalConnection(@Nonnull InventoryPlayer playerInv, @Nonnull IConduitBundle bundle, @Nonnull EnumFacing dir) {
        super((Container)new ExternalConnectionContainer(playerInv, dir, (TileConduitBundle)bundle.getEntity()), "item_filter");
        this.playerInv = playerInv;
        this.bundle = bundle;
        this.dir = dir;
        this.field_147000_g = 194;
        this.field_146999_f = 206;
        ArrayList<IClientConduit> cons = new ArrayList<IClientConduit>(bundle.getClientConduits());
        Collections.sort(cons, new Comparator<IClientConduit>(){

            @Override
            public int compare(@Nullable IClientConduit o1, @Nullable IClientConduit o2) {
                return Integer.compare(o1.getGuiPanelTabOrder(), o2.getGuiPanelTabOrder());
            }
        });
        for (IClientConduit con : cons) {
            if (!con.containsExternalConnection(dir) && !con.canConnectToExternal(dir, true)) continue;
            this.tabs.add(con.createGuiPanel(this, con));
        }
        if (this.tabs.isEmpty()) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (i == this.activeTab) continue;
            this.tabs.get(i).deactivate();
        }
        this.tabs.get(this.activeTab).onGuiInit(this.field_147003_i + 10, this.field_147009_r, this.field_146999_f - 20, this.field_147000_g - 20);
    }

    @Nullable
    private ITabPanel getActiveTab() {
        ITabPanel tab;
        if (this.activeTab < this.tabs.size() && this.activeTab >= 0 && (tab = this.tabs.get(this.activeTab)) != null) {
            for (IClientConduit con : this.bundle.getClientConduits()) {
                if (!con.updateGuiPanel(tab)) continue;
                return tab;
            }
        }
        return null;
    }

    public boolean func_73868_f() {
        return false;
    }

    @Override
    protected void func_73864_a(int x, int y, int par3) throws IOException {
        super.func_73864_a(x, y, par3);
        x -= this.field_147003_i;
        y -= this.field_147009_r;
        if (this.activeTab < this.tabs.size()) {
            this.tabs.get(this.activeTab).mouseClicked(x, y, par3);
        }
    }

    @Override
    protected boolean doSwitchTab(int tab) {
        if (tab != this.activeTab) {
            this.activeTab = tab;
            this.func_73866_w_();
            return true;
        }
        return super.doSwitchTab(tab);
    }

    @Override
    @Nonnull
    protected ResourceLocation getGuiTexture() {
        return this.tabs.get(this.activeTab).getTexture();
    }

    public void setSize(int x, int y) {
        this.field_146999_f = x;
        this.field_147000_g = y;
    }

    protected void func_146284_a(@Nonnull GuiButton guiButton) throws IOException {
        super.func_146284_a(guiButton);
        if (this.activeTab < this.tabs.size()) {
            this.tabs.get(this.activeTab).actionPerformed(guiButton);
        }
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        ITabPanel tab = this.getActiveTab();
        if (tab == null) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(tab.getTexture());
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        this.startTabs();
        for (int i = 0; i < this.tabs.size(); ++i) {
            this.renderStdTab(sx, sy, i, this.tabs.get(i).getIcon(), i == this.activeTab);
        }
        if (this.activeTab < this.tabs.size()) {
            this.tabs.get(this.activeTab).render(par1, par2, par3);
        }
        super.func_146976_a(par1, par2, par3);
    }

    @Override
    @Nonnull
    public EnumFacing getDir() {
        return this.dir;
    }

    @Override
    public IExternalConnectionContainer getContainer() {
        return this.container;
    }

    public void drawFakeItemStack(int x, int y, @Nonnull ItemStack stack) {
        super.drawFakeItemStack(x, y, stack);
        this.field_146296_j.func_180453_a(this.field_146289_q, stack, x, y, "");
    }
}

