/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.me.conduit;

import appeng.api.AEApi;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.util.AEPartLocation;
import com.enderio.core.api.client.gui.ITabPanel;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.conduit.IConduitNetwork;
import crazypants.enderio.base.conduit.IGuiExternalConnection;
import crazypants.enderio.base.conduit.RaytraceResult;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.base.tool.ToolUtil;
import crazypants.enderio.conduits.conduit.AbstractConduit;
import crazypants.enderio.conduits.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduits.conduit.TileConduitBundle;
import crazypants.enderio.conduits.me.conduit.IMEConduit;
import crazypants.enderio.conduits.me.conduit.MEConduitGrid;
import crazypants.enderio.conduits.me.conduit.MEConduitNetwork;
import crazypants.enderio.conduits.me.gui.MESettings;
import crazypants.enderio.conduits.me.init.ConduitAppliedEnergisticsObject;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MEConduit
extends AbstractConduit
implements IMEConduit {
    protected MEConduitNetwork network;
    protected MEConduitGrid grid;
    public static TextureRegistry.TextureSupplier coreTextureN = TextureRegistry.registerTexture("blocks/me_conduit_core");
    public static TextureRegistry.TextureSupplier coreTextureD = TextureRegistry.registerTexture("blocks/me_conduit_core_dense");
    public static TextureRegistry.TextureSupplier longTextureN = TextureRegistry.registerTexture("blocks/me_conduit");
    public static TextureRegistry.TextureSupplier longTextureD = TextureRegistry.registerTexture("blocks/me_conduit_dense");
    private boolean isDense;
    private int playerID = -1;
    private IGridNode nodeR;

    public MEConduit() {
        this(0);
    }

    public MEConduit(int itemDamage) {
        this.isDense = itemDamage == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public static void initIcons() {
    }

    public static int getDamageForState(boolean isDense) {
        return isDense ? 1 : 0;
    }

    @Override
    @Nonnull
    public Class<? extends IConduit> getBaseConduitType() {
        return IMEConduit.class;
    }

    @Override
    @Nonnull
    public ItemStack createItem() {
        return new ItemStack(ConduitAppliedEnergisticsObject.item_me_conduit.getItemNN(), 1, MEConduit.getDamageForState(this.isDense));
    }

    public AbstractConduitNetwork<?, ?> getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(@Nonnull IConduitNetwork<?, ?> network) {
        this.network = (MEConduitNetwork)network;
        return true;
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        nbtRoot.func_74757_a("isDense", this.isDense);
        nbtRoot.func_74768_a("playerID", this.playerID);
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        this.isDense = nbtRoot.func_74767_n("isDense");
        this.playerID = nbtRoot.func_74764_b("playerID") ? nbtRoot.func_74762_e("playerID") : -1;
    }

    public void setPlayerID(int playerID) {
        this.playerID = playerID;
    }

    @Override
    public int getChannelsInUse() {
        int channelsInUse = 0;
        IGridNode node = this.getNode();
        if (node != null) {
            for (IGridConnection gc : node.getConnections()) {
                channelsInUse = Math.max(channelsInUse, gc.getUsedChannels());
            }
        }
        return channelsInUse;
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public boolean canConnectToExternal(@Nonnull EnumFacing dir, boolean ignoreDisabled) {
        BlockPos pos;
        World world = this.getBundle().getBundleworld();
        TileEntity te = world.func_175625_s(pos = this.getBundle().getLocation().func_177972_a(dir));
        if (te instanceof TileConduitBundle) {
            return false;
        }
        if (te instanceof IPartHost) {
            IPart part = ((IPartHost)te).getPart(dir.func_176734_d());
            if (part == null) {
                part = ((IPartHost)te).getPart(AEPartLocation.INTERNAL);
                return part != null;
            }
            if (part.getExternalFacingNode() != null) {
                return true;
            }
            String name = part.getClass().getSimpleName();
            return "PartP2PTunnelME".equals(name) || "PartQuartzFiber".equals(name) || "PartToggleBus".equals(name) || "PartInvertedToggleBus".equals(name);
        }
        if (te instanceof IGridHost) {
            IGridNode node = ((IGridHost)te).getGridNode(AEPartLocation.fromFacing((EnumFacing)dir.func_176734_d()));
            if (node == null) {
                node = ((IGridHost)te).getGridNode(AEPartLocation.INTERNAL);
            }
            if (node != null) {
                return node.getGridBlock().getConnectableSides().contains(dir.func_176734_d());
            }
        }
        return false;
    }

    @Override
    @Nonnull
    public TextureAtlasSprite getTextureForState(@Nonnull CollidableComponent component) {
        if (component.dir == null) {
            return (this.isDense ? coreTextureD : coreTextureN).get(TextureAtlasSprite.class);
        }
        return (this.isDense ? longTextureD : longTextureN).get(TextureAtlasSprite.class);
    }

    @Override
    @Nonnull
    public TextureAtlasSprite getTransmitionTextureForState(@Nonnull CollidableComponent component) {
        return null;
    }

    @Override
    @Nonnull
    public Vector4f getTransmitionTextureColorForState(@Nonnull CollidableComponent component) {
        return null;
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public void updateEntity(@Nonnull World worldObj) {
        IGridNode node;
        if (this.grid == null) {
            this.grid = new MEConduitGrid(this);
        }
        if (this.getNode() == null && !worldObj.field_72995_K && (node = AEApi.instance().grid().createGridNode((IGridBlock)this.grid)) != null) {
            node.setPlayerID(this.playerID);
            this.setGridNode(node);
            if (this.getNode() != null) {
                this.getNode().updateState();
            }
        }
        super.updateEntity(worldObj);
    }

    @Override
    @Nonnull
    public ConnectionMode getNextConnectionMode(@Nonnull EnumFacing dir) {
        ConnectionMode mode = this.getConnectionMode(dir);
        mode = mode == ConnectionMode.IN_OUT ? ConnectionMode.DISABLED : ConnectionMode.IN_OUT;
        return mode;
    }

    @Override
    @Nonnull
    public ConnectionMode getPreviousConnectionMode(@Nonnull EnumFacing dir) {
        return this.getNextConnectionMode(dir);
    }

    @Override
    public boolean canConnectToConduit(@Nonnull EnumFacing direction, @Nonnull IConduit conduit) {
        if (!super.canConnectToConduit(direction, conduit)) {
            return false;
        }
        return conduit instanceof IMEConduit;
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public void connectionsChanged() {
        super.connectionsChanged();
        BlockPos pos = this.getBundle().getLocation();
        this.onNodeChanged(pos);
        IGridNode node = this.getNode();
        if (node != null) {
            node.updateState();
            World world = node.getWorld();
            if (!world.field_72995_K && world instanceof WorldServer) {
                ((WorldServer)world).func_184164_w().func_180244_a(pos);
            }
        }
    }

    @Override
    public boolean onBlockActivated(@Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull RaytraceResult res, @Nonnull List<RaytraceResult> all) {
        if (ToolUtil.isToolEquipped(player, hand) && !this.getBundle().getEntity().func_145831_w().field_72995_K && res.component != null) {
            EnumFacing connDir = res.component.dir;
            EnumFacing faceHit = res.movingObjectPosition.field_178784_b;
            if (connDir == null || connDir == faceHit) {
                if (this.getConnectionMode(faceHit) == ConnectionMode.DISABLED) {
                    this.setConnectionMode(faceHit, ConnectionMode.IN_OUT);
                    return true;
                }
                return ConduitUtil.connectConduits(this, faceHit);
            }
            if (this.externalConnections.contains(connDir)) {
                this.setConnectionMode(connDir, this.getNextConnectionMode(connDir));
                return true;
            }
            if (this.containsConduitConnection(connDir)) {
                ConduitUtil.disconnectConduits(this, connDir);
                return true;
            }
        }
        return false;
    }

    @Optional.Method(modid="appliedenergistics2")
    private void onNodeChanged(@Nonnull BlockPos pos) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            TileEntity te = this.getBundle().getEntity();
            if (!(te instanceof IGridHost) || te instanceof IConduitBundle) continue;
            IGridNode node = ((IGridHost)te).getGridNode(AEPartLocation.INTERNAL);
            if (node == null) {
                node = ((IGridHost)te).getGridNode(AEPartLocation.fromFacing((EnumFacing)dir.func_176734_d()));
            }
            if (node == null) continue;
            node.updateState();
        }
    }

    @Override
    public void onAddedToBundle() {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            IMEConduit cond;
            TileEntity te = this.getBundle().getEntity();
            if (!(te instanceof TileConduitBundle) || (cond = ((TileConduitBundle)te).getConduit(IMEConduit.class)) == null) continue;
            cond.setConnectionMode(dir.func_176734_d(), ConnectionMode.IN_OUT);
            ConduitUtil.connectConduits(cond, dir.func_176734_d());
        }
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public void onAfterRemovedFromBundle() {
        super.onAfterRemovedFromBundle();
        if (this.getNode() != null) {
            this.getNode().destroy();
        }
        this.setGridNode(null);
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.getNode() != null) {
            this.getNode().destroy();
        }
        this.setGridNode(null);
    }

    @Override
    public MEConduitGrid getGrid() {
        return this.grid;
    }

    @Optional.Method(modid="appliedenergistics2")
    private IGridNode getNode() {
        return this.getGridNode();
    }

    @Override
    public EnumSet<EnumFacing> getConnections() {
        EnumSet<EnumFacing> cons = EnumSet.noneOf(EnumFacing.class);
        cons.addAll(this.getConduitConnections());
        for (EnumFacing dir : this.getExternalConnections()) {
            if (dir == null || this.getConnectionMode(dir) == ConnectionMode.DISABLED) continue;
            cons.add(dir);
        }
        return cons;
    }

    @Override
    public boolean isDense() {
        return this.isDense;
    }

    @Nonnull
    public MEConduitNetwork createNetworkForType() {
        return new MEConduitNetwork();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ITabPanel createGuiPanel(@Nonnull IGuiExternalConnection gui, @Nonnull IClientConduit con) {
        return new MESettings(gui, con);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getGuiPanelTabOrder() {
        return 6;
    }

    private void setGridNode(IGridNode node) {
        this.nodeR = node;
    }

    @Override
    public void clearNetwork() {
        this.network = null;
    }

    @Override
    @Nonnull
    public String getConduitProbeInfo(@Nonnull EntityPlayer player) {
        return "";
    }

    @Override
    public boolean updateGuiPanel(@Nonnull ITabPanel panel) {
        if (panel instanceof MESettings) {
            return ((MESettings)panel).updateConduit(this);
        }
        return false;
    }

    @Override
    public IGridNode getGridNode() {
        return this.nodeR;
    }
}

