/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.oc.conduit;

import com.enderio.core.api.client.gui.ITabPanel;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitNetwork;
import crazypants.enderio.base.conduit.IGuiExternalConnection;
import crazypants.enderio.base.conduit.RaytraceResult;
import crazypants.enderio.base.conduit.geom.CollidableCache;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.base.tool.ToolUtil;
import crazypants.enderio.conduits.conduit.AbstractConduit;
import crazypants.enderio.conduits.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduits.conduit.IConduitComponent;
import crazypants.enderio.conduits.oc.conduit.IOCConduit;
import crazypants.enderio.conduits.oc.conduit.OCConduitNetwork;
import crazypants.enderio.conduits.oc.gui.OCSettings;
import crazypants.enderio.conduits.oc.init.ConduitOpenComputersObject;
import crazypants.enderio.conduits.render.BlockStateWrapperConduitBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.SidedEnvironment;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class OCConduit
extends AbstractConduit
implements IOCConduit,
IConduitComponent {
    protected OCConduitNetwork network;
    private final Map<EnumFacing, DyeColor> signalColors = new EnumMap<EnumFacing, DyeColor>(EnumFacing.class);
    private static final TextureRegistry.TextureSupplier coreTextureA = TextureRegistry.registerTexture("blocks/oc_conduit_core_anim");
    private static final TextureRegistry.TextureSupplier longTextureA = TextureRegistry.registerTexture("blocks/oc_conduit_anim");

    public OCConduit() {
    }

    public OCConduit(int meta) {
    }

    @Override
    protected void readTypeSettings(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound dataRoot) {
        this.setSignalColor(dir, (DyeColor)NullHelper.first((Object[])new DyeColor[]{DyeColor.values()[dataRoot.func_74765_d("signalColor")], DyeColor.SILVER}));
    }

    @Override
    protected void writeTypeSettingsToNbt(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound dataRoot) {
        dataRoot.func_74777_a("signalColor", (short)this.getSignalColor(dir).ordinal());
    }

    @Override
    @Nonnull
    public DyeColor getSignalColor(@Nonnull EnumFacing dir) {
        DyeColor res = this.signalColors.get(dir);
        if (res == null) {
            return DyeColor.SILVER;
        }
        return res;
    }

    @Override
    @Nonnull
    public Collection<CollidableComponent> createCollidables(@Nonnull CollidableCache.CacheKey key) {
        Collection<CollidableComponent> baseCollidables = super.createCollidables(key);
        EnumFacing keydir = key.dir;
        if (keydir == null) {
            return baseCollidables;
        }
        BoundingBox bb = ConduitGeometryUtil.instance.createBoundsForConnectionController(keydir, key.offset);
        CollidableComponent cc = new CollidableComponent(IOCConduit.class, bb, keydir, "ColorController");
        ArrayList<CollidableComponent> result = new ArrayList<CollidableComponent>();
        result.addAll(baseCollidables);
        result.add(cc);
        return result;
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        if (this.signalColors.size() >= 0) {
            byte[] modes = new byte[6];
            int i = 0;
            for (EnumFacing dir : EnumFacing.values()) {
                DyeColor col = this.signalColors.get(dir);
                modes[i] = col != null ? (int)col.ordinal() : -1;
                ++i;
            }
            nbtRoot.func_74773_a("signalColors", modes);
        }
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        this.signalColors.clear();
        byte[] cols = nbtRoot.func_74770_j("signalColors");
        if (cols.length == 6) {
            int i = 0;
            for (EnumFacing dir : EnumFacing.values()) {
                if (cols[i] >= 0) {
                    this.signalColors.put(dir, DyeColor.values()[cols[i]]);
                }
                ++i;
            }
        }
    }

    @Override
    public void setSignalColor(@Nonnull EnumFacing dir, @Nonnull DyeColor col) {
        if (this.signalColors.get(dir) == col) {
            return;
        }
        this.disconnectNode(dir);
        this.signalColors.put(dir, col);
        this.addMissingNodeConnections();
        this.setClientStateDirty();
    }

    @Override
    @Nonnull
    public Class<? extends IConduit> getBaseConduitType() {
        return IOCConduit.class;
    }

    @Override
    @Nonnull
    public ItemStack createItem() {
        return new ItemStack(ConduitOpenComputersObject.item_opencomputers_conduit.getItemNN(), 1, 0);
    }

    public AbstractConduitNetwork<?, ?> getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(@Nonnull IConduitNetwork<?, ?> network) {
        this.network = (OCConduitNetwork)network;
        this.addMissingNodeConnections();
        return true;
    }

    @Override
    public boolean shouldMirrorTexture() {
        return false;
    }

    private static String prettyNode(Node o) {
        String at = "";
        Environment host = o.host();
        if (host instanceof TileEntity) {
            BlockPos bc = ((TileEntity)host).func_174877_v();
            at = " at " + bc.func_177958_n() + "/" + bc.func_177956_o() + "/" + bc.func_177952_p();
        }
        return host.getClass().getName().replaceFirst("^.*\\.", "") + at;
    }

    @Nonnull
    private static TextFormatting dye2chat(@Nonnull DyeColor dyeColor) {
        switch (dyeColor) {
            case BLACK: {
                return TextFormatting.BLACK;
            }
            case BLUE: {
                return TextFormatting.DARK_BLUE;
            }
            case BROWN: {
                return TextFormatting.DARK_RED;
            }
            case CYAN: {
                return TextFormatting.DARK_AQUA;
            }
            case GRAY: {
                return TextFormatting.DARK_GRAY;
            }
            case GREEN: {
                return TextFormatting.DARK_GREEN;
            }
            case LIGHT_BLUE: {
                return TextFormatting.BLUE;
            }
            case LIME: {
                return TextFormatting.GREEN;
            }
            case MAGENTA: {
                return TextFormatting.LIGHT_PURPLE;
            }
            case ORANGE: {
                return TextFormatting.GOLD;
            }
            case PINK: {
                return TextFormatting.LIGHT_PURPLE;
            }
            case PURPLE: {
                return TextFormatting.DARK_PURPLE;
            }
            case RED: {
                return TextFormatting.RED;
            }
            case SILVER: {
                return TextFormatting.GRAY;
            }
            case WHITE: {
                return TextFormatting.WHITE;
            }
            case YELLOW: {
                return TextFormatting.YELLOW;
            }
        }
        throw new RuntimeException("Unknown 17th DyeColor " + dyeColor);
    }

    @Override
    public boolean onBlockActivated(@Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull RaytraceResult res, @Nonnull List<RaytraceResult> all) {
        DyeColor col = DyeColor.getColorFromDye((ItemStack)player.func_184586_b(hand));
        if (col != null && res.component != null) {
            this.setSignalColor(res.component.dir, col);
            return true;
        }
        if (ConduitUtil.isProbeEquipped(player, hand)) {
            if (!player.field_70170_p.field_72995_K) {
                BlockPos bc = this.getBundle().getLocation();
                if (this.network != null) {
                    boolean noconnections = true;
                    for (DyeColor color : DyeColor.values()) {
                        if (!this.node(color).neighbors().iterator().hasNext()) continue;
                        noconnections = false;
                        TextComponentString coltxt = new TextComponentString(color.getLocalisedName());
                        coltxt.func_150256_b().func_150238_a(OCConduit.dye2chat(color));
                        TextComponentString chantxt = new TextComponentString("Channel ");
                        chantxt.func_150257_a((ITextComponent)coltxt);
                        chantxt.func_150258_a(" at " + bc.func_177958_n() + "/" + bc.func_177956_o() + "/" + bc.func_177952_p());
                        player.func_145747_a((ITextComponent)chantxt);
                        for (Node other : this.node(color).neighbors()) {
                            player.func_145747_a((ITextComponent)new TextComponentString("  Connected to: " + OCConduit.prettyNode(other)));
                        }
                    }
                    if (noconnections) {
                        player.func_145747_a((ITextComponent)new TextComponentString("No connections at " + bc.func_177958_n() + "/" + bc.func_177956_o() + "/" + bc.func_177952_p()));
                    }
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString("No network at " + bc.func_177958_n() + "/" + bc.func_177956_o() + "/" + bc.func_177952_p()));
                }
            }
            return true;
        }
        if (ToolUtil.isToolEquipped(player, hand) && !this.getBundle().getEntity().func_145831_w().field_72995_K && res.component != null) {
            EnumFacing connDir = res.component.dir;
            EnumFacing faceHit = res.movingObjectPosition.field_178784_b;
            if (connDir != null && this.containsExternalConnection(connDir)) {
                for (RaytraceResult rtr : all) {
                    if (rtr == null || rtr.component == null || !"ColorController".equals(rtr.component.data)) continue;
                    this.setSignalColor(connDir, DyeColor.getNext((DyeColor)this.getSignalColor(connDir)));
                    return true;
                }
            }
            if (connDir == null || connDir == faceHit) {
                if (this.getConnectionMode(faceHit) == ConnectionMode.DISABLED) {
                    this.setConnectionMode(faceHit, ConnectionMode.IN_OUT);
                    return true;
                }
                return ConduitUtil.connectConduits(this, faceHit);
            }
            if (this.externalConnections.contains(connDir)) {
                this.setConnectionMode(connDir, this.getNextConnectionMode(connDir));
                return true;
            }
            if (this.containsConduitConnection(connDir)) {
                ConduitUtil.disconnectConduits(this, connDir);
                this.addMissingNodeConnections();
                return true;
            }
        }
        return false;
    }

    @Override
    public void setConnectionMode(@Nonnull EnumFacing dir, @Nonnull ConnectionMode mode) {
        if (mode == ConnectionMode.DISABLED) {
            this.disconnectNode(dir);
        }
        super.setConnectionMode(dir, mode);
    }

    @Override
    public void connectionsChanged() {
        super.connectionsChanged();
        this.addMissingNodeConnections();
    }

    private void addMissingNodeConnections() {
        if (this.network != null) {
            World world = this.getBundle().getBundleworld();
            EnumSet<EnumFacing> conns = this.getConnections();
            for (DyeColor color : DyeColor.values()) {
                HashSet<Node> should = new HashSet<Node>();
                for (EnumFacing direction : conns) {
                    if (direction == null || this.getSignalColor(direction) != color) continue;
                    TileEntity te = world.func_175625_s(this.getBundle().getLocation().func_177972_a(direction));
                    Node other = null;
                    if (te instanceof SidedEnvironment) {
                        other = ((SidedEnvironment)te).sidedNode(direction.func_176734_d());
                    } else if (te instanceof Environment) {
                        other = ((Environment)te).node();
                    }
                    if (other == null || other == this.node(color)) continue;
                    should.add(other);
                }
                for (Node other : should) {
                    if (this.node(color).isNeighborOf(other)) continue;
                    this.node(color).connect(other);
                }
            }
        }
    }

    private void disconnectNode(@Nonnull EnumFacing direction) {
        World world = this.getBundle().getBundleworld();
        TileEntity te = world.func_175625_s(this.getBundle().getLocation().func_177972_a(direction));
        Node other = null;
        if (te instanceof SidedEnvironment) {
            other = ((SidedEnvironment)te).sidedNode(direction.func_176734_d());
        } else if (te instanceof Environment) {
            other = ((Environment)te).node();
        }
        if (other != null) {
            this.disconnectNode(other, this.getSignalColor(direction));
        }
    }

    private void disconnectNode(Node other, DyeColor color) {
        if (other == this.node(color)) {
            return;
        }
        Environment otherHost = other.host();
        if (otherHost instanceof OCConduitNetwork && otherHost != this.network) {
            this.node(color).disconnect(other);
            return;
        }
        World world = this.getBundle().getBundleworld();
        EnumSet<EnumFacing> conns = this.getConnections();
        ArrayList<Object> toCheck = new ArrayList<Object>();
        if (otherHost instanceof TileEntity) {
            TileEntity otherTe = (TileEntity)otherHost;
            toCheck.add(otherTe);
        } else {
            for (EnumFacing direction : conns) {
                if (direction == null || this.getSignalColor(direction) != color) continue;
                TileEntity tileEntity = world.func_175625_s(this.getBundle().getLocation().func_177972_a(direction));
                Node other2 = null;
                if (tileEntity instanceof SidedEnvironment) {
                    other2 = ((SidedEnvironment)tileEntity).sidedNode(direction.func_176734_d());
                } else if (tileEntity instanceof Environment) {
                    other2 = ((Environment)tileEntity).node();
                }
                if (other2 != other) continue;
                toCheck.add(tileEntity);
            }
        }
        boolean stayConnected = false;
        for (TileEntity tileEntity : toCheck) {
            for (EnumFacing direction : EnumFacing.values()) {
                BlockPos otherPos;
                BlockPos connTo;
                if (direction == null || stayConnected) continue;
                boolean checkThisSide = true;
                if (otherHost instanceof SidedEnvironment) {
                    boolean bl = checkThisSide = ((SidedEnvironment)otherHost).sidedNode(direction) != null;
                }
                if (!checkThisSide || (connTo = (otherPos = tileEntity.func_174877_v()).func_177972_a(direction)).equals((Object)this.getBundle().getLocation())) continue;
                TileEntity connToTe = world.func_175625_s(connTo);
                if (connToTe instanceof SidedEnvironment) {
                    stayConnected = ((SidedEnvironment)connToTe).sidedNode(direction.func_176734_d()) == this.node(color);
                    continue;
                }
                if (!(connToTe instanceof Environment)) continue;
                stayConnected = ((Environment)connToTe).node() == this.node(color);
            }
        }
        if (!stayConnected) {
            this.node(color).disconnect(other);
        }
    }

    public EnumSet<EnumFacing> getConnections() {
        EnumSet<EnumFacing> cons = EnumSet.noneOf(EnumFacing.class);
        cons.addAll(this.getConduitConnections());
        for (EnumFacing dir : this.getExternalConnections()) {
            if (dir == null || this.getConnectionMode(dir) == ConnectionMode.DISABLED) continue;
            cons.add(dir);
        }
        return cons;
    }

    @Override
    @Nonnull
    public ConnectionMode getNextConnectionMode(@Nonnull EnumFacing dir) {
        ConnectionMode mode = this.getConnectionMode(dir);
        mode = mode == ConnectionMode.IN_OUT ? ConnectionMode.DISABLED : ConnectionMode.IN_OUT;
        return mode;
    }

    @Override
    @Nonnull
    public ConnectionMode getPreviousConnectionMode(@Nonnull EnumFacing dir) {
        return this.getNextConnectionMode(dir);
    }

    @Override
    public boolean canConnectToExternal(@Nonnull EnumFacing direction, boolean ignoreConnectionMode) {
        TileEntity te = this.getBundle().getBundleworld().func_175625_s(this.getBundle().getLocation().func_177972_a(direction));
        if (te instanceof SidedEnvironment) {
            if (this.getBundle().getBundleworld().field_72995_K) {
                return ((SidedEnvironment)te).canConnect(direction.func_176734_d());
            }
            return ((SidedEnvironment)te).sidedNode(direction.func_176734_d()) != null;
        }
        return te instanceof Environment;
    }

    @Optional.Method(modid="opencomputersapi|network")
    public Node node() {
        return this.network != null ? this.network.node(DyeColor.SILVER) : null;
    }

    @Optional.Method(modid="opencomputersapi|network")
    public Node node(DyeColor subnet) {
        return this.network != null ? this.network.node(subnet) : null;
    }

    @Optional.Method(modid="opencomputersapi|network")
    public void onConnect(Node node) {
    }

    @Optional.Method(modid="opencomputersapi|network")
    public void onDisconnect(Node node) {
    }

    @Optional.Method(modid="opencomputersapi|network")
    public void onMessage(Message message) {
    }

    @Optional.Method(modid="opencomputersapi|network")
    public Node sidedNode(EnumFacing side) {
        return side != null && this.getConnections().contains(side) ? this.node(this.getSignalColor(side)) : null;
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="opencomputersapi|network")
    public boolean canConnect(EnumFacing side) {
        return side != null && this.getConnections().contains(side);
    }

    @Override
    @Nonnull
    public TextureAtlasSprite getTextureForState(@Nonnull CollidableComponent component) {
        if (component.dir == null) {
            return coreTextureA.get(TextureAtlasSprite.class);
        }
        return longTextureA.get(TextureAtlasSprite.class);
    }

    @Override
    @Nonnull
    public TextureAtlasSprite getTransmitionTextureForState(@Nonnull CollidableComponent component) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public Vector4f getTransmitionTextureColorForState(@Nonnull CollidableComponent component) {
        return null;
    }

    @Override
    public void hashCodeForModelCaching(BlockStateWrapperConduitBundle.ConduitCacheKey hashCodes) {
        super.hashCodeForModelCaching(hashCodes);
        hashCodes.addEnum(this.signalColors);
    }

    @Override
    @Nonnull
    public IConduitNetwork<?, ?> createNetworkForType() {
        return new OCConduitNetwork();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ITabPanel createGuiPanel(@Nonnull IGuiExternalConnection gui, @Nonnull IClientConduit con) {
        return new OCSettings(gui, con);
    }

    @Override
    public boolean updateGuiPanel(@Nonnull ITabPanel panel) {
        if (panel instanceof OCSettings) {
            return ((OCSettings)panel).updateConduit(this);
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getGuiPanelTabOrder() {
        return 5;
    }

    @Override
    public void clearNetwork() {
        this.network = null;
    }

    @Override
    @Nonnull
    public String getConduitProbeInfo(@Nonnull EntityPlayer player) {
        return "";
    }
}

