/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.tic;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.farming.FarmersRegistry;
import crazypants.enderio.base.integration.tic.TicProxy;
import crazypants.enderio.base.material.alloy.Alloy;
import crazypants.enderio.integration.tic.book.EioBook;
import crazypants.enderio.integration.tic.book.TicBook;
import crazypants.enderio.integration.tic.fluids.Ender;
import crazypants.enderio.integration.tic.fluids.Glowstone;
import crazypants.enderio.integration.tic.fluids.Metal;
import crazypants.enderio.integration.tic.fluids.Redstone;
import crazypants.enderio.integration.tic.modifiers.TicModifierHandler;
import crazypants.enderio.integration.tic.modifiers.TicModifiers;
import crazypants.enderio.integration.tic.queues.TicRecipeHandler;
import crazypants.enderio.integration.tic.recipes.TicRegistration;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.tconstruct.TConstruct;

public class TicControl {
    private static boolean doFluids() {
        return TConstruct.pulseManager.isPulseLoaded((String)NullHelper.notnull((Object)"TinkerSmeltery", (String)"TiC is broken")) && TConstruct.pulseManager.isPulseLoaded((String)NullHelper.notnull((Object)"TinkerFluids", (String)"TiC is broken"));
    }

    private static boolean doToolMaterials() {
        return TConstruct.pulseManager.isPulseLoaded((String)NullHelper.notnull((Object)"TinkerTools", (String)"TiC is broken")) && TConstruct.pulseManager.isPulseLoaded((String)NullHelper.notnull((Object)"TinkerModifiers", (String)"TiC is broken"));
    }

    public static void preInitBeforeTic(FMLPreInitializationEvent event) {
        TicProxy.register(TicRecipeHandler.instance, TicModifierHandler.instance);
        if (TicControl.doFluids()) {
            Glowstone.createFluid();
            Redstone.createFluid();
            Ender.createFluid();
            NNList.of(Alloy.class).apply((NNList.Callback)new NNList.Callback<Alloy>(){

                public void apply(@Nonnull Alloy alloy) {
                    Metal.createFluid(alloy);
                }
            });
        } else if (TicControl.doToolMaterials()) {
            NNList.of(Alloy.class).apply((NNList.Callback)new NNList.Callback<Alloy>(){

                public void apply(@Nonnull Alloy alloy) {
                    Metal.createMaterial(alloy);
                }
            });
        }
    }

    public static void injectBlocks(final @Nonnull IForgeRegistry<Block> registry) {
        if (TicControl.doFluids()) {
            registry.register((IForgeRegistryEntry)Glowstone.createFluidBlock());
            registry.register((IForgeRegistryEntry)Redstone.createFluidBlock());
            registry.register((IForgeRegistryEntry)Ender.createFluidBlock());
            NNList.of(Alloy.class).apply((NNList.Callback)new NNList.Callback<Alloy>(){

                public void apply(@Nonnull Alloy alloy) {
                    registry.register((IForgeRegistryEntry)Metal.createFluidBlock(alloy));
                }
            });
        }
    }

    public static void initBeforeTic(FMLInitializationEvent event) {
        if (TicControl.doToolMaterials()) {
            NNList.of(Alloy.class).apply((NNList.Callback)new NNList.Callback<Alloy>(){

                public void apply(@Nonnull Alloy alloy) {
                    Metal.createTraits(alloy);
                }
            });
            TicModifiers.register();
            if (!EnderIO.proxy.isDedicatedServer()) {
                TicBook.integrate();
            }
        }
        if (!EnderIO.proxy.isDedicatedServer()) {
            EioBook.integrate();
        }
        FarmersRegistry.registerHoes("tconstruct", "mattock");
    }

    public static void postInitBeforeTic(FMLPostInitializationEvent event) {
        if (TicControl.doFluids()) {
            Glowstone.registerGlowstoneRecipes();
            Redstone.registerRedstoneRecipes();
            Ender.registerEnderRecipes();
        }
    }

    public static void postInitAfterTic(FMLPostInitializationEvent event) {
        if (TicControl.doFluids()) {
            TicRegistration.registerSmeltings();
            TicRegistration.registerAlloys();
            TicRegistration.registerTableCasting();
            TicRegistration.registerBasinCasting();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenderers(ModelRegistryEvent event) {
        if (TicControl.doFluids()) {
            Glowstone.registerRenderers();
            Redstone.registerRenderers();
            Ender.registerRenderers();
            NNList.of(Alloy.class).apply((NNList.Callback)new NNList.Callback<Alloy>(){

                public void apply(@Nonnull Alloy alloy) {
                    Metal.registerRenderers(alloy);
                }
            });
        }
    }
}

