/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.tic.materials;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.material.alloy.Alloy;
import crazypants.enderio.integration.tic.traits.TraitPickup;
import crazypants.enderio.integration.tic.traits.TraitTeleport;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.Fluid;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.BowStringMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.tools.TinkerTraits;

public class TicMaterials {
    private static final Map<Alloy, Data> TRAITS = new EnumMap<Alloy, Data>(Alloy.class);
    private static final Map<Alloy, Fluid> FLUIDS = new EnumMap<Alloy, Fluid>(Alloy.class);
    private static final Map<Alloy, Material> MATERIALS = new EnumMap<Alloy, Material>(Alloy.class);

    @Nonnull
    public static Data getData(Alloy alloy) {
        return (Data)NullHelper.notnull((Object)TRAITS.get((Object)alloy), (String)"TRAIT AWOL");
    }

    @Nonnull
    public static Fluid getFluid(Alloy alloy) {
        return (Fluid)NullHelper.notnull((Object)FLUIDS.get((Object)alloy), (String)"FLUID AWOL");
    }

    @Nonnull
    public static Material getMaterial(Alloy alloy) {
        return (Material)NullHelper.notnull((Object)MATERIALS.get((Object)alloy), (String)"MATERIAL AWOL");
    }

    public static void setFluid(Alloy alloy, Fluid fluid) {
        FLUIDS.put(alloy, fluid);
    }

    public static void setMaterial(Alloy alloy, Material material) {
        MATERIALS.put(alloy, material);
    }

    static {
        TRAITS.put(Alloy.ELECTRICAL_STEEL, new Data(){

            @Override
            public void traits(@Nonnull Material material) {
                material.addTrait((ITrait)TinkerTraits.lightweight);
                material.addTrait((ITrait)TinkerTraits.shocking, "head");
            }

            @Override
            public void stats(@Nonnull Material material) {
                TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)new HeadMaterialStats(306, 6.5f, 2.25f, 2), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.75f, 80), new ExtraMaterialStats(75), new BowMaterialStats(1.5f, 0.9f, 1.0f)});
            }
        });
        TRAITS.put(Alloy.ENERGETIC_ALLOY, new Data(){

            @Override
            public void traits(@Nonnull Material material) {
                material.addTrait((ITrait)TinkerTraits.petramor);
                material.addTrait((ITrait)TinkerTraits.unnatural, "head");
                material.addTrait((ITrait)TinkerTraits.holy, "handle");
            }

            @Override
            public void stats(@Nonnull Material material) {
                TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)new HeadMaterialStats(690, 2.5f, 5.6f, 3), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(2.0f, -800), new ExtraMaterialStats(400), new BowMaterialStats(0.5f, 0.8f, 1.0f)});
            }
        });
        TRAITS.put(Alloy.VIBRANT_ALLOY, new Data(){

            @Override
            public void traits(@Nonnull Material material) {
                material.addTrait((ITrait)TraitPickup.instance);
                material.addTrait((ITrait)TraitTeleport.instance4, "head");
            }

            @Override
            public void stats(@Nonnull Material material) {
                TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)new HeadMaterialStats(220, 3.5f, 9.0f, 4), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.5f, -50), new ExtraMaterialStats(60), new BowMaterialStats(0.75f, 1.0f, 5.0f)});
            }
        });
        TRAITS.put(Alloy.REDSTONE_ALLOY, new Data(){

            @Override
            public void traits(@Nonnull Material material) {
                material.addTrait((ITrait)TinkerTraits.crude);
                material.addTrait((ITrait)TinkerTraits.shocking, "head");
                material.addTrait((ITrait)TinkerTraits.writable, "handle");
            }

            @Override
            public void stats(@Nonnull Material material) {
                TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)new HeadMaterialStats(120, 2.5f, 1.5f, 0), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.0f, -5), new ExtraMaterialStats(150), new BowMaterialStats(2.5f, 0.4f, 0.0f)});
            }
        });
        TRAITS.put(Alloy.CONDUCTIVE_IRON, new Data(){

            @Override
            public void traits(@Nonnull Material material) {
                material.addTrait((ITrait)TinkerTraits.lightweight);
                material.addTrait((ITrait)TinkerTraits.crude2, "head");
            }

            @Override
            public void stats(@Nonnull Material material) {
                TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)new HeadMaterialStats(106, 6.75f, 1.25f, 2), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.25f, 100), new ExtraMaterialStats(250), new BowMaterialStats(1.5f, 0.9f, 1.25f)});
            }
        });
        TRAITS.put(Alloy.PULSATING_IRON, new Data(){

            @Override
            public void traits(@Nonnull Material material) {
                material.addTrait((ITrait)TraitTeleport.instance1);
                material.addTrait((ITrait)TraitTeleport.instance2, "handle");
                material.addTrait((ITrait)TraitTeleport.instance3, "extra");
                material.addTrait((ITrait)TraitTeleport.instance0, "head");
                material.addTrait((ITrait)TinkerTraits.poisonous, "projectile");
            }

            @Override
            public void stats(@Nonnull Material material) {
                TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)new HeadMaterialStats(920, 6.0f, 2.0f, 1), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.05f, 250), new ExtraMaterialStats(250), new BowMaterialStats(0.25f, 3.5f, 6.0f)});
            }
        });
        TRAITS.put(Alloy.DARK_STEEL, new Data(){

            @Override
            public void traits(@Nonnull Material material) {
                material.addTrait((ITrait)TinkerTraits.unnatural);
                material.addTrait((ITrait)TinkerTraits.enderference, "head");
                material.addTrait((ITrait)TinkerTraits.dense, "extra");
                material.addTrait((ITrait)TinkerTraits.dense, "bow");
            }

            @Override
            public void stats(@Nonnull Material material) {
                TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)new HeadMaterialStats(550, 7.0f, 6.0f, 4), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.9f, 150), new ExtraMaterialStats(250), new BowMaterialStats(0.3f, 2.5f, 9.0f)});
            }
        });
        TRAITS.put(Alloy.SOULARIUM, new Data(){

            @Override
            public void traits(@Nonnull Material material) {
                material.addTrait((ITrait)TinkerTraits.duritos);
                material.addTrait((ITrait)TinkerTraits.hellish, "head");
                material.addTrait((ITrait)TinkerTraits.splinters, "extra");
                material.addTrait((ITrait)TinkerTraits.flammable, "handle");
                material.addTrait((ITrait)TinkerTraits.writable, "bowstring");
            }

            @Override
            public void stats(@Nonnull Material material) {
                TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)new HeadMaterialStats(1555, 1.0f, 1.0f, 0), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.5f, 1500), new ExtraMaterialStats(1250), new BowMaterialStats(0.1f, 0.5f, 0.0f), new BowStringMaterialStats(0.75f)});
            }
        });
        TRAITS.put(Alloy.END_STEEL, new Data(){

            @Override
            public void traits(@Nonnull Material material) {
                material.addTrait((ITrait)TinkerTraits.unnatural);
                material.addTrait((ITrait)TinkerTraits.enderference, "head");
                material.addTrait((ITrait)TinkerTraits.alien, "head");
            }

            @Override
            public void stats(@Nonnull Material material) {
                TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)new HeadMaterialStats(400, 8.25f, 5.0f, 4), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.9f, 50), new ExtraMaterialStats(150), new BowMaterialStats(0.3f, 2.5f, 9.0f)});
            }
        });
    }

    public static interface Data {
        public void traits(@Nonnull Material var1);

        public void stats(@Nonnull Material var1);
    }
}

