/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.integration.jei;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredient;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredientRenderer;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.painter.AbstractPainterTemplate;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.integration.jei.PainterRegistryPlugin;
import crazypants.enderio.machines.machine.painter.ContainerPainter;
import crazypants.enderio.machines.machine.painter.GuiPainter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class PainterRecipeCategory
implements IRecipeCategory<PainterRecipeWrapper> {
    @Nonnull
    public static final String UID = "Painter";
    private static final int xOff = 34;
    private static final int yOff = 28;
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private final IDrawableAnimated arrow;

    public static void register(IModRegistry registry) {
        registry.addRecipeClickArea(GuiPainter.class, 155, 42, 16, 16, new String[]{UID});
        registry.addRecipeCatalyst((Object)new ItemStack(MachineObject.block_painter.getBlockNN()), new String[]{UID});
        registry.addRecipeRegistryPlugin((IRecipeRegistryPlugin)new PainterRegistryPlugin(registry));
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerPainter.class, UID, ContainerPainter.FIRST_RECIPE_SLOT, ContainerPainter.NUM_RECIPE_SLOT, ContainerPainter.FIRST_INVENTORY_SLOT, ContainerPainter.NUM_INVENTORY_SLOT);
    }

    public PainterRecipeCategory(IJeiHelpers jeiHelpers) {
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        ResourceLocation backgroundLocation = EnderIO.proxy.getGuiTexture("painter");
        this.background = guiHelper.createDrawable(backgroundLocation, 34, 28, 120, 50);
        IDrawableStatic flameDrawable = guiHelper.createDrawable(backgroundLocation, 176, 14, 24, 16);
        this.arrow = guiHelper.createAnimatedDrawable(flameDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return MachineObject.block_painter.getBlockNN().func_149732_F();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.arrow.draw(minecraft, 54, 6);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull PainterRecipeWrapper currentRecipe, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiIngredientGroup group = recipeLayout.getIngredientsGroup(EnergyIngredient.class);
        guiItemStacks.init(0, true, 32, 5);
        guiItemStacks.init(1, true, 3, 5);
        guiItemStacks.init(2, false, 86, 5);
        group.init(3, true, (IIngredientRenderer)EnergyIngredientRenderer.INSTANCE, 74, 32, 50, 10, 0, 0);
        guiItemStacks.set(0, currentRecipe.target);
        guiItemStacks.set(1, currentRecipe.paints);
        guiItemStacks.set(2, currentRecipe.results);
        group.set(ingredients);
    }

    @Nonnull
    public String getModName() {
        return "enderiomachines";
    }

    public static class PainterRecipeWrapper
    implements IRecipeWrapper {
        final AbstractPainterTemplate<?> recipe;
        @Nonnull
        final ItemStack target;
        @Nonnull
        final List<ItemStack> paints;
        @Nonnull
        final List<ItemStack> results;

        public PainterRecipeWrapper(@Nonnull AbstractPainterTemplate<?> recipe, @Nonnull ItemStack target, @Nonnull List<ItemStack> paints, @Nonnull List<ItemStack> results) {
            this.recipe = recipe;
            this.target = target;
            this.paints = paints;
            this.results = results;
        }

        public PainterRecipeWrapper(@Nonnull AbstractPainterTemplate<?> recipe, @Nonnull ItemStack target, @Nonnull ItemStack paint, @Nonnull ItemStack result) {
            this.recipe = recipe;
            this.target = target;
            this.paints = Collections.singletonList(paint);
            this.results = Collections.singletonList(result);
        }

        public void getIngredients(@Nonnull IIngredients ingredients) {
            ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>();
            list.add(Collections.singletonList(this.target));
            list.add(this.paints);
            ingredients.setInputLists(ItemStack.class, list);
            ingredients.setOutputs(ItemStack.class, this.results);
            ingredients.setInput(EnergyIngredient.class, (Object)new EnergyIngredient(this.recipe.getEnergyRequired((NNList<MachineRecipeInput>)NNList.emptyList())));
        }
    }
}

