/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.integration.jei;

import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.base.recipe.sagmill.GrindingBall;
import crazypants.enderio.base.recipe.sagmill.SagMillRecipeManager;
import crazypants.enderio.machines.init.MachineObject;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class SagMillGrindingBallCategory
extends BlankRecipeCategory<GrindingBallWrapper> {
    @Nonnull
    public static final String UID = "GrindingBall";
    @Nonnull
    private final IDrawable background;
    private final ITickTimer timer;

    public static void register(IModRegistry registry, IGuiHelper guiHelper) {
        registry.addRecipeCategories(new IRecipeCategory[]{new SagMillGrindingBallCategory(guiHelper)});
        registry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_sag_mill.getBlockNN()), new String[]{UID});
        registry.handleRecipes(GrindingBall.class, GrindingBallWrapper::new, UID);
        registry.addRecipes(SagMillRecipeManager.getInstance().getBalls(), UID);
    }

    public SagMillGrindingBallCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = new ResourceLocation("enderio", "textures/gui/jei.grinding_ball.png");
        this.background = guiHelper.createDrawable(backgroundLocation, 0, 0, 146, 40, 146, 40);
        this.timer = guiHelper.createTickTimer(20000, 20000, false);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return Lang.GRINDING_BALL_1.get("");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull GrindingBallWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 16, 11);
        guiItemStacks.set(ingredients);
        recipeWrapper.timer = this.timer;
    }

    @Nonnull
    public String getModName() {
        return "enderiomachines";
    }

    public static class GrindingBallWrapper
    extends BlankRecipeWrapper {
        private final GrindingBall ball;
        public ITickTimer timer;

        public GrindingBallWrapper(GrindingBall ball) {
            this.ball = ball;
        }

        public void getIngredients(@Nonnull IIngredients ingredients) {
            ingredients.setInput(ItemStack.class, (Object)this.ball.getInput());
            ingredients.setOutput(ItemStack.class, (Object)this.ball.getInput());
        }

        public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            FontRenderer fr = minecraft.field_71466_p;
            fr.func_78276_b(Lang.GRINDING_BALL_2.get("", LangPower.toPercent(this.ball.getGrindingMultiplier())), 48, 4, 0x404040);
            fr.func_78276_b(Lang.GRINDING_BALL_3.get("", LangPower.toPercent(this.ball.getChanceMultiplier())), 48, 16, 0x404040);
            fr.func_78276_b(Lang.GRINDING_BALL_4.get("", LangPower.toPercent(this.ball.getPowerMultiplier())), 48, 28, 0x404040);
            int dura = this.ball.getDurability();
            int usedDura = this.timer.getValue() * 400 % dura;
            int barH = 16 * usedDura / dura;
            int barColor = -3526879;
            Gui.func_73734_a((int)37, (int)(12 + barH), (int)41, (int)28, (int)barColor);
        }

        @Nonnull
        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            if (mouseX > 48 && mouseX < 146) {
                if (mouseY < 14) {
                    return crazypants.enderio.machines.lang.Lang.JEI_GRINDING_BALL_MAIN.getLines(new Object[0]);
                }
                if (mouseY < 26) {
                    return crazypants.enderio.machines.lang.Lang.JEI_GRINDING_BALL_BONUS.getLines(new Object[0]);
                }
                return crazypants.enderio.machines.lang.Lang.JEI_GRINDING_BALL_POWER.getLines(new Object[0]);
            }
            if (mouseX >= 36 && mouseX <= 41 && mouseY >= 12 && mouseY <= 29) {
                return Collections.singletonList(LangPower.RF(this.ball.getDurability()));
            }
            return super.getTooltipStrings(mouseX, mouseY);
        }
    }
}

