/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.integration.jei.sagmill;

import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.gui.tooltip.TooltipHandlerGrinding;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredient;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredientRenderer;
import crazypants.enderio.base.recipe.IRecipe;
import crazypants.enderio.base.recipe.RecipeOutput;
import crazypants.enderio.base.recipe.sagmill.SagMillRecipeManager;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.integration.jei.sagmill.SagMillRecipeTransferHandler;
import crazypants.enderio.machines.integration.jei.sagmill.SagRecipe;
import crazypants.enderio.machines.integration.jei.sagmill.SimpleSagMillRecipeTransferHandler;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.sagmill.ContainerSagMill;
import crazypants.enderio.machines.machine.sagmill.GuiSagMill;
import java.text.MessageFormat;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class SagMillRecipeCategory
extends BlankRecipeCategory<SagRecipe>
implements ITooltipCallback<ItemStack> {
    @Nonnull
    public static final String UID = "SagMill";
    private int xOff = 45;
    private int yOff = 3;
    @Nonnull
    private final IDrawable background;
    @Nonnull
    protected final IDrawableAnimated arrow;
    private final TooltipHandlerGrinding ballsTT = new TooltipHandlerGrinding();

    public static void register(IModRegistry registry, IGuiHelper guiHelper) {
        registry.addRecipeCategories(new IRecipeCategory[]{new SagMillRecipeCategory(guiHelper)});
        registry.handleRecipes(IRecipe.class, SagRecipe::new, UID);
        registry.addRecipeClickArea(GuiSagMill.class, 155, 42, 16, 16, new String[]{UID});
        registry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_sag_mill.getBlockNN()), new String[]{UID});
        registry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_simple_sag_mill.getBlockNN()), new String[]{UID});
        registry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_enhanced_sag_mill.getBlockNN()), new String[]{UID});
        registry.addRecipes(SagMillRecipeManager.getInstance().getRecipes(), UID);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferHandler)new SagMillRecipeTransferHandler(registry, UID, ContainerSagMill.FIRST_RECIPE_SLOT, ContainerSagMill.NUM_RECIPE_SLOT, ContainerSagMill.FIRST_INVENTORY_SLOT, ContainerSagMill.NUM_INVENTORY_SLOT), UID);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferHandler)new SimpleSagMillRecipeTransferHandler(registry, UID, ContainerSagMill.FIRST_RECIPE_SLOT, ContainerSagMill.NUM_RECIPE_SLOT, ContainerSagMill.FIRST_INVENTORY_SLOT - 1, ContainerSagMill.NUM_INVENTORY_SLOT), UID);
    }

    public SagMillRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = EnderIO.proxy.getGuiTexture("crusher");
        this.background = guiHelper.createDrawable(backgroundLocation, this.xOff, this.yOff, 109, 78);
        IDrawableStatic flameDrawable = guiHelper.createDrawable(backgroundLocation, 201, 1, 16, 22);
        this.arrow = guiHelper.createAnimatedDrawable(flameDrawable, 200, IDrawableAnimated.StartDirection.TOP, false);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return MachineObject.block_sag_mill.getBlockNN().func_149732_F();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.arrow.draw(minecraft, 80 - this.xOff, 32 - this.yOff);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, final @Nonnull SagRecipe recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.addTooltipCallback((ITooltipCallback)this);
        IGuiIngredientGroup group = recipeLayout.getIngredientsGroup(EnergyIngredient.class);
        guiItemStacks.init(0, true, 79 - this.xOff, 11 - this.yOff);
        guiItemStacks.init(1, false, 48 - this.xOff, 58 - this.yOff);
        guiItemStacks.init(2, false, 69 - this.xOff, 58 - this.yOff);
        guiItemStacks.init(3, false, 90 - this.xOff, 58 - this.yOff);
        guiItemStacks.init(4, false, 111 - this.xOff, 58 - this.yOff);
        guiItemStacks.init(5, true, 121 - this.xOff, 22 - this.yOff);
        group.init(6, true, (IIngredientRenderer)EnergyIngredientRenderer.INSTANCE, 134 - this.xOff, 58 - this.yOff, 60, 10, 0, 0);
        guiItemStacks.addTooltipCallback((ITooltipCallback)new ITooltipCallback<ItemStack>(){

            public void onTooltip(int slotIndex, boolean input, @Nonnull ItemStack ingredient, @Nonnull List<String> tooltip) {
                switch (slotIndex) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        RecipeOutput output;
                        float chance;
                        if (slotIndex <= recipeWrapper.getRecipe().getOutputs().length && (chance = (output = recipeWrapper.getRecipe().getOutputs()[slotIndex - 1]).getChance()) > 0.0f && chance < 1.0f) {
                            int chanceInt = (int)(chance * 100.0f);
                            Object[] objects = new Object[]{chanceInt};
                            tooltip.add(TextFormatting.GRAY + MessageFormat.format(Lang.JEI_SAGMILL_CHANCE.get(), objects));
                        }
                        return;
                    }
                    case 5: {
                        if (SagMillRecipeCategory.this.ballsTT.shouldHandleItem(ingredient)) {
                            SagMillRecipeCategory.this.ballsTT.addDetailedEntries(ingredient, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, tooltip, true);
                        }
                        return;
                    }
                }
            }
        });
        guiItemStacks.set(ingredients);
        group.set(ingredients);
    }

    public void onTooltip(int slotIndex, boolean input, @Nonnull ItemStack ingredient, @Nonnull List<String> tooltip) {
    }

    @Nonnull
    public String getModName() {
        return "enderiomachines";
    }
}

