/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.crafter;

import com.enderio.core.common.inventory.EnderInventory;
import com.enderio.core.common.inventory.Filters;
import com.enderio.core.common.inventory.InventorySlot;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NNList;
import com.google.common.base.Predicate;
import com.mojang.authlib.GameProfile;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.base.capacitor.DefaultCapacitorData;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.machine.base.te.AbstractCapabilityPoweredMachineEntity;
import crazypants.enderio.base.machine.fakeplayer.FakePlayerEIO;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.machine.crafter.DummyCraftingGrid;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.handlers.minecraft.HandleItemStack;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

@Storable
public class TileCrafter
extends AbstractCapabilityPoweredMachineEntity
implements IPaintable.IPaintableTileEntity {
    @Nonnull
    public static final String OUTPUT_SLOT = "OUTPUT";
    @Nonnull
    public static final String INPUT_SLOT = "INPUT";
    public static final int BASE_TICK_RATE = 10;
    @Store
    DummyCraftingGrid craftingGrid = new DummyCraftingGrid();
    @Store(handler=HandleItemStack.HandleItemStackNNList.class)
    private final NNList<ItemStack> containerItems = new NNList();
    @Store
    private boolean bufferStacks = true;
    private long ticksSinceLastCraft = 0L;
    private FakePlayerEIO playerInst;
    private static final UUID uuid = UUID.fromString("9b381cae-3c95-4a64-b958-1e25b0a4c790");
    private static final GameProfile DUMMY_PROFILE = new GameProfile(uuid, "[EioCrafter]");

    public TileCrafter() {
        this(CapacitorKey.CRAFTER_POWER_INTAKE, CapacitorKey.CRAFTER_POWER_BUFFER, CapacitorKey.CRAFTER_POWER_USE);
    }

    public TileCrafter(@Nonnull ICapacitorKey maxEnergyRecieved, @Nonnull ICapacitorKey maxEnergyStored, @Nonnull ICapacitorKey maxEnergyUsed) {
        super(maxEnergyRecieved, maxEnergyStored, maxEnergyUsed);
        for (int i = 0; i < 9; ++i) {
            PredicateItemStackMatch predicate = new PredicateItemStackMatch(i);
            this.getInventory().add(EnderInventory.Type.INPUT, INPUT_SLOT + i, new InventorySlot((Predicate)predicate, Filters.ALWAYS_TRUE));
        }
        this.getInventory().add(EnderInventory.Type.OUTPUT, OUTPUT_SLOT, new InventorySlot(Filters.ALWAYS_FALSE, Filters.ALWAYS_TRUE));
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        ++this.ticksSinceLastCraft;
        if (!this.containerItems.isEmpty()) {
            NNList.NNIterator iter = this.containerItems.iterator();
            while (iter.hasNext()) {
                if (!this.mergeOutput((ItemStack)iter.next())) continue;
                iter.remove();
            }
            this.ticksSinceLastCraft = 0L;
        } else if (this.ticksSinceLastCraft > (long)this.getTicksPerCraft()) {
            if (!this.craftingGrid.hasValidRecipe()) {
                for (int i = 0; i < 9; ++i) {
                    ItemStack stack = this.getInventory().getSlot(INPUT_SLOT + i).get();
                    if (!Prep.isValid(stack)) continue;
                    this.containerItems.add((Object)stack);
                    this.getInventory().getSlot(INPUT_SLOT + i).clear();
                }
            } else if (redstoneCheck && this.hasRequiredPower() && this.canMergeOutput() && this.canCraft() && this.craftRecipe()) {
                this.ticksSinceLastCraft = 0L;
                this.getEnergy().extractEnergy(this.getPowerUsePerCraft(), false);
            }
        }
        return false;
    }

    private boolean hasRequiredPower() {
        return this.getEnergy().getEnergyStored() >= this.getPowerUsePerCraft();
    }

    protected int getPowerUsePerCraft() {
        return CapacitorKey.CRAFTER_POWER_CRAFT.get(this.getCapacitorData());
    }

    public int getTicksPerCraft() {
        int impulseHopperSpeedScaled = CapacitorKey.CRAFTER_SPEED.get(this.getCapacitorData());
        if (impulseHopperSpeedScaled > 0) {
            return 10 / impulseHopperSpeedScaled;
        }
        return 10;
    }

    static boolean compareDamageable(@Nonnull ItemStack stack, @Nonnull ItemStack req) {
        if (stack.func_77969_a(req)) {
            return true;
        }
        if (stack.func_77984_f() && stack.func_77973_b() == req.func_77973_b()) {
            return stack.func_77952_i() < stack.func_77958_k();
        }
        return false;
    }

    private boolean canCraft() {
        int[] used = new int[9];
        int found = 0;
        int required = 0;
        block0: for (int j = 0; j < 9; ++j) {
            ItemStack req = this.craftingGrid.func_70301_a(j);
            if (req.func_190926_b()) continue;
            ++required;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.getInventory().getSlot(INPUT_SLOT + i).get();
                if (stack.func_190916_E() <= used[i] || !TileCrafter.compareDamageable(stack, req)) continue;
                ++found;
                int n = i;
                used[n] = used[n] + 1;
                continue block0;
            }
        }
        return found == required;
    }

    private boolean craftRecipe() {
        IRecipe recipe;
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(@Nonnull EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        block0: for (int j = 0; j < 9; ++j) {
            ItemStack req = this.craftingGrid.func_70301_a(j);
            if (req.func_190926_b()) {
                inv.func_70299_a(j, req);
                continue;
            }
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.getInventory().getSlot(INPUT_SLOT + i).get();
                if (!TileCrafter.compareDamageable(stack, req)) continue;
                inv.func_70299_a(j, stack.func_77979_a(1));
                continue block0;
            }
        }
        if (this.playerInst == null) {
            this.playerInst = new FakePlayerEIO(this.field_145850_b, this.getLocation(), DUMMY_PROFILE);
            this.playerInst.setOwner(this.getOwner());
        }
        if ((recipe = CraftingManager.func_192413_b((InventoryCrafting)inv, (World)this.field_145850_b)) == null) {
            return false;
        }
        ForgeHooks.setCraftingPlayer((EntityPlayer)this.playerInst);
        ItemStack output = recipe.func_77572_b(inv);
        output.func_77980_a(this.field_145850_b, (EntityPlayer)this.playerInst, 1);
        NonNullList remaining = CraftingManager.func_180303_b((InventoryCrafting)inv, (World)this.field_145850_b);
        ForgeHooks.setCraftingPlayer(null);
        for (int j = 0; j < 9; ++j) {
            inv.func_70301_a(j).func_190918_g(1);
            if (inv.func_70301_a(j).func_190926_b()) continue;
            this.containerItems.add((Object)inv.func_70301_a(j));
        }
        for (ItemStack stack : remaining) {
            if (stack.func_190926_b()) continue;
            this.containerItems.add((Object)stack.func_77946_l());
        }
        if (!this.mergeOutput(output)) {
            this.containerItems.add((Object)output);
        }
        return true;
    }

    private boolean mergeOutput(@Nonnull ItemStack stack) {
        ItemStack oldOutput = this.getInventory().getSlot(OUTPUT_SLOT).get();
        if (oldOutput.func_190926_b()) {
            this.getInventory().getSlot(OUTPUT_SLOT).set(stack);
            return true;
        }
        if (ItemUtil.areStackMergable((ItemStack)oldOutput, (ItemStack)stack)) {
            oldOutput.func_190917_f(stack.func_77979_a(Math.min(oldOutput.func_77976_d() - oldOutput.func_190916_E(), stack.func_190916_E())).func_190916_E());
            this.getInventory().getSlot(OUTPUT_SLOT).set(oldOutput);
            return stack.func_190926_b();
        }
        return false;
    }

    private boolean canMergeOutput() {
        ItemStack oldOutput = this.getInventory().getSlot(OUTPUT_SLOT).get();
        if (oldOutput.func_190926_b()) {
            return true;
        }
        ItemStack output = this.craftingGrid.getOutput();
        if (!ItemUtil.areStackMergable((ItemStack)oldOutput, (ItemStack)output)) {
            return false;
        }
        return output.func_77976_d() >= oldOutput.func_190916_E() + output.func_190916_E();
    }

    public boolean isBufferStacks() {
        return this.bufferStacks;
    }

    public void setBufferStacks(boolean bufferStacks) {
        this.bufferStacks = bufferStacks;
    }

    public void updateCraftingOutput() {
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(@Nonnull EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            inv.func_70299_a(i, this.craftingGrid.func_70301_a(i));
        }
        ItemStack matches = ItemStack.field_190927_a;
        IRecipe recipe = CraftingManager.func_192413_b((InventoryCrafting)inv, (World)this.field_145850_b);
        if (recipe != null) {
            matches = recipe.func_77571_b();
        }
        this.craftingGrid.func_70299_a(9, matches);
        this.func_70296_d();
    }

    private class PredicateItemStackMatch
    extends Filters.PredicateItemStack {
        private final int slot;

        PredicateItemStackMatch(int slot) {
            this.slot = slot;
        }

        public boolean doApply(@Nonnull ItemStack input) {
            return input.func_77969_a(TileCrafter.this.craftingGrid.func_70301_a(this.slot));
        }
    }

    public static class Simple
    extends TileCrafter {
        public Simple() {
            super(CapacitorKey.SIMPLE_CRAFTER_POWER_INTAKE, CapacitorKey.SIMPLE_CRAFTER_POWER_BUFFER, CapacitorKey.SIMPLE_CRAFTER_POWER_USE);
            this.getInventory().getSlot("cap").set(new ItemStack(ModObject.itemBasicCapacitor.getItemNN(), 1, DefaultCapacitorData.ENDER_CAPACITOR.ordinal()));
        }

        @Override
        public int getTicksPerCraft() {
            return 20;
        }
    }
}

