/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.generator.zombie;

import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.machine.baselegacy.AbstractGeneratorBlock;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.IHaveTESR;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.base.sound.SoundHelper;
import crazypants.enderio.base.sound.SoundRegistry;
import crazypants.enderio.machines.config.config.ClientConfig;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.machine.generator.zombie.BubbleFX;
import crazypants.enderio.machines.machine.generator.zombie.ContainerZombieGenerator;
import crazypants.enderio.machines.machine.generator.zombie.GuiZombieGenerator;
import crazypants.enderio.machines.machine.generator.zombie.TileZombieGenerator;
import crazypants.enderio.machines.machine.generator.zombie.ZombieGeneratorRenderer;
import crazypants.enderio.machines.machine.killera.KillerJoeRenderMapper;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockZombieGenerator<T extends TileZombieGenerator>
extends AbstractGeneratorBlock<T>
implements IHaveTESR {
    @Nonnull
    public static final TextureRegistry.TextureSupplier textureHead1 = TextureRegistry.registerTexture("blocks/zombie_gen_head");
    @Nonnull
    public static final TextureRegistry.TextureSupplier textureHead2 = TextureRegistry.registerTexture("blocks/zombie_gen_head2");
    @Nonnull
    public static final TextureRegistry.TextureSupplier textureHeadEnder1 = TextureRegistry.registerTexture("blocks/ender_gen_head");
    @Nonnull
    public static final TextureRegistry.TextureSupplier textureHeadEnder2 = TextureRegistry.registerTexture("blocks/ender_gen_head2");
    private static final double px = 0.0625;
    @Nonnull
    public static final AxisAlignedBB AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);

    public static BlockZombieGenerator<TileZombieGenerator> create(@Nonnull IModObject modObject) {
        BlockZombieGenerator<TileZombieGenerator> gen = new BlockZombieGenerator<TileZombieGenerator>(modObject);
        gen.init();
        return gen;
    }

    public static BlockFrankNZombieGenerator create_franken(@Nonnull IModObject modObject) {
        BlockFrankNZombieGenerator gen = new BlockFrankNZombieGenerator(modObject);
        gen.init();
        return gen;
    }

    public static BlockEnderGenerator create_ender(@Nonnull IModObject modObject) {
        BlockEnderGenerator gen = new BlockEnderGenerator(modObject);
        gen.init();
        return gen;
    }

    protected BlockZombieGenerator(@Nonnull IModObject modObject) {
        super(modObject, new Material(MapColor.field_151668_h){

            public boolean func_76218_k() {
                return false;
            }
        });
        this.func_149713_g(5);
        this.setShape(this.mkShape(BlockFaceShape.MIDDLE_POLE_THICK, BlockFaceShape.MIDDLE_POLE_THICK, BlockFaceShape.UNDEFINED));
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        return AABB;
    }

    @Override
    @Nullable
    public Container getServerGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, @Nonnull TileZombieGenerator te) {
        return new ContainerZombieGenerator(player.field_71071_by, te);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public GuiScreen getClientGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, @Nonnull TileZombieGenerator te) {
        return new GuiZombieGenerator(player.field_71071_by, te);
    }

    public int func_149717_k(@Nonnull IBlockState bs) {
        return 0;
    }

    public boolean func_149662_c(@Nonnull IBlockState bs) {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState bs) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(@Nonnull IBlockState bs, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random rand) {
        TileZombieGenerator te;
        if (rand.nextInt(3) == 0 && (te = (TileZombieGenerator)this.getTileEntity((IBlockAccess)world, pos)) != null && te.isActive()) {
            for (int i = 0; i < 2; ++i) {
                float xOffset = 0.5f + (world.field_73012_v.nextFloat() * 2.0f - 1.0f) * 0.3f;
                float yOffset = 0.1f;
                float zOffset = 0.5f + (world.field_73012_v.nextFloat() * 2.0f - 1.0f) * 0.3f;
                BubbleFX fx = new BubbleFX(world, (float)pos.func_177958_n() + xOffset, (float)pos.func_177956_o() + yOffset, (float)pos.func_177952_p() + zOffset, 0.0, 0.5, 0.0);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
            }
            if (ClientConfig.machineSoundsEnabled.get().booleanValue()) {
                SoundHelper.playSound(world, pos, SoundHelper.BLOCK_TOP, SoundRegistry.ZOMBIE_BUBBLE, ClientConfig.machineSoundVolume.get().floatValue() * 0.045f, world.field_73012_v.nextFloat() * 0.75f);
            }
        }
    }

    @Override
    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileZombieGenerator tileEntity) {
        blockStateWrapper.addCacheKey(tileEntity.getFacing());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return KillerJoeRenderMapper.zombieGen;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return KillerJoeRenderMapper.zombieGen;
    }

    @Override
    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void bindTileEntitySpecialRenderer() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileZombieGenerator.class, (TileEntitySpecialRenderer)new ZombieGeneratorRenderer(MachineObject.block_zombie_generator.getBlockNN()));
    }

    private static class BlockEnderGenerator
    extends BlockZombieGenerator<TileZombieGenerator.TileEnderGenerator> {
        public BlockEnderGenerator(@Nonnull IModObject modObject) {
            super(modObject);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void bindTileEntitySpecialRenderer() {
            ClientRegistry.bindTileEntitySpecialRenderer(TileZombieGenerator.TileEnderGenerator.class, (TileEntitySpecialRenderer)new ZombieGeneratorRenderer(MachineObject.block_ender_generator.getBlockNN()));
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        @Nonnull
        public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
            return KillerJoeRenderMapper.enderGen;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
            return KillerJoeRenderMapper.enderGen;
        }
    }

    private static class BlockFrankNZombieGenerator
    extends BlockZombieGenerator<TileZombieGenerator.TileFrankenZombieGenerator> {
        public BlockFrankNZombieGenerator(@Nonnull IModObject modObject) {
            super(modObject);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void bindTileEntitySpecialRenderer() {
            ClientRegistry.bindTileEntitySpecialRenderer(TileZombieGenerator.TileFrankenZombieGenerator.class, (TileEntitySpecialRenderer)new ZombieGeneratorRenderer(MachineObject.block_franken_zombie_generator.getBlockNN()));
        }
    }
}

