/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.tank;

import com.enderio.core.common.fluid.SmartTank;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.config.factory.IValue;
import crazypants.enderio.base.fluid.ItemTankHelper;
import crazypants.enderio.machines.config.config.TankConfig;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;

public enum EnumTankType implements IStringSerializable
{
    NORMAL(TankConfig.tankSizeNormal, false, ""),
    ADVANCED(TankConfig.tankSizeAdvanced, true, ".advanced");

    @Nonnull
    public static final PropertyEnum<EnumTankType> KIND;
    private final IValue<Integer> size;
    private final boolean explosionResistant;
    @Nonnull
    private final String suffix;

    private EnumTankType(@Nonnull IValue<Integer> size, boolean explosionResistant, String suffix) {
        this.size = size;
        this.explosionResistant = explosionResistant;
        this.suffix = suffix;
    }

    @Nonnull
    public String func_176610_l() {
        return (String)NullHelper.notnullJ((Object)this.name().toLowerCase(Locale.ENGLISH), (String)"String.toLowerCase()");
    }

    @Nonnull
    public static EnumTankType getType(int meta) {
        return (EnumTankType)((Object)NullHelper.notnullJ((Object)((Object)EnumTankType.values()[meta >= 0 && meta < EnumTankType.values().length ? meta : 0]), (String)"Enum.values()"));
    }

    @Nonnull
    public static EnumTankType getType(@Nonnull ItemStack stack) {
        return EnumTankType.getType(stack.func_77960_j());
    }

    public static int getMeta(@Nonnull EnumTankType value) {
        return value.ordinal();
    }

    @Nonnull
    public SmartTank getTank() {
        return new SmartTank(this.size.get().intValue());
    }

    public boolean isExplosionResistant() {
        return this.explosionResistant;
    }

    @Nonnull
    public String getSuffix() {
        return this.suffix;
    }

    static void saveTank(ItemStack stack, SmartTank tank) {
        ItemTankHelper.setTank(stack, tank);
    }

    static SmartTank loadTank(ItemStack stack) {
        SmartTank tank;
        if (stack.func_77942_o() && (tank = ItemTankHelper.getTank(stack)) != null) {
            return tank;
        }
        return EnumTankType.getType(stack).getTank();
    }

    static {
        KIND = PropertyEnum.func_177709_a((String)"kind", EnumTankType.class);
    }
}

